package pts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPtsReportsBySceneId invokes the pts.GetPtsReportsBySceneId API synchronously
func (client *Client) GetPtsReportsBySceneId(request *GetPtsReportsBySceneIdRequest) (response *GetPtsReportsBySceneIdResponse, err error) {
	response = CreateGetPtsReportsBySceneIdResponse()
	err = client.DoAction(request, response)
	return
}

// GetPtsReportsBySceneIdWithChan invokes the pts.GetPtsReportsBySceneId API asynchronously
func (client *Client) GetPtsReportsBySceneIdWithChan(request *GetPtsReportsBySceneIdRequest) (<-chan *GetPtsReportsBySceneIdResponse, <-chan error) {
	responseChan := make(chan *GetPtsReportsBySceneIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPtsReportsBySceneId(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPtsReportsBySceneIdWithCallback invokes the pts.GetPtsReportsBySceneId API asynchronously
func (client *Client) GetPtsReportsBySceneIdWithCallback(request *GetPtsReportsBySceneIdRequest, callback func(response *GetPtsReportsBySceneIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPtsReportsBySceneIdResponse
		var err error
		defer close(result)
		response, err = client.GetPtsReportsBySceneId(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPtsReportsBySceneIdRequest is the request struct for api GetPtsReportsBySceneId
type GetPtsReportsBySceneIdRequest struct {
	*requests.RpcRequest
	SceneId    string           `position:"Query" name:"SceneId"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// GetPtsReportsBySceneIdResponse is the response struct for api GetPtsReportsBySceneId
type GetPtsReportsBySceneIdResponse struct {
	*responses.BaseResponse
	Message            string           `json:"Message" xml:"Message"`
	RequestId          string           `json:"RequestId" xml:"RequestId"`
	HttpStatusCode     int              `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code               string           `json:"Code" xml:"Code"`
	Success            bool             `json:"Success" xml:"Success"`
	ReportOverViewList []ReportOverView `json:"ReportOverViewList" xml:"ReportOverViewList"`
}

// CreateGetPtsReportsBySceneIdRequest creates a request to invoke GetPtsReportsBySceneId API
func CreateGetPtsReportsBySceneIdRequest() (request *GetPtsReportsBySceneIdRequest) {
	request = &GetPtsReportsBySceneIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PTS", "2020-10-20", "GetPtsReportsBySceneId", "", "")
	request.Method = requests.POST
	return
}

// CreateGetPtsReportsBySceneIdResponse creates a response to parse from GetPtsReportsBySceneId response
func CreateGetPtsReportsBySceneIdResponse() (response *GetPtsReportsBySceneIdResponse) {
	response = &GetPtsReportsBySceneIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
