package polardbx

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDBInstanceTopology invokes the polardbx.DescribeDBInstanceTopology API synchronously
func (client *Client) DescribeDBInstanceTopology(request *DescribeDBInstanceTopologyRequest) (response *DescribeDBInstanceTopologyResponse, err error) {
	response = CreateDescribeDBInstanceTopologyResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDBInstanceTopologyWithChan invokes the polardbx.DescribeDBInstanceTopology API asynchronously
func (client *Client) DescribeDBInstanceTopologyWithChan(request *DescribeDBInstanceTopologyRequest) (<-chan *DescribeDBInstanceTopologyResponse, <-chan error) {
	responseChan := make(chan *DescribeDBInstanceTopologyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDBInstanceTopology(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDBInstanceTopologyWithCallback invokes the polardbx.DescribeDBInstanceTopology API asynchronously
func (client *Client) DescribeDBInstanceTopologyWithCallback(request *DescribeDBInstanceTopologyRequest, callback func(response *DescribeDBInstanceTopologyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDBInstanceTopologyResponse
		var err error
		defer close(result)
		response, err = client.DescribeDBInstanceTopology(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDBInstanceTopologyRequest is the request struct for api DescribeDBInstanceTopology
type DescribeDBInstanceTopologyRequest struct {
	*requests.RpcRequest
	DBInstanceName string `position:"Query" name:"DBInstanceName"`
	StartTime      string `position:"Query" name:"StartTime"`
	EndTime        string `position:"Query" name:"EndTime"`
}

// DescribeDBInstanceTopologyResponse is the response struct for api DescribeDBInstanceTopology
type DescribeDBInstanceTopologyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribeDBInstanceTopologyRequest creates a request to invoke DescribeDBInstanceTopology API
func CreateDescribeDBInstanceTopologyRequest() (request *DescribeDBInstanceTopologyRequest) {
	request = &DescribeDBInstanceTopologyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardbx", "2020-02-02", "DescribeDBInstanceTopology", "polardbx", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDBInstanceTopologyResponse creates a response to parse from DescribeDBInstanceTopology response
func CreateDescribeDBInstanceTopologyResponse() (response *DescribeDBInstanceTopologyResponse) {
	response = &DescribeDBInstanceTopologyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
