package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePolarSQLCollectorPolicy invokes the polardb.DescribePolarSQLCollectorPolicy API synchronously
func (client *Client) DescribePolarSQLCollectorPolicy(request *DescribePolarSQLCollectorPolicyRequest) (response *DescribePolarSQLCollectorPolicyResponse, err error) {
	response = CreateDescribePolarSQLCollectorPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePolarSQLCollectorPolicyWithChan invokes the polardb.DescribePolarSQLCollectorPolicy API asynchronously
func (client *Client) DescribePolarSQLCollectorPolicyWithChan(request *DescribePolarSQLCollectorPolicyRequest) (<-chan *DescribePolarSQLCollectorPolicyResponse, <-chan error) {
	responseChan := make(chan *DescribePolarSQLCollectorPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePolarSQLCollectorPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePolarSQLCollectorPolicyWithCallback invokes the polardb.DescribePolarSQLCollectorPolicy API asynchronously
func (client *Client) DescribePolarSQLCollectorPolicyWithCallback(request *DescribePolarSQLCollectorPolicyRequest, callback func(response *DescribePolarSQLCollectorPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePolarSQLCollectorPolicyResponse
		var err error
		defer close(result)
		response, err = client.DescribePolarSQLCollectorPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePolarSQLCollectorPolicyRequest is the request struct for api DescribePolarSQLCollectorPolicy
type DescribePolarSQLCollectorPolicyRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribePolarSQLCollectorPolicyResponse is the response struct for api DescribePolarSQLCollectorPolicy
type DescribePolarSQLCollectorPolicyResponse struct {
	*responses.BaseResponse
	RequestId          string `json:"RequestId" xml:"RequestId"`
	SQLCollectorStatus string `json:"SQLCollectorStatus" xml:"SQLCollectorStatus"`
	DBClusterId        string `json:"DBClusterId" xml:"DBClusterId"`
}

// CreateDescribePolarSQLCollectorPolicyRequest creates a request to invoke DescribePolarSQLCollectorPolicy API
func CreateDescribePolarSQLCollectorPolicyRequest() (request *DescribePolarSQLCollectorPolicyRequest) {
	request = &DescribePolarSQLCollectorPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "DescribePolarSQLCollectorPolicy", "polardb", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribePolarSQLCollectorPolicyResponse creates a response to parse from DescribePolarSQLCollectorPolicy response
func CreateDescribePolarSQLCollectorPolicyResponse() (response *DescribePolarSQLCollectorPolicyResponse) {
	response = &DescribePolarSQLCollectorPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
