package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PushResourceRule invokes the pairecservice.PushResourceRule API synchronously
func (client *Client) PushResourceRule(request *PushResourceRuleRequest) (response *PushResourceRuleResponse, err error) {
	response = CreatePushResourceRuleResponse()
	err = client.DoAction(request, response)
	return
}

// PushResourceRuleWithChan invokes the pairecservice.PushResourceRule API asynchronously
func (client *Client) PushResourceRuleWithChan(request *PushResourceRuleRequest) (<-chan *PushResourceRuleResponse, <-chan error) {
	responseChan := make(chan *PushResourceRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PushResourceRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PushResourceRuleWithCallback invokes the pairecservice.PushResourceRule API asynchronously
func (client *Client) PushResourceRuleWithCallback(request *PushResourceRuleRequest, callback func(response *PushResourceRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PushResourceRuleResponse
		var err error
		defer close(result)
		response, err = client.PushResourceRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PushResourceRuleRequest is the request struct for api PushResourceRule
type PushResourceRuleRequest struct {
	*requests.RoaRequest
	ResourceRuleId string `position:"Path" name:"ResourceRuleId"`
	InstanceId     string `position:"Query" name:"InstanceId"`
	MetricInfo     string `position:"Query" name:"MetricInfo"`
}

// PushResourceRuleResponse is the response struct for api PushResourceRule
type PushResourceRuleResponse struct {
	*responses.BaseResponse
	RequestId               string          `json:"RequestId" xml:"RequestId"`
	ResourceRuleId          string          `json:"ResourceRuleId" xml:"ResourceRuleId"`
	Name                    string          `json:"Name" xml:"Name"`
	Description             string          `json:"Description" xml:"Description"`
	MetricOperationType     string          `json:"MetricOperationType" xml:"MetricOperationType"`
	MetricPullInfo          string          `json:"MetricPullInfo" xml:"MetricPullInfo"`
	MetricPullPeriod        string          `json:"MetricPullPeriod" xml:"MetricPullPeriod"`
	RuleComputingDefinition string          `json:"RuleComputingDefinition" xml:"RuleComputingDefinition"`
	RuleItems               []RuleItemsItem `json:"RuleItems" xml:"RuleItems"`
}

// CreatePushResourceRuleRequest creates a request to invoke PushResourceRule API
func CreatePushResourceRuleRequest() (request *PushResourceRuleRequest) {
	request = &PushResourceRuleRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "PushResourceRule", "/api/v1/resourcerules/[ResourceRuleId]/action/push", "", "")
	request.Method = requests.POST
	return
}

// CreatePushResourceRuleResponse creates a response to parse from PushResourceRule response
func CreatePushResourceRuleResponse() (response *PushResourceRuleResponse) {
	response = &PushResourceRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
