package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateEngineConfig invokes the pairecservice.CreateEngineConfig API synchronously
func (client *Client) CreateEngineConfig(request *CreateEngineConfigRequest) (response *CreateEngineConfigResponse, err error) {
	response = CreateCreateEngineConfigResponse()
	err = client.DoAction(request, response)
	return
}

// CreateEngineConfigWithChan invokes the pairecservice.CreateEngineConfig API asynchronously
func (client *Client) CreateEngineConfigWithChan(request *CreateEngineConfigRequest) (<-chan *CreateEngineConfigResponse, <-chan error) {
	responseChan := make(chan *CreateEngineConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateEngineConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateEngineConfigWithCallback invokes the pairecservice.CreateEngineConfig API asynchronously
func (client *Client) CreateEngineConfigWithCallback(request *CreateEngineConfigRequest, callback func(response *CreateEngineConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateEngineConfigResponse
		var err error
		defer close(result)
		response, err = client.CreateEngineConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateEngineConfigRequest is the request struct for api CreateEngineConfig
type CreateEngineConfigRequest struct {
	*requests.RoaRequest
	Body string `position:"Body" name:"body"`
}

// CreateEngineConfigResponse is the response struct for api CreateEngineConfig
type CreateEngineConfigResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	EngineConfigId string `json:"EngineConfigId" xml:"EngineConfigId"`
}

// CreateCreateEngineConfigRequest creates a request to invoke CreateEngineConfig API
func CreateCreateEngineConfigRequest() (request *CreateEngineConfigRequest) {
	request = &CreateEngineConfigRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "CreateEngineConfig", "/api/v1/engineconfigs", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateEngineConfigResponse creates a response to parse from CreateEngineConfig response
func CreateCreateEngineConfigResponse() (response *CreateEngineConfigResponse) {
	response = &CreateEngineConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
