package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetServiceSettings invokes the oos.GetServiceSettings API synchronously
func (client *Client) GetServiceSettings(request *GetServiceSettingsRequest) (response *GetServiceSettingsResponse, err error) {
	response = CreateGetServiceSettingsResponse()
	err = client.DoAction(request, response)
	return
}

// GetServiceSettingsWithChan invokes the oos.GetServiceSettings API asynchronously
func (client *Client) GetServiceSettingsWithChan(request *GetServiceSettingsRequest) (<-chan *GetServiceSettingsResponse, <-chan error) {
	responseChan := make(chan *GetServiceSettingsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetServiceSettings(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetServiceSettingsWithCallback invokes the oos.GetServiceSettings API asynchronously
func (client *Client) GetServiceSettingsWithCallback(request *GetServiceSettingsRequest, callback func(response *GetServiceSettingsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetServiceSettingsResponse
		var err error
		defer close(result)
		response, err = client.GetServiceSettings(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetServiceSettingsRequest is the request struct for api GetServiceSettings
type GetServiceSettingsRequest struct {
	*requests.RpcRequest
}

// GetServiceSettingsResponse is the response struct for api GetServiceSettings
type GetServiceSettingsResponse struct {
	*responses.BaseResponse
	RequestId       string           `json:"RequestId" xml:"RequestId"`
	ServiceSettings []ServiceSetting `json:"ServiceSettings" xml:"ServiceSettings"`
}

// CreateGetServiceSettingsRequest creates a request to invoke GetServiceSettings API
func CreateGetServiceSettingsRequest() (request *GetServiceSettingsRequest) {
	request = &GetServiceSettingsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "GetServiceSettings", "oos", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetServiceSettingsResponse creates a response to parse from GetServiceSettings response
func CreateGetServiceSettingsResponse() (response *GetServiceSettingsResponse) {
	response = &GetServiceSettingsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
