package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOpsItem invokes the oos.GetOpsItem API synchronously
func (client *Client) GetOpsItem(request *GetOpsItemRequest) (response *GetOpsItemResponse, err error) {
	response = CreateGetOpsItemResponse()
	err = client.DoAction(request, response)
	return
}

// GetOpsItemWithChan invokes the oos.GetOpsItem API asynchronously
func (client *Client) GetOpsItemWithChan(request *GetOpsItemRequest) (<-chan *GetOpsItemResponse, <-chan error) {
	responseChan := make(chan *GetOpsItemResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOpsItem(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOpsItemWithCallback invokes the oos.GetOpsItem API asynchronously
func (client *Client) GetOpsItemWithCallback(request *GetOpsItemRequest, callback func(response *GetOpsItemResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOpsItemResponse
		var err error
		defer close(result)
		response, err = client.GetOpsItem(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOpsItemRequest is the request struct for api GetOpsItem
type GetOpsItemRequest struct {
	*requests.RpcRequest
	OpsItemId string `position:"Query" name:"OpsItemId"`
}

// GetOpsItemResponse is the response struct for api GetOpsItem
type GetOpsItemResponse struct {
	*responses.BaseResponse
	RequestId string              `json:"RequestId" xml:"RequestId"`
	OpsItem   OpsItemInGetOpsItem `json:"OpsItem" xml:"OpsItem"`
}

// CreateGetOpsItemRequest creates a request to invoke GetOpsItem API
func CreateGetOpsItemRequest() (request *GetOpsItemRequest) {
	request = &GetOpsItemRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "GetOpsItem", "oos", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetOpsItemResponse creates a response to parse from GetOpsItem response
func CreateGetOpsItemResponse() (response *GetOpsItemResponse) {
	response = &GetOpsItemResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
