package oms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetMeasureData invokes the oms.GetMeasureData API synchronously
func (client *Client) GetMeasureData(request *GetMeasureDataRequest) (response *GetMeasureDataResponse, err error) {
	response = CreateGetMeasureDataResponse()
	err = client.DoAction(request, response)
	return
}

// GetMeasureDataWithChan invokes the oms.GetMeasureData API asynchronously
func (client *Client) GetMeasureDataWithChan(request *GetMeasureDataRequest) (<-chan *GetMeasureDataResponse, <-chan error) {
	responseChan := make(chan *GetMeasureDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetMeasureData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetMeasureDataWithCallback invokes the oms.GetMeasureData API asynchronously
func (client *Client) GetMeasureDataWithCallback(request *GetMeasureDataRequest, callback func(response *GetMeasureDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetMeasureDataResponse
		var err error
		defer close(result)
		response, err = client.GetMeasureData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetMeasureDataRequest is the request struct for api GetMeasureData
type GetMeasureDataRequest struct {
	*requests.RpcRequest
	Filter         string           `position:"Query" name:"Filter"`
	DomainCode     string           `position:"Query" name:"DomainCode"`
	DataType       string           `position:"Query" name:"DataType"`
	QueryField     string           `position:"Query" name:"QueryField"`
	NextToken      string           `position:"Query" name:"NextToken"`
	CompressEnable requests.Boolean `position:"Query" name:"CompressEnable"`
	ApiType        string           `position:"Query" name:"ApiType"`
	MaxResult      requests.Integer `position:"Query" name:"MaxResult"`
}

// GetMeasureDataResponse is the response struct for api GetMeasureData
type GetMeasureDataResponse struct {
	*responses.BaseResponse
	DataType   string `json:"DataType" xml:"DataType"`
	NextToken  string `json:"NextToken" xml:"NextToken"`
	Data       string `json:"Data" xml:"Data"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	DomainCode string `json:"DomainCode" xml:"DomainCode"`
	ApiType    string `json:"ApiType" xml:"ApiType"`
	Compressed bool   `json:"Compressed" xml:"Compressed"`
}

// CreateGetMeasureDataRequest creates a request to invoke GetMeasureData API
func CreateGetMeasureDataRequest() (request *GetMeasureDataRequest) {
	request = &GetMeasureDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Oms", "2016-06-15", "GetMeasureData", "", "")
	request.Method = requests.POST
	return
}

// CreateGetMeasureDataResponse creates a response to parse from GetMeasureData response
func CreateGetMeasureDataResponse() (response *GetMeasureDataResponse) {
	response = &GetMeasureDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
