package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopProject invokes the oceanbasepro.StopProject API synchronously
func (client *Client) StopProject(request *StopProjectRequest) (response *StopProjectResponse, err error) {
	response = CreateStopProjectResponse()
	err = client.DoAction(request, response)
	return
}

// StopProjectWithChan invokes the oceanbasepro.StopProject API asynchronously
func (client *Client) StopProjectWithChan(request *StopProjectRequest) (<-chan *StopProjectResponse, <-chan error) {
	responseChan := make(chan *StopProjectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopProject(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopProjectWithCallback invokes the oceanbasepro.StopProject API asynchronously
func (client *Client) StopProjectWithCallback(request *StopProjectRequest, callback func(response *StopProjectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopProjectResponse
		var err error
		defer close(result)
		response, err = client.StopProject(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopProjectRequest is the request struct for api StopProject
type StopProjectRequest struct {
	*requests.RpcRequest
	Id string `position:"Body" name:"Id"`
}

// StopProjectResponse is the response struct for api StopProject
type StopProjectResponse struct {
	*responses.BaseResponse
}

// CreateStopProjectRequest creates a request to invoke StopProject API
func CreateStopProjectRequest() (request *StopProjectRequest) {
	request = &StopProjectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "StopProject", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStopProjectResponse creates a response to parse from StopProject response
func CreateStopProjectResponse() (response *StopProjectResponse) {
	response = &StopProjectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
