package mse

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// EnableHttp2 invokes the mse.EnableHttp2 API synchronously
func (client *Client) EnableHttp2(request *EnableHttp2Request) (response *EnableHttp2Response, err error) {
	response = CreateEnableHttp2Response()
	err = client.DoAction(request, response)
	return
}

// EnableHttp2WithChan invokes the mse.EnableHttp2 API asynchronously
func (client *Client) EnableHttp2WithChan(request *EnableHttp2Request) (<-chan *EnableHttp2Response, <-chan error) {
	responseChan := make(chan *EnableHttp2Response, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.EnableHttp2(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// EnableHttp2WithCallback invokes the mse.EnableHttp2 API asynchronously
func (client *Client) EnableHttp2WithCallback(request *EnableHttp2Request, callback func(response *EnableHttp2Response, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *EnableHttp2Response
		var err error
		defer close(result)
		response, err = client.EnableHttp2(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// EnableHttp2Request is the request struct for api EnableHttp2
type EnableHttp2Request struct {
	*requests.RpcRequest
	MseSessionId    string           `position:"Query" name:"MseSessionId"`
	GatewayUniqueId string           `position:"Query" name:"GatewayUniqueId"`
	EnableHttp2     requests.Boolean `position:"Query" name:"EnableHttp2"`
	AcceptLanguage  string           `position:"Query" name:"AcceptLanguage"`
}

// EnableHttp2Response is the response struct for api EnableHttp2
type EnableHttp2Response struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           int    `json:"Code" xml:"Code"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	Data           bool   `json:"Data" xml:"Data"`
}

// CreateEnableHttp2Request creates a request to invoke EnableHttp2 API
func CreateEnableHttp2Request() (request *EnableHttp2Request) {
	request = &EnableHttp2Request{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mse", "2019-05-31", "EnableHttp2", "mse", "openAPI")
	request.Method = requests.POST
	return
}

// CreateEnableHttp2Response creates a response to parse from EnableHttp2 response
func CreateEnableHttp2Response() (response *EnableHttp2Response) {
	response = &EnableHttp2Response{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
