package mpaas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OpenApiQueryActiveCode invokes the mpaas.OpenApiQueryActiveCode API synchronously
func (client *Client) OpenApiQueryActiveCode(request *OpenApiQueryActiveCodeRequest) (response *OpenApiQueryActiveCodeResponse, err error) {
	response = CreateOpenApiQueryActiveCodeResponse()
	err = client.DoAction(request, response)
	return
}

// OpenApiQueryActiveCodeWithChan invokes the mpaas.OpenApiQueryActiveCode API asynchronously
func (client *Client) OpenApiQueryActiveCodeWithChan(request *OpenApiQueryActiveCodeRequest) (<-chan *OpenApiQueryActiveCodeResponse, <-chan error) {
	responseChan := make(chan *OpenApiQueryActiveCodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OpenApiQueryActiveCode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OpenApiQueryActiveCodeWithCallback invokes the mpaas.OpenApiQueryActiveCode API asynchronously
func (client *Client) OpenApiQueryActiveCodeWithCallback(request *OpenApiQueryActiveCodeRequest, callback func(response *OpenApiQueryActiveCodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OpenApiQueryActiveCodeResponse
		var err error
		defer close(result)
		response, err = client.OpenApiQueryActiveCode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OpenApiQueryActiveCodeRequest is the request struct for api OpenApiQueryActiveCode
type OpenApiQueryActiveCodeRequest struct {
	*requests.RpcRequest
	TenantId                                  string `position:"Body" name:"TenantId"`
	AppId                                     string `position:"Body" name:"AppId"`
	MpaasMqcpOpenApiQueryActiveCodeReqJsonStr string `position:"Body" name:"MpaasMqcpOpenApiQueryActiveCodeReqJsonStr"`
	WorkspaceId                               string `position:"Body" name:"WorkspaceId"`
}

// OpenApiQueryActiveCodeResponse is the response struct for api OpenApiQueryActiveCode
type OpenApiQueryActiveCodeResponse struct {
	*responses.BaseResponse
	ResultMessage string `json:"ResultMessage" xml:"ResultMessage"`
	ResultCode    string `json:"ResultCode" xml:"ResultCode"`
	RequestId     string `json:"RequestId" xml:"RequestId"`
	ResultContent string `json:"ResultContent" xml:"ResultContent"`
}

// CreateOpenApiQueryActiveCodeRequest creates a request to invoke OpenApiQueryActiveCode API
func CreateOpenApiQueryActiveCodeRequest() (request *OpenApiQueryActiveCodeRequest) {
	request = &OpenApiQueryActiveCodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("mPaaS", "2020-10-28", "OpenApiQueryActiveCode", "", "")
	request.Method = requests.POST
	return
}

// CreateOpenApiQueryActiveCodeResponse creates a response to parse from OpenApiQueryActiveCode response
func CreateOpenApiQueryActiveCodeResponse() (response *OpenApiQueryActiveCodeResponse) {
	response = &OpenApiQueryActiveCodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
