package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLiveDomainLogExTtl invokes the live.DescribeLiveDomainLogExTtl API synchronously
func (client *Client) DescribeLiveDomainLogExTtl(request *DescribeLiveDomainLogExTtlRequest) (response *DescribeLiveDomainLogExTtlResponse, err error) {
	response = CreateDescribeLiveDomainLogExTtlResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLiveDomainLogExTtlWithChan invokes the live.DescribeLiveDomainLogExTtl API asynchronously
func (client *Client) DescribeLiveDomainLogExTtlWithChan(request *DescribeLiveDomainLogExTtlRequest) (<-chan *DescribeLiveDomainLogExTtlResponse, <-chan error) {
	responseChan := make(chan *DescribeLiveDomainLogExTtlResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLiveDomainLogExTtl(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLiveDomainLogExTtlWithCallback invokes the live.DescribeLiveDomainLogExTtl API asynchronously
func (client *Client) DescribeLiveDomainLogExTtlWithCallback(request *DescribeLiveDomainLogExTtlRequest, callback func(response *DescribeLiveDomainLogExTtlResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLiveDomainLogExTtlResponse
		var err error
		defer close(result)
		response, err = client.DescribeLiveDomainLogExTtl(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLiveDomainLogExTtlRequest is the request struct for api DescribeLiveDomainLogExTtl
type DescribeLiveDomainLogExTtlRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Query" name:"StartTime"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	LogType    string           `position:"Query" name:"LogType"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeLiveDomainLogExTtlResponse is the response struct for api DescribeLiveDomainLogExTtl
type DescribeLiveDomainLogExTtlResponse struct {
	*responses.BaseResponse
	DomainName       string                                       `json:"DomainName" xml:"DomainName"`
	RequestId        string                                       `json:"RequestId" xml:"RequestId"`
	DomainLogDetails DomainLogDetailsInDescribeLiveDomainLogExTtl `json:"DomainLogDetails" xml:"DomainLogDetails"`
}

// CreateDescribeLiveDomainLogExTtlRequest creates a request to invoke DescribeLiveDomainLogExTtl API
func CreateDescribeLiveDomainLogExTtlRequest() (request *DescribeLiveDomainLogExTtlRequest) {
	request = &DescribeLiveDomainLogExTtlRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeLiveDomainLogExTtl", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeLiveDomainLogExTtlResponse creates a response to parse from DescribeLiveDomainLogExTtl response
func CreateDescribeLiveDomainLogExTtlResponse() (response *DescribeLiveDomainLogExTtlResponse) {
	response = &DescribeLiveDomainLogExTtlResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
