package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLiveSpecificStagingConfig invokes the live.DeleteLiveSpecificStagingConfig API synchronously
func (client *Client) DeleteLiveSpecificStagingConfig(request *DeleteLiveSpecificStagingConfigRequest) (response *DeleteLiveSpecificStagingConfigResponse, err error) {
	response = CreateDeleteLiveSpecificStagingConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLiveSpecificStagingConfigWithChan invokes the live.DeleteLiveSpecificStagingConfig API asynchronously
func (client *Client) DeleteLiveSpecificStagingConfigWithChan(request *DeleteLiveSpecificStagingConfigRequest) (<-chan *DeleteLiveSpecificStagingConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteLiveSpecificStagingConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLiveSpecificStagingConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLiveSpecificStagingConfigWithCallback invokes the live.DeleteLiveSpecificStagingConfig API asynchronously
func (client *Client) DeleteLiveSpecificStagingConfigWithCallback(request *DeleteLiveSpecificStagingConfigRequest, callback func(response *DeleteLiveSpecificStagingConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLiveSpecificStagingConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteLiveSpecificStagingConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLiveSpecificStagingConfigRequest is the request struct for api DeleteLiveSpecificStagingConfig
type DeleteLiveSpecificStagingConfigRequest struct {
	*requests.RpcRequest
	SecurityToken string           `position:"Query" name:"SecurityToken"`
	DomainName    string           `position:"Query" name:"DomainName"`
	OwnerId       requests.Integer `position:"Query" name:"OwnerId"`
	ConfigId      string           `position:"Query" name:"ConfigId"`
}

// DeleteLiveSpecificStagingConfigResponse is the response struct for api DeleteLiveSpecificStagingConfig
type DeleteLiveSpecificStagingConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLiveSpecificStagingConfigRequest creates a request to invoke DeleteLiveSpecificStagingConfig API
func CreateDeleteLiveSpecificStagingConfigRequest() (request *DeleteLiveSpecificStagingConfigRequest) {
	request = &DeleteLiveSpecificStagingConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DeleteLiveSpecificStagingConfig", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteLiveSpecificStagingConfigResponse creates a response to parse from DeleteLiveSpecificStagingConfig response
func CreateDeleteLiveSpecificStagingConfigResponse() (response *DeleteLiveSpecificStagingConfigResponse) {
	response = &DeleteLiveSpecificStagingConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
