package linkwan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListActiveGateways invokes the linkwan.ListActiveGateways API synchronously
func (client *Client) ListActiveGateways(request *ListActiveGatewaysRequest) (response *ListActiveGatewaysResponse, err error) {
	response = CreateListActiveGatewaysResponse()
	err = client.DoAction(request, response)
	return
}

// ListActiveGatewaysWithChan invokes the linkwan.ListActiveGateways API asynchronously
func (client *Client) ListActiveGatewaysWithChan(request *ListActiveGatewaysRequest) (<-chan *ListActiveGatewaysResponse, <-chan error) {
	responseChan := make(chan *ListActiveGatewaysResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListActiveGateways(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListActiveGatewaysWithCallback invokes the linkwan.ListActiveGateways API asynchronously
func (client *Client) ListActiveGatewaysWithCallback(request *ListActiveGatewaysRequest, callback func(response *ListActiveGatewaysResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListActiveGatewaysResponse
		var err error
		defer close(result)
		response, err = client.ListActiveGateways(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListActiveGatewaysRequest is the request struct for api ListActiveGateways
type ListActiveGatewaysRequest struct {
	*requests.RpcRequest
	ApiProduct  string `position:"Body" name:"ApiProduct"`
	ApiRevision string `position:"Body" name:"ApiRevision"`
}

// ListActiveGatewaysResponse is the response struct for api ListActiveGateways
type ListActiveGatewaysResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Success   bool      `json:"Success" xml:"Success"`
	Data      []Gateway `json:"Data" xml:"Data"`
}

// CreateListActiveGatewaysRequest creates a request to invoke ListActiveGateways API
func CreateListActiveGatewaysRequest() (request *ListActiveGatewaysRequest) {
	request = &ListActiveGatewaysRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("LinkWAN", "2019-03-01", "ListActiveGateways", "linkwan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListActiveGatewaysResponse creates a response to parse from ListActiveGateways response
func CreateListActiveGatewaysResponse() (response *ListActiveGatewaysResponse) {
	response = &ListActiveGatewaysResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
