package iqa

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeployService invokes the iqa.DeployService API synchronously
// api document: https://help.aliyun.com/api/iqa/deployservice.html
func (client *Client) DeployService(request *DeployServiceRequest) (response *DeployServiceResponse, err error) {
	response = CreateDeployServiceResponse()
	err = client.DoAction(request, response)
	return
}

// DeployServiceWithChan invokes the iqa.DeployService API asynchronously
// api document: https://help.aliyun.com/api/iqa/deployservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeployServiceWithChan(request *DeployServiceRequest) (<-chan *DeployServiceResponse, <-chan error) {
	responseChan := make(chan *DeployServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeployService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeployServiceWithCallback invokes the iqa.DeployService API asynchronously
// api document: https://help.aliyun.com/api/iqa/deployservice.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeployServiceWithCallback(request *DeployServiceRequest, callback func(response *DeployServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeployServiceResponse
		var err error
		defer close(result)
		response, err = client.DeployService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeployServiceRequest is the request struct for api DeployService
type DeployServiceRequest struct {
	*requests.RpcRequest
	ProjectId string `position:"Query" name:"ProjectId"`
}

// DeployServiceResponse is the response struct for api DeployService
type DeployServiceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeployServiceRequest creates a request to invoke DeployService API
func CreateDeployServiceRequest() (request *DeployServiceRequest) {
	request = &DeployServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("iqa", "2019-08-13", "DeployService", "iqa", "openAPI")
	return
}

// CreateDeployServiceResponse creates a response to parse from DeployService response
func CreateDeployServiceResponse() (response *DeployServiceResponse) {
	response = &DeployServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
