package ga

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DissociateAclsFromListener invokes the ga.DissociateAclsFromListener API synchronously
func (client *Client) DissociateAclsFromListener(request *DissociateAclsFromListenerRequest) (response *DissociateAclsFromListenerResponse, err error) {
	response = CreateDissociateAclsFromListenerResponse()
	err = client.DoAction(request, response)
	return
}

// DissociateAclsFromListenerWithChan invokes the ga.DissociateAclsFromListener API asynchronously
func (client *Client) DissociateAclsFromListenerWithChan(request *DissociateAclsFromListenerRequest) (<-chan *DissociateAclsFromListenerResponse, <-chan error) {
	responseChan := make(chan *DissociateAclsFromListenerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DissociateAclsFromListener(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DissociateAclsFromListenerWithCallback invokes the ga.DissociateAclsFromListener API asynchronously
func (client *Client) DissociateAclsFromListenerWithCallback(request *DissociateAclsFromListenerRequest, callback func(response *DissociateAclsFromListenerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DissociateAclsFromListenerResponse
		var err error
		defer close(result)
		response, err = client.DissociateAclsFromListener(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DissociateAclsFromListenerRequest is the request struct for api DissociateAclsFromListener
type DissociateAclsFromListenerRequest struct {
	*requests.RpcRequest
	DryRun      requests.Boolean `position:"Query" name:"DryRun"`
	ClientToken string           `position:"Query" name:"ClientToken"`
	AclIds      *[]string        `position:"Query" name:"AclIds"  type:"Repeated"`
	ListenerId  string           `position:"Query" name:"ListenerId"`
}

// DissociateAclsFromListenerResponse is the response struct for api DissociateAclsFromListener
type DissociateAclsFromListenerResponse struct {
	*responses.BaseResponse
	RequestId  string   `json:"RequestId" xml:"RequestId"`
	ListenerId string   `json:"ListenerId" xml:"ListenerId"`
	AclIds     []string `json:"AclIds" xml:"AclIds"`
}

// CreateDissociateAclsFromListenerRequest creates a request to invoke DissociateAclsFromListener API
func CreateDissociateAclsFromListenerRequest() (request *DissociateAclsFromListenerRequest) {
	request = &DissociateAclsFromListenerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ga", "2019-11-20", "DissociateAclsFromListener", "gaplus", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDissociateAclsFromListenerResponse creates a response to parse from DissociateAclsFromListener response
func CreateDissociateAclsFromListenerResponse() (response *DissociateAclsFromListenerResponse) {
	response = &DissociateAclsFromListenerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
