package facebody

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MergeImageFace invokes the facebody.MergeImageFace API synchronously
func (client *Client) MergeImageFace(request *MergeImageFaceRequest) (response *MergeImageFaceResponse, err error) {
	response = CreateMergeImageFaceResponse()
	err = client.DoAction(request, response)
	return
}

// MergeImageFaceWithChan invokes the facebody.MergeImageFace API asynchronously
func (client *Client) MergeImageFaceWithChan(request *MergeImageFaceRequest) (<-chan *MergeImageFaceResponse, <-chan error) {
	responseChan := make(chan *MergeImageFaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MergeImageFace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MergeImageFaceWithCallback invokes the facebody.MergeImageFace API asynchronously
func (client *Client) MergeImageFaceWithCallback(request *MergeImageFaceRequest, callback func(response *MergeImageFaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MergeImageFaceResponse
		var err error
		defer close(result)
		response, err = client.MergeImageFace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MergeImageFaceRequest is the request struct for api MergeImageFace
type MergeImageFaceRequest struct {
	*requests.RpcRequest
	FormatResultToJson requests.Boolean            `position:"Query" name:"FormatResultToJson"`
	MergeInfos         *[]MergeImageFaceMergeInfos `position:"Body" name:"MergeInfos"  type:"Repeated"`
	UserId             string                      `position:"Body" name:"UserId"`
	WatermarkType      string                      `position:"Body" name:"WatermarkType"`
	OssFile            string                      `position:"Query" name:"OssFile"`
	TemplateId         string                      `position:"Body" name:"TemplateId"`
	RequestProxyBy     string                      `position:"Query" name:"RequestProxyBy"`
	ImageURL           string                      `position:"Body" name:"ImageURL"`
	AddWatermark       requests.Boolean            `position:"Body" name:"AddWatermark"`
	ModelVersion       string                      `position:"Body" name:"ModelVersion"`
}

// MergeImageFaceMergeInfos is a repeated param struct in MergeImageFaceRequest
type MergeImageFaceMergeInfos struct {
	ImageURL       string `name:"ImageURL"`
	TemplateFaceID string `name:"TemplateFaceID"`
}

// MergeImageFaceResponse is the response struct for api MergeImageFace
type MergeImageFaceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateMergeImageFaceRequest creates a request to invoke MergeImageFace API
func CreateMergeImageFaceRequest() (request *MergeImageFaceRequest) {
	request = &MergeImageFaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("facebody", "2019-12-30", "MergeImageFace", "facebody", "openAPI")
	request.Method = requests.POST
	return
}

// CreateMergeImageFaceResponse creates a response to parse from MergeImageFace response
func CreateMergeImageFaceResponse() (response *MergeImageFaceResponse) {
	response = &MergeImageFaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
