package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeARMServerInstances invokes the ens.DescribeARMServerInstances API synchronously
func (client *Client) DescribeARMServerInstances(request *DescribeARMServerInstancesRequest) (response *DescribeARMServerInstancesResponse, err error) {
	response = CreateDescribeARMServerInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeARMServerInstancesWithChan invokes the ens.DescribeARMServerInstances API asynchronously
func (client *Client) DescribeARMServerInstancesWithChan(request *DescribeARMServerInstancesRequest) (<-chan *DescribeARMServerInstancesResponse, <-chan error) {
	responseChan := make(chan *DescribeARMServerInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeARMServerInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeARMServerInstancesWithCallback invokes the ens.DescribeARMServerInstances API asynchronously
func (client *Client) DescribeARMServerInstancesWithCallback(request *DescribeARMServerInstancesRequest, callback func(response *DescribeARMServerInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeARMServerInstancesResponse
		var err error
		defer close(result)
		response, err = client.DescribeARMServerInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeARMServerInstancesRequest is the request struct for api DescribeARMServerInstances
type DescribeARMServerInstancesRequest struct {
	*requests.RpcRequest
	AICSpecs             *[]string        `position:"Query" name:"AICSpecs"  type:"Json"`
	OrderByParams        string           `position:"Query" name:"OrderByParams"`
	DescribeAICInstances requests.Boolean `position:"Query" name:"DescribeAICInstances"`
	ServerIds            *[]string        `position:"Query" name:"ServerIds"  type:"Json"`
	Name                 string           `position:"Query" name:"Name"`
	MaxDate              string           `position:"Query" name:"MaxDate"`
	PageNumber           requests.Integer `position:"Query" name:"PageNumber"`
	States               *[]string        `position:"Query" name:"States"  type:"Json"`
	ServerSpecs          *[]string        `position:"Query" name:"ServerSpecs"  type:"Json"`
	PageSize             requests.Integer `position:"Query" name:"PageSize"`
	EnsRegionIds         *[]string        `position:"Query" name:"EnsRegionIds"  type:"Json"`
	MinDate              string           `position:"Query" name:"MinDate"`
	Namespace            string           `position:"Query" name:"Namespace"`
}

// DescribeARMServerInstancesResponse is the response struct for api DescribeARMServerInstances
type DescribeARMServerInstancesResponse struct {
	*responses.BaseResponse
	RequestId  string        `json:"RequestId" xml:"RequestId"`
	PageNumber int           `json:"PageNumber" xml:"PageNumber"`
	PageSize   int           `json:"PageSize" xml:"PageSize"`
	TotalCount int           `json:"TotalCount" xml:"TotalCount"`
	Servers    []ServersItem `json:"Servers" xml:"Servers"`
}

// CreateDescribeARMServerInstancesRequest creates a request to invoke DescribeARMServerInstances API
func CreateDescribeARMServerInstancesRequest() (request *DescribeARMServerInstancesRequest) {
	request = &DescribeARMServerInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeARMServerInstances", "ens", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeARMServerInstancesResponse creates a response to parse from DescribeARMServerInstances response
func CreateDescribeARMServerInstancesResponse() (response *DescribeARMServerInstancesResponse) {
	response = &DescribeARMServerInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
