package ebs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDiskReplicaPairProgress invokes the ebs.DescribeDiskReplicaPairProgress API synchronously
func (client *Client) DescribeDiskReplicaPairProgress(request *DescribeDiskReplicaPairProgressRequest) (response *DescribeDiskReplicaPairProgressResponse, err error) {
	response = CreateDescribeDiskReplicaPairProgressResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDiskReplicaPairProgressWithChan invokes the ebs.DescribeDiskReplicaPairProgress API asynchronously
func (client *Client) DescribeDiskReplicaPairProgressWithChan(request *DescribeDiskReplicaPairProgressRequest) (<-chan *DescribeDiskReplicaPairProgressResponse, <-chan error) {
	responseChan := make(chan *DescribeDiskReplicaPairProgressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDiskReplicaPairProgress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDiskReplicaPairProgressWithCallback invokes the ebs.DescribeDiskReplicaPairProgress API asynchronously
func (client *Client) DescribeDiskReplicaPairProgressWithCallback(request *DescribeDiskReplicaPairProgressRequest, callback func(response *DescribeDiskReplicaPairProgressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDiskReplicaPairProgressResponse
		var err error
		defer close(result)
		response, err = client.DescribeDiskReplicaPairProgress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDiskReplicaPairProgressRequest is the request struct for api DescribeDiskReplicaPairProgress
type DescribeDiskReplicaPairProgressRequest struct {
	*requests.RpcRequest
	ReplicaPairId string `position:"Query" name:"ReplicaPairId"`
}

// DescribeDiskReplicaPairProgressResponse is the response struct for api DescribeDiskReplicaPairProgress
type DescribeDiskReplicaPairProgressResponse struct {
	*responses.BaseResponse
	Progress     int    `json:"Progress" xml:"Progress"`
	RecoverPoint int64  `json:"RecoverPoint" xml:"RecoverPoint"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeDiskReplicaPairProgressRequest creates a request to invoke DescribeDiskReplicaPairProgress API
func CreateDescribeDiskReplicaPairProgressRequest() (request *DescribeDiskReplicaPairProgressRequest) {
	request = &DescribeDiskReplicaPairProgressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ebs", "2021-07-30", "DescribeDiskReplicaPairProgress", "ebs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDiskReplicaPairProgressResponse creates a response to parse from DescribeDiskReplicaPairProgress response
func CreateDescribeDiskReplicaPairProgressResponse() (response *DescribeDiskReplicaPairProgressResponse) {
	response = &DescribeDiskReplicaPairProgressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
