package dysmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteExtCodeSign invokes the dysmsapi.DeleteExtCodeSign API synchronously
func (client *Client) DeleteExtCodeSign(request *DeleteExtCodeSignRequest) (response *DeleteExtCodeSignResponse, err error) {
	response = CreateDeleteExtCodeSignResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteExtCodeSignWithChan invokes the dysmsapi.DeleteExtCodeSign API asynchronously
func (client *Client) DeleteExtCodeSignWithChan(request *DeleteExtCodeSignRequest) (<-chan *DeleteExtCodeSignResponse, <-chan error) {
	responseChan := make(chan *DeleteExtCodeSignResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteExtCodeSign(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteExtCodeSignWithCallback invokes the dysmsapi.DeleteExtCodeSign API asynchronously
func (client *Client) DeleteExtCodeSignWithCallback(request *DeleteExtCodeSignRequest, callback func(response *DeleteExtCodeSignResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteExtCodeSignResponse
		var err error
		defer close(result)
		response, err = client.DeleteExtCodeSign(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteExtCodeSignRequest is the request struct for api DeleteExtCodeSign
type DeleteExtCodeSignRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	LowcodeTenantId      string           `position:"Query" name:"LowcodeTenantId"`
	ExtendFunction       string           `position:"Query" name:"ExtendFunction"`
	LowcodePhysicAppName string           `position:"Query" name:"LowcodePhysicAppName"`
	SignName             string           `position:"Query" name:"SignName"`
	RouteName            string           `position:"Query" name:"RouteName"`
	ExtCode              string           `position:"Query" name:"ExtCode"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	LowcodeLogicAppName  string           `position:"Query" name:"LowcodeLogicAppName"`
}

// DeleteExtCodeSignResponse is the response struct for api DeleteExtCodeSign
type DeleteExtCodeSignResponse struct {
	*responses.BaseResponse
	AccessDeniedDetail string `json:"AccessDeniedDetail" xml:"AccessDeniedDetail"`
	RequestId          string `json:"RequestId" xml:"RequestId"`
	Message            string `json:"Message" xml:"Message"`
	Data               bool   `json:"Data" xml:"Data"`
	Code               string `json:"Code" xml:"Code"`
	Success            bool   `json:"Success" xml:"Success"`
}

// CreateDeleteExtCodeSignRequest creates a request to invoke DeleteExtCodeSign API
func CreateDeleteExtCodeSignRequest() (request *DeleteExtCodeSignRequest) {
	request = &DeleteExtCodeSignRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dysmsapi", "2017-05-25", "DeleteExtCodeSign", "dysms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteExtCodeSignResponse creates a response to parse from DeleteExtCodeSign response
func CreateDeleteExtCodeSignResponse() (response *DeleteExtCodeSignResponse) {
	response = &DeleteExtCodeSignResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
