package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SetupDomainAutoRenew invokes the domain.SetupDomainAutoRenew API synchronously
func (client *Client) SetupDomainAutoRenew(request *SetupDomainAutoRenewRequest) (response *SetupDomainAutoRenewResponse, err error) {
	response = CreateSetupDomainAutoRenewResponse()
	err = client.DoAction(request, response)
	return
}

// SetupDomainAutoRenewWithChan invokes the domain.SetupDomainAutoRenew API asynchronously
func (client *Client) SetupDomainAutoRenewWithChan(request *SetupDomainAutoRenewRequest) (<-chan *SetupDomainAutoRenewResponse, <-chan error) {
	responseChan := make(chan *SetupDomainAutoRenewResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SetupDomainAutoRenew(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SetupDomainAutoRenewWithCallback invokes the domain.SetupDomainAutoRenew API asynchronously
func (client *Client) SetupDomainAutoRenewWithCallback(request *SetupDomainAutoRenewRequest, callback func(response *SetupDomainAutoRenewResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SetupDomainAutoRenewResponse
		var err error
		defer close(result)
		response, err = client.SetupDomainAutoRenew(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SetupDomainAutoRenewRequest is the request struct for api SetupDomainAutoRenew
type SetupDomainAutoRenewRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
	Operation  string `position:"Query" name:"Operation"`
}

// SetupDomainAutoRenewResponse is the response struct for api SetupDomainAutoRenew
type SetupDomainAutoRenewResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
}

// CreateSetupDomainAutoRenewRequest creates a request to invoke SetupDomainAutoRenew API
func CreateSetupDomainAutoRenewRequest() (request *SetupDomainAutoRenewRequest) {
	request = &SetupDomainAutoRenewRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "SetupDomainAutoRenew", "domain", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSetupDomainAutoRenewResponse creates a response to parse from SetupDomainAutoRenew response
func CreateSetupDomainAutoRenewResponse() (response *SetupDomainAutoRenewResponse) {
	response = &SetupDomainAutoRenewResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
