package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPermApplyOrderDetail invokes the dms_enterprise.GetPermApplyOrderDetail API synchronously
func (client *Client) GetPermApplyOrderDetail(request *GetPermApplyOrderDetailRequest) (response *GetPermApplyOrderDetailResponse, err error) {
	response = CreateGetPermApplyOrderDetailResponse()
	err = client.DoAction(request, response)
	return
}

// GetPermApplyOrderDetailWithChan invokes the dms_enterprise.GetPermApplyOrderDetail API asynchronously
func (client *Client) GetPermApplyOrderDetailWithChan(request *GetPermApplyOrderDetailRequest) (<-chan *GetPermApplyOrderDetailResponse, <-chan error) {
	responseChan := make(chan *GetPermApplyOrderDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPermApplyOrderDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPermApplyOrderDetailWithCallback invokes the dms_enterprise.GetPermApplyOrderDetail API asynchronously
func (client *Client) GetPermApplyOrderDetailWithCallback(request *GetPermApplyOrderDetailRequest, callback func(response *GetPermApplyOrderDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPermApplyOrderDetailResponse
		var err error
		defer close(result)
		response, err = client.GetPermApplyOrderDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPermApplyOrderDetailRequest is the request struct for api GetPermApplyOrderDetail
type GetPermApplyOrderDetailRequest struct {
	*requests.RpcRequest
	Tid     requests.Integer `position:"Query" name:"Tid"`
	OrderId requests.Integer `position:"Query" name:"OrderId"`
}

// GetPermApplyOrderDetailResponse is the response struct for api GetPermApplyOrderDetail
type GetPermApplyOrderDetailResponse struct {
	*responses.BaseResponse
	RequestId            string               `json:"RequestId" xml:"RequestId"`
	Success              bool                 `json:"Success" xml:"Success"`
	ErrorMessage         string               `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode            string               `json:"ErrorCode" xml:"ErrorCode"`
	PermApplyOrderDetail PermApplyOrderDetail `json:"PermApplyOrderDetail" xml:"PermApplyOrderDetail"`
}

// CreateGetPermApplyOrderDetailRequest creates a request to invoke GetPermApplyOrderDetail API
func CreateGetPermApplyOrderDetailRequest() (request *GetPermApplyOrderDetailRequest) {
	request = &GetPermApplyOrderDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GetPermApplyOrderDetail", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetPermApplyOrderDetailResponse creates a response to parse from GetPermApplyOrderDetail response
func CreateGetPermApplyOrderDetailResponse() (response *GetPermApplyOrderDetailResponse) {
	response = &GetPermApplyOrderDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
