package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListProjectRoles invokes the dataworks_public.ListProjectRoles API synchronously
func (client *Client) ListProjectRoles(request *ListProjectRolesRequest) (response *ListProjectRolesResponse, err error) {
	response = CreateListProjectRolesResponse()
	err = client.DoAction(request, response)
	return
}

// ListProjectRolesWithChan invokes the dataworks_public.ListProjectRoles API asynchronously
func (client *Client) ListProjectRolesWithChan(request *ListProjectRolesRequest) (<-chan *ListProjectRolesResponse, <-chan error) {
	responseChan := make(chan *ListProjectRolesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListProjectRoles(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListProjectRolesWithCallback invokes the dataworks_public.ListProjectRoles API asynchronously
func (client *Client) ListProjectRolesWithCallback(request *ListProjectRolesRequest, callback func(response *ListProjectRolesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListProjectRolesResponse
		var err error
		defer close(result)
		response, err = client.ListProjectRoles(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListProjectRolesRequest is the request struct for api ListProjectRoles
type ListProjectRolesRequest struct {
	*requests.RpcRequest
	ProjectId requests.Integer `position:"Query" name:"ProjectId"`
}

// ListProjectRolesResponse is the response struct for api ListProjectRoles
type ListProjectRolesResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	ProjectRoleList []Role `json:"ProjectRoleList" xml:"ProjectRoleList"`
}

// CreateListProjectRolesRequest creates a request to invoke ListProjectRoles API
func CreateListProjectRolesRequest() (request *ListProjectRolesRequest) {
	request = &ListProjectRolesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListProjectRoles", "", "")
	request.Method = requests.POST
	return
}

// CreateListProjectRolesResponse creates a response to parse from ListProjectRoles response
func CreateListProjectRolesResponse() (response *ListProjectRolesResponse) {
	response = &ListProjectRolesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
