package computenestsupplier

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateService invokes the computenestsupplier.CreateService API synchronously
func (client *Client) CreateService(request *CreateServiceRequest) (response *CreateServiceResponse, err error) {
	response = CreateCreateServiceResponse()
	err = client.DoAction(request, response)
	return
}

// CreateServiceWithChan invokes the computenestsupplier.CreateService API asynchronously
func (client *Client) CreateServiceWithChan(request *CreateServiceRequest) (<-chan *CreateServiceResponse, <-chan error) {
	responseChan := make(chan *CreateServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateServiceWithCallback invokes the computenestsupplier.CreateService API asynchronously
func (client *Client) CreateServiceWithCallback(request *CreateServiceRequest, callback func(response *CreateServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateServiceResponse
		var err error
		defer close(result)
		response, err = client.CreateService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateServiceRequest is the request struct for api CreateService
type CreateServiceRequest struct {
	*requests.RpcRequest
	PolicyNames          string                      `position:"Query" name:"PolicyNames"`
	ResourceGroupId      string                      `position:"Query" name:"ResourceGroupId"`
	ApprovalType         string                      `position:"Query" name:"ApprovalType"`
	TrialDuration        requests.Integer            `position:"Query" name:"TrialDuration"`
	Tag                  *[]CreateServiceTag         `position:"Query" name:"Tag"  type:"Repeated"`
	OperationMetadata    string                      `position:"Query" name:"OperationMetadata"`
	DeployType           string                      `position:"Query" name:"DeployType"`
	AlarmMetadata        string                      `position:"Query" name:"AlarmMetadata"`
	Resellable           requests.Boolean            `position:"Query" name:"Resellable"`
	ClientToken          string                      `position:"Query" name:"ClientToken"`
	SourceServiceId      string                      `position:"Query" name:"SourceServiceId"`
	SourceServiceVersion string                      `position:"Query" name:"SourceServiceVersion"`
	LicenseMetadata      string                      `position:"Query" name:"LicenseMetadata"`
	Duration             requests.Integer            `position:"Query" name:"Duration"`
	ShareType            string                      `position:"Query" name:"ShareType"`
	BuildParameters      string                      `position:"Query" name:"BuildParameters"`
	UpgradeMetadata      string                      `position:"Query" name:"UpgradeMetadata"`
	DeployMetadata       string                      `position:"Query" name:"DeployMetadata"`
	ServiceType          string                      `position:"Query" name:"ServiceType"`
	IsSupportOperated    requests.Boolean            `position:"Query" name:"IsSupportOperated"`
	TenantType           string                      `position:"Query" name:"TenantType"`
	LogMetadata          string                      `position:"Query" name:"LogMetadata"`
	ServiceInfo          *[]CreateServiceServiceInfo `position:"Query" name:"ServiceInfo"  type:"Repeated"`
	ServiceId            string                      `position:"Query" name:"ServiceId"`
	VersionName          string                      `position:"Query" name:"VersionName"`
}

// CreateServiceTag is a repeated param struct in CreateServiceRequest
type CreateServiceTag struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// CreateServiceServiceInfo is a repeated param struct in CreateServiceRequest
type CreateServiceServiceInfo struct {
	ShortDescription   string                                `name:"ShortDescription"`
	Image              string                                `name:"Image"`
	Name               string                                `name:"Name"`
	Agreements         *[]CreateServiceServiceInfoAgreements `name:"Agreements" type:"Repeated"`
	Locale             string                                `name:"Locale"`
	LongDescriptionUrl string                                `name:"LongDescriptionUrl"`
}

// CreateServiceServiceInfoAgreements is a repeated param struct in CreateServiceRequest
type CreateServiceServiceInfoAgreements struct {
	Name string `name:"Name"`
	Url  string `name:"Url"`
}

// CreateServiceResponse is the response struct for api CreateService
type CreateServiceResponse struct {
	*responses.BaseResponse
	Status    string `json:"Status" xml:"Status"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Version   string `json:"Version" xml:"Version"`
	ServiceId string `json:"ServiceId" xml:"ServiceId"`
}

// CreateCreateServiceRequest creates a request to invoke CreateService API
func CreateCreateServiceRequest() (request *CreateServiceRequest) {
	request = &CreateServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ComputeNestSupplier", "2021-05-21", "CreateService", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateServiceResponse creates a response to parse from CreateService response
func CreateCreateServiceResponse() (response *CreateServiceResponse) {
	response = &CreateServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
