package computenest

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListServiceInstanceLogs invokes the computenest.ListServiceInstanceLogs API synchronously
func (client *Client) ListServiceInstanceLogs(request *ListServiceInstanceLogsRequest) (response *ListServiceInstanceLogsResponse, err error) {
	response = CreateListServiceInstanceLogsResponse()
	err = client.DoAction(request, response)
	return
}

// ListServiceInstanceLogsWithChan invokes the computenest.ListServiceInstanceLogs API asynchronously
func (client *Client) ListServiceInstanceLogsWithChan(request *ListServiceInstanceLogsRequest) (<-chan *ListServiceInstanceLogsResponse, <-chan error) {
	responseChan := make(chan *ListServiceInstanceLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListServiceInstanceLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListServiceInstanceLogsWithCallback invokes the computenest.ListServiceInstanceLogs API asynchronously
func (client *Client) ListServiceInstanceLogsWithCallback(request *ListServiceInstanceLogsRequest, callback func(response *ListServiceInstanceLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListServiceInstanceLogsResponse
		var err error
		defer close(result)
		response, err = client.ListServiceInstanceLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListServiceInstanceLogsRequest is the request struct for api ListServiceInstanceLogs
type ListServiceInstanceLogsRequest struct {
	*requests.RpcRequest
	NextToken         string           `position:"Query" name:"NextToken"`
	ServiceInstanceId string           `position:"Query" name:"ServiceInstanceId"`
	LogSource         string           `position:"Query" name:"LogSource"`
	MaxResults        requests.Integer `position:"Query" name:"MaxResults"`
	Logstore          string           `position:"Query" name:"Logstore"`
}

// ListServiceInstanceLogsResponse is the response struct for api ListServiceInstanceLogs
type ListServiceInstanceLogsResponse struct {
	*responses.BaseResponse
	NextToken            string                `json:"NextToken" xml:"NextToken"`
	RequestId            string                `json:"RequestId" xml:"RequestId"`
	MaxResults           int                   `json:"MaxResults" xml:"MaxResults"`
	ServiceInstancesLogs []ServiceInstanceLogs `json:"ServiceInstancesLogs" xml:"ServiceInstancesLogs"`
}

// CreateListServiceInstanceLogsRequest creates a request to invoke ListServiceInstanceLogs API
func CreateListServiceInstanceLogsRequest() (request *ListServiceInstanceLogsRequest) {
	request = &ListServiceInstanceLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ComputeNest", "2021-06-01", "ListServiceInstanceLogs", "computenest", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListServiceInstanceLogsResponse creates a response to parse from ListServiceInstanceLogs response
func CreateListServiceInstanceLogsResponse() (response *ListServiceInstanceLogsResponse) {
	response = &ListServiceInstanceLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
