package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteNatFirewallControlPolicy invokes the cloudfw.DeleteNatFirewallControlPolicy API synchronously
func (client *Client) DeleteNatFirewallControlPolicy(request *DeleteNatFirewallControlPolicyRequest) (response *DeleteNatFirewallControlPolicyResponse, err error) {
	response = CreateDeleteNatFirewallControlPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteNatFirewallControlPolicyWithChan invokes the cloudfw.DeleteNatFirewallControlPolicy API asynchronously
func (client *Client) DeleteNatFirewallControlPolicyWithChan(request *DeleteNatFirewallControlPolicyRequest) (<-chan *DeleteNatFirewallControlPolicyResponse, <-chan error) {
	responseChan := make(chan *DeleteNatFirewallControlPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteNatFirewallControlPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteNatFirewallControlPolicyWithCallback invokes the cloudfw.DeleteNatFirewallControlPolicy API asynchronously
func (client *Client) DeleteNatFirewallControlPolicyWithCallback(request *DeleteNatFirewallControlPolicyRequest, callback func(response *DeleteNatFirewallControlPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteNatFirewallControlPolicyResponse
		var err error
		defer close(result)
		response, err = client.DeleteNatFirewallControlPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteNatFirewallControlPolicyRequest is the request struct for api DeleteNatFirewallControlPolicy
type DeleteNatFirewallControlPolicyRequest struct {
	*requests.RpcRequest
	AclUuid      string `position:"Query" name:"AclUuid"`
	SourceIp     string `position:"Query" name:"SourceIp"`
	NatGatewayId string `position:"Query" name:"NatGatewayId"`
	Lang         string `position:"Query" name:"Lang"`
	Direction    string `position:"Query" name:"Direction"`
}

// DeleteNatFirewallControlPolicyResponse is the response struct for api DeleteNatFirewallControlPolicy
type DeleteNatFirewallControlPolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteNatFirewallControlPolicyRequest creates a request to invoke DeleteNatFirewallControlPolicy API
func CreateDeleteNatFirewallControlPolicyRequest() (request *DeleteNatFirewallControlPolicyRequest) {
	request = &DeleteNatFirewallControlPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "DeleteNatFirewallControlPolicy", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteNatFirewallControlPolicyResponse creates a response to parse from DeleteNatFirewallControlPolicy response
func CreateDeleteNatFirewallControlPolicyResponse() (response *DeleteNatFirewallControlPolicyResponse) {
	response = &DeleteNatFirewallControlPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
