package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryTemplateGroupList invokes the cloudesl.QueryTemplateGroupList API synchronously
func (client *Client) QueryTemplateGroupList(request *QueryTemplateGroupListRequest) (response *QueryTemplateGroupListResponse, err error) {
	response = CreateQueryTemplateGroupListResponse()
	err = client.DoAction(request, response)
	return
}

// QueryTemplateGroupListWithChan invokes the cloudesl.QueryTemplateGroupList API asynchronously
func (client *Client) QueryTemplateGroupListWithChan(request *QueryTemplateGroupListRequest) (<-chan *QueryTemplateGroupListResponse, <-chan error) {
	responseChan := make(chan *QueryTemplateGroupListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryTemplateGroupList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryTemplateGroupListWithCallback invokes the cloudesl.QueryTemplateGroupList API asynchronously
func (client *Client) QueryTemplateGroupListWithCallback(request *QueryTemplateGroupListRequest, callback func(response *QueryTemplateGroupListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryTemplateGroupListResponse
		var err error
		defer close(result)
		response, err = client.QueryTemplateGroupList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryTemplateGroupListRequest is the request struct for api QueryTemplateGroupList
type QueryTemplateGroupListRequest struct {
	*requests.RpcRequest
	PageNumber      requests.Integer `position:"Body" name:"PageNumber"`
	TemplateVersion string           `position:"Body" name:"TemplateVersion"`
	PageSize        requests.Integer `position:"Body" name:"PageSize"`
	EslModelId      string           `position:"Body" name:"EslModelId"`
	WidthPx         requests.Integer `position:"Body" name:"WidthPx"`
	GroupIds        string           `position:"Body" name:"GroupIds"`
	HeightPx        requests.Integer `position:"Body" name:"HeightPx"`
}

// QueryTemplateGroupListResponse is the response struct for api QueryTemplateGroupList
type QueryTemplateGroupListResponse struct {
	*responses.BaseResponse
	RequestId         string          `json:"RequestId" xml:"RequestId"`
	Success           bool            `json:"Success" xml:"Success"`
	Message           string          `json:"Message" xml:"Message"`
	ErrorCode         string          `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage      string          `json:"ErrorMessage" xml:"ErrorMessage"`
	Code              string          `json:"Code" xml:"Code"`
	DynamicCode       string          `json:"DynamicCode" xml:"DynamicCode"`
	DynamicMessage    string          `json:"DynamicMessage" xml:"DynamicMessage"`
	PageSize          int             `json:"PageSize" xml:"PageSize"`
	PageNumber        int             `json:"PageNumber" xml:"PageNumber"`
	TotalCount        int             `json:"TotalCount" xml:"TotalCount"`
	TemplateGroupList []TemplateGroup `json:"TemplateGroupList" xml:"TemplateGroupList"`
}

// CreateQueryTemplateGroupListRequest creates a request to invoke QueryTemplateGroupList API
func CreateQueryTemplateGroupListRequest() (request *QueryTemplateGroupListRequest) {
	request = &QueryTemplateGroupListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "QueryTemplateGroupList", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryTemplateGroupListResponse creates a response to parse from QueryTemplateGroupList response
func CreateQueryTemplateGroupListResponse() (response *QueryTemplateGroupListResponse) {
	response = &QueryTemplateGroupListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
