package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTask invokes the cloudcallcenter.ListTask API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listtask.html
func (client *Client) ListTask(request *ListTaskRequest) (response *ListTaskResponse, err error) {
	response = CreateListTaskResponse()
	err = client.DoAction(request, response)
	return
}

// ListTaskWithChan invokes the cloudcallcenter.ListTask API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listtask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListTaskWithChan(request *ListTaskRequest) (<-chan *ListTaskResponse, <-chan error) {
	responseChan := make(chan *ListTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTaskWithCallback invokes the cloudcallcenter.ListTask API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/listtask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListTaskWithCallback(request *ListTaskRequest, callback func(response *ListTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTaskResponse
		var err error
		defer close(result)
		response, err = client.ListTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTaskRequest is the request struct for api ListTask
type ListTaskRequest struct {
	*requests.RpcRequest
	InstanceId string           `position:"Query" name:"InstanceId"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// ListTaskResponse is the response struct for api ListTask
type ListTaskResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	Success        bool           `json:"Success" xml:"Success"`
	Code           string         `json:"Code" xml:"Code"`
	Message        string         `json:"Message" xml:"Message"`
	HttpStatusCode int            `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           DataInListTask `json:"Data" xml:"Data"`
}

// CreateListTaskRequest creates a request to invoke ListTask API
func CreateListTaskRequest() (request *ListTaskRequest) {
	request = &ListTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ListTask", "", "")
	request.Method = requests.POST
	return
}

// CreateListTaskResponse creates a response to parse from ListTask response
func CreateListTaskResponse() (response *ListTaskResponse) {
	response = &ListTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
