package cloudauth

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BankMetaVerify invokes the cloudauth.BankMetaVerify API synchronously
func (client *Client) BankMetaVerify(request *BankMetaVerifyRequest) (response *BankMetaVerifyResponse, err error) {
	response = CreateBankMetaVerifyResponse()
	err = client.DoAction(request, response)
	return
}

// BankMetaVerifyWithChan invokes the cloudauth.BankMetaVerify API asynchronously
func (client *Client) BankMetaVerifyWithChan(request *BankMetaVerifyRequest) (<-chan *BankMetaVerifyResponse, <-chan error) {
	responseChan := make(chan *BankMetaVerifyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BankMetaVerify(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BankMetaVerifyWithCallback invokes the cloudauth.BankMetaVerify API asynchronously
func (client *Client) BankMetaVerifyWithCallback(request *BankMetaVerifyRequest, callback func(response *BankMetaVerifyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BankMetaVerifyResponse
		var err error
		defer close(result)
		response, err = client.BankMetaVerify(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BankMetaVerifyRequest is the request struct for api BankMetaVerify
type BankMetaVerifyRequest struct {
	*requests.RpcRequest
	ParamType    string `position:"Query" name:"ParamType"`
	VerifyMode   string `position:"Query" name:"VerifyMode"`
	IdentityType string `position:"Query" name:"IdentityType"`
	Mobile       string `position:"Query" name:"Mobile"`
	IdentifyNum  string `position:"Query" name:"IdentifyNum"`
	ProductType  string `position:"Query" name:"ProductType"`
	BankCard     string `position:"Query" name:"BankCard"`
	UserName     string `position:"Query" name:"UserName"`
}

// BankMetaVerifyResponse is the response struct for api BankMetaVerify
type BankMetaVerifyResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	Code         string       `json:"Code" xml:"Code"`
	Message      string       `json:"Message" xml:"Message"`
	ResultObject ResultObject `json:"ResultObject" xml:"ResultObject"`
}

// CreateBankMetaVerifyRequest creates a request to invoke BankMetaVerify API
func CreateBankMetaVerifyRequest() (request *BankMetaVerifyRequest) {
	request = &BankMetaVerifyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudauth", "2019-03-07", "BankMetaVerify", "cloudauth", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBankMetaVerifyResponse creates a response to parse from BankMetaVerify response
func CreateBankMetaVerifyResponse() (response *BankMetaVerifyResponse) {
	response = &BankMetaVerifyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
