package cloudapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AttachApiProduct invokes the cloudapi.AttachApiProduct API synchronously
func (client *Client) AttachApiProduct(request *AttachApiProductRequest) (response *AttachApiProductResponse, err error) {
	response = CreateAttachApiProductResponse()
	err = client.DoAction(request, response)
	return
}

// AttachApiProductWithChan invokes the cloudapi.AttachApiProduct API asynchronously
func (client *Client) AttachApiProductWithChan(request *AttachApiProductRequest) (<-chan *AttachApiProductResponse, <-chan error) {
	responseChan := make(chan *AttachApiProductResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AttachApiProduct(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AttachApiProductWithCallback invokes the cloudapi.AttachApiProduct API asynchronously
func (client *Client) AttachApiProductWithCallback(request *AttachApiProductRequest, callback func(response *AttachApiProductResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AttachApiProductResponse
		var err error
		defer close(result)
		response, err = client.AttachApiProduct(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AttachApiProductRequest is the request struct for api AttachApiProduct
type AttachApiProductRequest struct {
	*requests.RpcRequest
	Apis          *[]AttachApiProductApis `position:"Query" name:"Apis"  type:"Repeated"`
	SecurityToken string                  `position:"Query" name:"SecurityToken"`
	ApiProductId  string                  `position:"Query" name:"ApiProductId"`
}

// AttachApiProductApis is a repeated param struct in AttachApiProductRequest
type AttachApiProductApis struct {
	StageName string `name:"StageName"`
	ApiId     string `name:"ApiId"`
}

// AttachApiProductResponse is the response struct for api AttachApiProduct
type AttachApiProductResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAttachApiProductRequest creates a request to invoke AttachApiProduct API
func CreateAttachApiProductRequest() (request *AttachApiProductRequest) {
	request = &AttachApiProductRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudAPI", "2016-07-14", "AttachApiProduct", "apigateway", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAttachApiProductResponse creates a response to parse from AttachApiProduct response
func CreateAttachApiProductResponse() (response *AttachApiProductResponse) {
	response = &AttachApiProductResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
