package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PostEventWhiteruleList invokes the cloud_siem.PostEventWhiteruleList API synchronously
func (client *Client) PostEventWhiteruleList(request *PostEventWhiteruleListRequest) (response *PostEventWhiteruleListResponse, err error) {
	response = CreatePostEventWhiteruleListResponse()
	err = client.DoAction(request, response)
	return
}

// PostEventWhiteruleListWithChan invokes the cloud_siem.PostEventWhiteruleList API asynchronously
func (client *Client) PostEventWhiteruleListWithChan(request *PostEventWhiteruleListRequest) (<-chan *PostEventWhiteruleListResponse, <-chan error) {
	responseChan := make(chan *PostEventWhiteruleListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PostEventWhiteruleList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PostEventWhiteruleListWithCallback invokes the cloud_siem.PostEventWhiteruleList API asynchronously
func (client *Client) PostEventWhiteruleListWithCallback(request *PostEventWhiteruleListRequest, callback func(response *PostEventWhiteruleListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PostEventWhiteruleListResponse
		var err error
		defer close(result)
		response, err = client.PostEventWhiteruleList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PostEventWhiteruleListRequest is the request struct for api PostEventWhiteruleList
type PostEventWhiteruleListRequest struct {
	*requests.RpcRequest
	WhiteruleList string `position:"Body" name:"WhiteruleList"`
	IncidentUuid  string `position:"Body" name:"IncidentUuid"`
}

// PostEventWhiteruleListResponse is the response struct for api PostEventWhiteruleList
type PostEventWhiteruleListResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreatePostEventWhiteruleListRequest creates a request to invoke PostEventWhiteruleList API
func CreatePostEventWhiteruleListRequest() (request *PostEventWhiteruleListRequest) {
	request = &PostEventWhiteruleListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "PostEventWhiteruleList", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePostEventWhiteruleListResponse creates a response to parse from PostEventWhiteruleList response
func CreatePostEventWhiteruleListResponse() (response *PostEventWhiteruleListResponse) {
	response = &PostEventWhiteruleListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
