package cloud_siem

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAutomateResponseConfig invokes the cloud_siem.DeleteAutomateResponseConfig API synchronously
func (client *Client) DeleteAutomateResponseConfig(request *DeleteAutomateResponseConfigRequest) (response *DeleteAutomateResponseConfigResponse, err error) {
	response = CreateDeleteAutomateResponseConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAutomateResponseConfigWithChan invokes the cloud_siem.DeleteAutomateResponseConfig API asynchronously
func (client *Client) DeleteAutomateResponseConfigWithChan(request *DeleteAutomateResponseConfigRequest) (<-chan *DeleteAutomateResponseConfigResponse, <-chan error) {
	responseChan := make(chan *DeleteAutomateResponseConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAutomateResponseConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAutomateResponseConfigWithCallback invokes the cloud_siem.DeleteAutomateResponseConfig API asynchronously
func (client *Client) DeleteAutomateResponseConfigWithCallback(request *DeleteAutomateResponseConfigRequest, callback func(response *DeleteAutomateResponseConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAutomateResponseConfigResponse
		var err error
		defer close(result)
		response, err = client.DeleteAutomateResponseConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAutomateResponseConfigRequest is the request struct for api DeleteAutomateResponseConfig
type DeleteAutomateResponseConfigRequest struct {
	*requests.RpcRequest
	Id requests.Integer `position:"Body" name:"Id"`
}

// DeleteAutomateResponseConfigResponse is the response struct for api DeleteAutomateResponseConfig
type DeleteAutomateResponseConfigResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateDeleteAutomateResponseConfigRequest creates a request to invoke DeleteAutomateResponseConfig API
func CreateDeleteAutomateResponseConfigRequest() (request *DeleteAutomateResponseConfigRequest) {
	request = &DeleteAutomateResponseConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloud-siem", "2022-06-16", "DeleteAutomateResponseConfig", "cloud-siem", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteAutomateResponseConfigResponse creates a response to parse from DeleteAutomateResponseConfig response
func CreateDeleteAutomateResponseConfigResponse() (response *DeleteAutomateResponseConfigResponse) {
	response = &DeleteAutomateResponseConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
