package ccc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ResetUserPassword invokes the ccc.ResetUserPassword API synchronously
func (client *Client) ResetUserPassword(request *ResetUserPasswordRequest) (response *ResetUserPasswordResponse, err error) {
	response = CreateResetUserPasswordResponse()
	err = client.DoAction(request, response)
	return
}

// ResetUserPasswordWithChan invokes the ccc.ResetUserPassword API asynchronously
func (client *Client) ResetUserPasswordWithChan(request *ResetUserPasswordRequest) (<-chan *ResetUserPasswordResponse, <-chan error) {
	responseChan := make(chan *ResetUserPasswordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ResetUserPassword(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ResetUserPasswordWithCallback invokes the ccc.ResetUserPassword API asynchronously
func (client *Client) ResetUserPasswordWithCallback(request *ResetUserPasswordRequest, callback func(response *ResetUserPasswordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ResetUserPasswordResponse
		var err error
		defer close(result)
		response, err = client.ResetUserPassword(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ResetUserPasswordRequest is the request struct for api ResetUserPassword
type ResetUserPasswordRequest struct {
	*requests.RpcRequest
	UserId     string `position:"Query" name:"UserId"`
	Password   string `position:"Query" name:"Password"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// ResetUserPasswordResponse is the response struct for api ResetUserPassword
type ResetUserPasswordResponse struct {
	*responses.BaseResponse
	Code           string `json:"Code" xml:"Code"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateResetUserPasswordRequest creates a request to invoke ResetUserPassword API
func CreateResetUserPasswordRequest() (request *ResetUserPasswordRequest) {
	request = &ResetUserPasswordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CCC", "2020-07-01", "ResetUserPassword", "CCC", "openAPI")
	request.Method = requests.POST
	return
}

// CreateResetUserPasswordResponse creates a response to parse from ResetUserPassword response
func CreateResetUserPasswordResponse() (response *ResetUserPasswordResponse) {
	response = &ResetUserPasswordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
