package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTransitRouterEcrAttachment invokes the cbn.DeleteTransitRouterEcrAttachment API synchronously
func (client *Client) DeleteTransitRouterEcrAttachment(request *DeleteTransitRouterEcrAttachmentRequest) (response *DeleteTransitRouterEcrAttachmentResponse, err error) {
	response = CreateDeleteTransitRouterEcrAttachmentResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTransitRouterEcrAttachmentWithChan invokes the cbn.DeleteTransitRouterEcrAttachment API asynchronously
func (client *Client) DeleteTransitRouterEcrAttachmentWithChan(request *DeleteTransitRouterEcrAttachmentRequest) (<-chan *DeleteTransitRouterEcrAttachmentResponse, <-chan error) {
	responseChan := make(chan *DeleteTransitRouterEcrAttachmentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTransitRouterEcrAttachment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTransitRouterEcrAttachmentWithCallback invokes the cbn.DeleteTransitRouterEcrAttachment API asynchronously
func (client *Client) DeleteTransitRouterEcrAttachmentWithCallback(request *DeleteTransitRouterEcrAttachmentRequest, callback func(response *DeleteTransitRouterEcrAttachmentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTransitRouterEcrAttachmentResponse
		var err error
		defer close(result)
		response, err = client.DeleteTransitRouterEcrAttachment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTransitRouterEcrAttachmentRequest is the request struct for api DeleteTransitRouterEcrAttachment
type DeleteTransitRouterEcrAttachmentRequest struct {
	*requests.RpcRequest
	ResourceOwnerId           requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken               string           `position:"Query" name:"ClientToken"`
	DryRun                    requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount      string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount              string           `position:"Query" name:"OwnerAccount"`
	OwnerId                   requests.Integer `position:"Query" name:"OwnerId"`
	ResourceType              string           `position:"Query" name:"ResourceType"`
	Version                   string           `position:"Query" name:"Version"`
	TransitRouterAttachmentId string           `position:"Query" name:"TransitRouterAttachmentId"`
	Force                     requests.Boolean `position:"Query" name:"Force"`
}

// DeleteTransitRouterEcrAttachmentResponse is the response struct for api DeleteTransitRouterEcrAttachment
type DeleteTransitRouterEcrAttachmentResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteTransitRouterEcrAttachmentRequest creates a request to invoke DeleteTransitRouterEcrAttachment API
func CreateDeleteTransitRouterEcrAttachmentRequest() (request *DeleteTransitRouterEcrAttachmentRequest) {
	request = &DeleteTransitRouterEcrAttachmentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "DeleteTransitRouterEcrAttachment", "cbn", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteTransitRouterEcrAttachmentResponse creates a response to parse from DeleteTransitRouterEcrAttachment response
func CreateDeleteTransitRouterEcrAttachmentResponse() (response *DeleteTransitRouterEcrAttachmentResponse) {
	response = &DeleteTransitRouterEcrAttachmentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
