// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opBindYBForAXYBCommon = "BindYBForAXYB"

// BindYBForAXYBCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the BindYBForAXYBCommon operation. The "output" return
// value will be populated with the BindYBForAXYBCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned BindYBForAXYBCommon Request to send the API call to the service.
// the "output" return value is not valid until after BindYBForAXYBCommon Send returns without error.
//
// See BindYBForAXYBCommon for more information on using the BindYBForAXYBCommon
// API call, and error handling.
//
//    // Example sending a request using the BindYBForAXYBCommonRequest method.
//    req, resp := client.BindYBForAXYBCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMS) BindYBForAXYBCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opBindYBForAXYBCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// BindYBForAXYBCommon API operation for VMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMS's
// API operation BindYBForAXYBCommon for usage and error information.
func (c *VMS) BindYBForAXYBCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.BindYBForAXYBCommonRequest(input)
	return out, req.Send()
}

// BindYBForAXYBCommonWithContext is the same as BindYBForAXYBCommon with the addition of
// the ability to pass a context and additional request options.
//
// See BindYBForAXYBCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMS) BindYBForAXYBCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.BindYBForAXYBCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBindYBForAXYB = "BindYBForAXYB"

// BindYBForAXYBRequest generates a "volcengine/request.Request" representing the
// client's request for the BindYBForAXYB operation. The "output" return
// value will be populated with the BindYBForAXYBCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned BindYBForAXYBCommon Request to send the API call to the service.
// the "output" return value is not valid until after BindYBForAXYBCommon Send returns without error.
//
// See BindYBForAXYB for more information on using the BindYBForAXYB
// API call, and error handling.
//
//    // Example sending a request using the BindYBForAXYBRequest method.
//    req, resp := client.BindYBForAXYBRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMS) BindYBForAXYBRequest(input *BindYBForAXYBInput) (req *request.Request, output *BindYBForAXYBOutput) {
	op := &request.Operation{
		Name:       opBindYBForAXYB,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BindYBForAXYBInput{}
	}

	output = &BindYBForAXYBOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// BindYBForAXYB API operation for VMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMS's
// API operation BindYBForAXYB for usage and error information.
func (c *VMS) BindYBForAXYB(input *BindYBForAXYBInput) (*BindYBForAXYBOutput, error) {
	req, out := c.BindYBForAXYBRequest(input)
	return out, req.Send()
}

// BindYBForAXYBWithContext is the same as BindYBForAXYB with the addition of
// the ability to pass a context and additional request options.
//
// See BindYBForAXYB for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMS) BindYBForAXYBWithContext(ctx volcengine.Context, input *BindYBForAXYBInput, opts ...request.Option) (*BindYBForAXYBOutput, error) {
	req, out := c.BindYBForAXYBRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type BindYBForAXYBInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AudioRecordFlag *int32 `type:"int32" json:",omitempty"`

	CityCode *string `type:"string" json:",omitempty"`

	CityCodeByPhoneNo *string `type:"string" json:",omitempty" enum:"EnumOfCityCodeByPhoneNoForBindYBForAXYBInput"`

	DegradeCityList []*string `type:"list" json:",omitempty"`

	// EnableDuration is a required field
	EnableDuration *int32 `type:"int32" json:",omitempty" required:"true"`

	// NumberPoolNo is a required field
	NumberPoolNo *string `type:"string" json:",omitempty" required:"true"`

	// ParentSubId is a required field
	ParentSubId *string `type:"string" json:",omitempty" required:"true"`

	// PhoneNoB is a required field
	PhoneNoB *string `type:"string" json:",omitempty" required:"true"`

	PhoneNoY *string `type:"string" json:",omitempty"`

	RandomFlag *int32 `type:"int32" json:",omitempty"`

	UserData *string `max:"2048" type:"string" json:",omitempty"`
}

// String returns the string representation
func (s BindYBForAXYBInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BindYBForAXYBInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BindYBForAXYBInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BindYBForAXYBInput"}
	if s.EnableDuration == nil {
		invalidParams.Add(request.NewErrParamRequired("EnableDuration"))
	}
	if s.NumberPoolNo == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberPoolNo"))
	}
	if s.ParentSubId == nil {
		invalidParams.Add(request.NewErrParamRequired("ParentSubId"))
	}
	if s.PhoneNoB == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNoB"))
	}
	if s.UserData != nil && len(*s.UserData) > 2048 {
		invalidParams.Add(request.NewErrParamMaxLen("UserData", 2048, *s.UserData))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioRecordFlag sets the AudioRecordFlag field's value.
func (s *BindYBForAXYBInput) SetAudioRecordFlag(v int32) *BindYBForAXYBInput {
	s.AudioRecordFlag = &v
	return s
}

// SetCityCode sets the CityCode field's value.
func (s *BindYBForAXYBInput) SetCityCode(v string) *BindYBForAXYBInput {
	s.CityCode = &v
	return s
}

// SetCityCodeByPhoneNo sets the CityCodeByPhoneNo field's value.
func (s *BindYBForAXYBInput) SetCityCodeByPhoneNo(v string) *BindYBForAXYBInput {
	s.CityCodeByPhoneNo = &v
	return s
}

// SetDegradeCityList sets the DegradeCityList field's value.
func (s *BindYBForAXYBInput) SetDegradeCityList(v []*string) *BindYBForAXYBInput {
	s.DegradeCityList = v
	return s
}

// SetEnableDuration sets the EnableDuration field's value.
func (s *BindYBForAXYBInput) SetEnableDuration(v int32) *BindYBForAXYBInput {
	s.EnableDuration = &v
	return s
}

// SetNumberPoolNo sets the NumberPoolNo field's value.
func (s *BindYBForAXYBInput) SetNumberPoolNo(v string) *BindYBForAXYBInput {
	s.NumberPoolNo = &v
	return s
}

// SetParentSubId sets the ParentSubId field's value.
func (s *BindYBForAXYBInput) SetParentSubId(v string) *BindYBForAXYBInput {
	s.ParentSubId = &v
	return s
}

// SetPhoneNoB sets the PhoneNoB field's value.
func (s *BindYBForAXYBInput) SetPhoneNoB(v string) *BindYBForAXYBInput {
	s.PhoneNoB = &v
	return s
}

// SetPhoneNoY sets the PhoneNoY field's value.
func (s *BindYBForAXYBInput) SetPhoneNoY(v string) *BindYBForAXYBInput {
	s.PhoneNoY = &v
	return s
}

// SetRandomFlag sets the RandomFlag field's value.
func (s *BindYBForAXYBInput) SetRandomFlag(v int32) *BindYBForAXYBInput {
	s.RandomFlag = &v
	return s
}

// SetUserData sets the UserData field's value.
func (s *BindYBForAXYBInput) SetUserData(v string) *BindYBForAXYBInput {
	s.UserData = &v
	return s
}

type BindYBForAXYBOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	PhoneNoY *string `type:"string" json:",omitempty"`

	Status *int32 `type:"int32" json:",omitempty"`

	SubId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s BindYBForAXYBOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BindYBForAXYBOutput) GoString() string {
	return s.String()
}

// SetPhoneNoY sets the PhoneNoY field's value.
func (s *BindYBForAXYBOutput) SetPhoneNoY(v string) *BindYBForAXYBOutput {
	s.PhoneNoY = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *BindYBForAXYBOutput) SetStatus(v int32) *BindYBForAXYBOutput {
	s.Status = &v
	return s
}

// SetSubId sets the SubId field's value.
func (s *BindYBForAXYBOutput) SetSubId(v string) *BindYBForAXYBOutput {
	s.SubId = &v
	return s
}

const (
	// EnumOfCityCodeByPhoneNoForBindYBForAXYBInputA is a EnumOfCityCodeByPhoneNoForBindYBForAXYBInput enum value
	EnumOfCityCodeByPhoneNoForBindYBForAXYBInputA = "A"

	// EnumOfCityCodeByPhoneNoForBindYBForAXYBInputB is a EnumOfCityCodeByPhoneNoForBindYBForAXYBInput enum value
	EnumOfCityCodeByPhoneNoForBindYBForAXYBInputB = "B"
)
