// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package sqs

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDeleteMessageCommon = "DeleteMessage"

// DeleteMessageCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DeleteMessageCommon operation. The "output" return
// value will be populated with the DeleteMessageCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DeleteMessageCommon Request to send the API call to the service.
// the "output" return value is not valid until after DeleteMessageCommon Send returns without error.
//
// See DeleteMessageCommon for more information on using the DeleteMessageCommon
// API call, and error handling.
//
//    // Example sending a request using the DeleteMessageCommonRequest method.
//    req, resp := client.DeleteMessageCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SQS) DeleteMessageCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDeleteMessageCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DeleteMessageCommon API operation for SQS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for SQS's
// API operation DeleteMessageCommon for usage and error information.
func (c *SQS) DeleteMessageCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DeleteMessageCommonRequest(input)
	return out, req.Send()
}

// DeleteMessageCommonWithContext is the same as DeleteMessageCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMessageCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SQS) DeleteMessageCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DeleteMessageCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMessage = "DeleteMessage"

// DeleteMessageRequest generates a "volcengine/request.Request" representing the
// client's request for the DeleteMessage operation. The "output" return
// value will be populated with the DeleteMessageCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DeleteMessageCommon Request to send the API call to the service.
// the "output" return value is not valid until after DeleteMessageCommon Send returns without error.
//
// See DeleteMessage for more information on using the DeleteMessage
// API call, and error handling.
//
//    // Example sending a request using the DeleteMessageRequest method.
//    req, resp := client.DeleteMessageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SQS) DeleteMessageRequest(input *DeleteMessageInput) (req *request.Request, output *DeleteMessageOutput) {
	op := &request.Operation{
		Name:       opDeleteMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteMessageInput{}
	}

	output = &DeleteMessageOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DeleteMessage API operation for SQS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for SQS's
// API operation DeleteMessage for usage and error information.
func (c *SQS) DeleteMessage(input *DeleteMessageInput) (*DeleteMessageOutput, error) {
	req, out := c.DeleteMessageRequest(input)
	return out, req.Send()
}

// DeleteMessageWithContext is the same as DeleteMessage with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SQS) DeleteMessageWithContext(ctx volcengine.Context, input *DeleteMessageInput, opts ...request.Option) (*DeleteMessageOutput, error) {
	req, out := c.DeleteMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DeleteMessageInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// QueueTrn is a required field
	QueueTrn *string `type:"string" json:",omitempty" required:"true"`

	// ReceiptHandle is a required field
	ReceiptHandle *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s DeleteMessageInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMessageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMessageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMessageInput"}
	if s.QueueTrn == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueTrn"))
	}
	if s.ReceiptHandle == nil {
		invalidParams.Add(request.NewErrParamRequired("ReceiptHandle"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueueTrn sets the QueueTrn field's value.
func (s *DeleteMessageInput) SetQueueTrn(v string) *DeleteMessageInput {
	s.QueueTrn = &v
	return s
}

// SetReceiptHandle sets the ReceiptHandle field's value.
func (s *DeleteMessageInput) SetReceiptHandle(v string) *DeleteMessageInput {
	s.ReceiptHandle = &v
	return s
}

type DeleteMessageOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s DeleteMessageOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteMessageOutput) GoString() string {
	return s.String()
}
