// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package mongodb

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opModifyMultiDBInstanceParametersCommon = "ModifyMultiDBInstanceParameters"

// ModifyMultiDBInstanceParametersCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ModifyMultiDBInstanceParametersCommon operation. The "output" return
// value will be populated with the ModifyMultiDBInstanceParametersCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ModifyMultiDBInstanceParametersCommon Request to send the API call to the service.
// the "output" return value is not valid until after ModifyMultiDBInstanceParametersCommon Send returns without error.
//
// See ModifyMultiDBInstanceParametersCommon for more information on using the ModifyMultiDBInstanceParametersCommon
// API call, and error handling.
//
//    // Example sending a request using the ModifyMultiDBInstanceParametersCommonRequest method.
//    req, resp := client.ModifyMultiDBInstanceParametersCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MONGODB) ModifyMultiDBInstanceParametersCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opModifyMultiDBInstanceParametersCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ModifyMultiDBInstanceParametersCommon API operation for MONGODB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for MONGODB's
// API operation ModifyMultiDBInstanceParametersCommon for usage and error information.
func (c *MONGODB) ModifyMultiDBInstanceParametersCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ModifyMultiDBInstanceParametersCommonRequest(input)
	return out, req.Send()
}

// ModifyMultiDBInstanceParametersCommonWithContext is the same as ModifyMultiDBInstanceParametersCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyMultiDBInstanceParametersCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MONGODB) ModifyMultiDBInstanceParametersCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ModifyMultiDBInstanceParametersCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyMultiDBInstanceParameters = "ModifyMultiDBInstanceParameters"

// ModifyMultiDBInstanceParametersRequest generates a "volcengine/request.Request" representing the
// client's request for the ModifyMultiDBInstanceParameters operation. The "output" return
// value will be populated with the ModifyMultiDBInstanceParametersCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ModifyMultiDBInstanceParametersCommon Request to send the API call to the service.
// the "output" return value is not valid until after ModifyMultiDBInstanceParametersCommon Send returns without error.
//
// See ModifyMultiDBInstanceParameters for more information on using the ModifyMultiDBInstanceParameters
// API call, and error handling.
//
//    // Example sending a request using the ModifyMultiDBInstanceParametersRequest method.
//    req, resp := client.ModifyMultiDBInstanceParametersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MONGODB) ModifyMultiDBInstanceParametersRequest(input *ModifyMultiDBInstanceParametersInput) (req *request.Request, output *ModifyMultiDBInstanceParametersOutput) {
	op := &request.Operation{
		Name:       opModifyMultiDBInstanceParameters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyMultiDBInstanceParametersInput{}
	}

	output = &ModifyMultiDBInstanceParametersOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ModifyMultiDBInstanceParameters API operation for MONGODB.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for MONGODB's
// API operation ModifyMultiDBInstanceParameters for usage and error information.
func (c *MONGODB) ModifyMultiDBInstanceParameters(input *ModifyMultiDBInstanceParametersInput) (*ModifyMultiDBInstanceParametersOutput, error) {
	req, out := c.ModifyMultiDBInstanceParametersRequest(input)
	return out, req.Send()
}

// ModifyMultiDBInstanceParametersWithContext is the same as ModifyMultiDBInstanceParameters with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyMultiDBInstanceParameters for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MONGODB) ModifyMultiDBInstanceParametersWithContext(ctx volcengine.Context, input *ModifyMultiDBInstanceParametersInput, opts ...request.Option) (*ModifyMultiDBInstanceParametersOutput, error) {
	req, out := c.ModifyMultiDBInstanceParametersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ModifyMultiDBInstanceParametersInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// InstanceId is a required field
	InstanceId *string `type:"string" json:",omitempty" required:"true"`

	ParameterObjects []*ParameterObjectForModifyMultiDBInstanceParametersInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ModifyMultiDBInstanceParametersInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyMultiDBInstanceParametersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyMultiDBInstanceParametersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyMultiDBInstanceParametersInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *ModifyMultiDBInstanceParametersInput) SetInstanceId(v string) *ModifyMultiDBInstanceParametersInput {
	s.InstanceId = &v
	return s
}

// SetParameterObjects sets the ParameterObjects field's value.
func (s *ModifyMultiDBInstanceParametersInput) SetParameterObjects(v []*ParameterObjectForModifyMultiDBInstanceParametersInput) *ModifyMultiDBInstanceParametersInput {
	s.ParameterObjects = v
	return s
}

type ModifyMultiDBInstanceParametersOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s ModifyMultiDBInstanceParametersOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyMultiDBInstanceParametersOutput) GoString() string {
	return s.String()
}

type ParameterObjectForModifyMultiDBInstanceParametersInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ParameterName *string `type:"string" json:",omitempty"`

	ParameterRole *string `type:"string" json:",omitempty" enum:"EnumOfParameterRoleForModifyMultiDBInstanceParametersInput"`

	ParameterValue *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ParameterObjectForModifyMultiDBInstanceParametersInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterObjectForModifyMultiDBInstanceParametersInput) GoString() string {
	return s.String()
}

// SetParameterName sets the ParameterName field's value.
func (s *ParameterObjectForModifyMultiDBInstanceParametersInput) SetParameterName(v string) *ParameterObjectForModifyMultiDBInstanceParametersInput {
	s.ParameterName = &v
	return s
}

// SetParameterRole sets the ParameterRole field's value.
func (s *ParameterObjectForModifyMultiDBInstanceParametersInput) SetParameterRole(v string) *ParameterObjectForModifyMultiDBInstanceParametersInput {
	s.ParameterRole = &v
	return s
}

// SetParameterValue sets the ParameterValue field's value.
func (s *ParameterObjectForModifyMultiDBInstanceParametersInput) SetParameterValue(v string) *ParameterObjectForModifyMultiDBInstanceParametersInput {
	s.ParameterValue = &v
	return s
}

const (
	// EnumOfParameterRoleForModifyMultiDBInstanceParametersInputUnknown is a EnumOfParameterRoleForModifyMultiDBInstanceParametersInput enum value
	EnumOfParameterRoleForModifyMultiDBInstanceParametersInputUnknown = "Unknown"

	// EnumOfParameterRoleForModifyMultiDBInstanceParametersInputNode is a EnumOfParameterRoleForModifyMultiDBInstanceParametersInput enum value
	EnumOfParameterRoleForModifyMultiDBInstanceParametersInputNode = "Node"

	// EnumOfParameterRoleForModifyMultiDBInstanceParametersInputShard is a EnumOfParameterRoleForModifyMultiDBInstanceParametersInput enum value
	EnumOfParameterRoleForModifyMultiDBInstanceParametersInputShard = "Shard"

	// EnumOfParameterRoleForModifyMultiDBInstanceParametersInputConfigServer is a EnumOfParameterRoleForModifyMultiDBInstanceParametersInput enum value
	EnumOfParameterRoleForModifyMultiDBInstanceParametersInputConfigServer = "ConfigServer"

	// EnumOfParameterRoleForModifyMultiDBInstanceParametersInputMongos is a EnumOfParameterRoleForModifyMultiDBInstanceParametersInput enum value
	EnumOfParameterRoleForModifyMultiDBInstanceParametersInputMongos = "Mongos"
)
