// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package mlplatform20240701

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateResourceReservationPlanCommon = "CreateResourceReservationPlan"

// CreateResourceReservationPlanCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateResourceReservationPlanCommon operation. The "output" return
// value will be populated with the CreateResourceReservationPlanCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateResourceReservationPlanCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateResourceReservationPlanCommon Send returns without error.
//
// See CreateResourceReservationPlanCommon for more information on using the CreateResourceReservationPlanCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateResourceReservationPlanCommonRequest method.
//    req, resp := client.CreateResourceReservationPlanCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) CreateResourceReservationPlanCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateResourceReservationPlanCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateResourceReservationPlanCommon API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation CreateResourceReservationPlanCommon for usage and error information.
func (c *MLPLATFORM20240701) CreateResourceReservationPlanCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateResourceReservationPlanCommonRequest(input)
	return out, req.Send()
}

// CreateResourceReservationPlanCommonWithContext is the same as CreateResourceReservationPlanCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResourceReservationPlanCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) CreateResourceReservationPlanCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateResourceReservationPlanCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResourceReservationPlan = "CreateResourceReservationPlan"

// CreateResourceReservationPlanRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateResourceReservationPlan operation. The "output" return
// value will be populated with the CreateResourceReservationPlanCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateResourceReservationPlanCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateResourceReservationPlanCommon Send returns without error.
//
// See CreateResourceReservationPlan for more information on using the CreateResourceReservationPlan
// API call, and error handling.
//
//    // Example sending a request using the CreateResourceReservationPlanRequest method.
//    req, resp := client.CreateResourceReservationPlanRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) CreateResourceReservationPlanRequest(input *CreateResourceReservationPlanInput) (req *request.Request, output *CreateResourceReservationPlanOutput) {
	op := &request.Operation{
		Name:       opCreateResourceReservationPlan,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateResourceReservationPlanInput{}
	}

	output = &CreateResourceReservationPlanOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateResourceReservationPlan API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation CreateResourceReservationPlan for usage and error information.
func (c *MLPLATFORM20240701) CreateResourceReservationPlan(input *CreateResourceReservationPlanInput) (*CreateResourceReservationPlanOutput, error) {
	req, out := c.CreateResourceReservationPlanRequest(input)
	return out, req.Send()
}

// CreateResourceReservationPlanWithContext is the same as CreateResourceReservationPlan with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResourceReservationPlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) CreateResourceReservationPlanWithContext(ctx volcengine.Context, input *CreateResourceReservationPlanInput, opts ...request.Option) (*CreateResourceReservationPlanOutput, error) {
	req, out := c.CreateResourceReservationPlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ComputeResourceForCreateResourceReservationPlanInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Count *int64 `type:"int64" json:",omitempty"`

	InstanceTypeId *string `type:"string" json:",omitempty"`

	ZoneIds []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ComputeResourceForCreateResourceReservationPlanInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ComputeResourceForCreateResourceReservationPlanInput) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *ComputeResourceForCreateResourceReservationPlanInput) SetCount(v int64) *ComputeResourceForCreateResourceReservationPlanInput {
	s.Count = &v
	return s
}

// SetInstanceTypeId sets the InstanceTypeId field's value.
func (s *ComputeResourceForCreateResourceReservationPlanInput) SetInstanceTypeId(v string) *ComputeResourceForCreateResourceReservationPlanInput {
	s.InstanceTypeId = &v
	return s
}

// SetZoneIds sets the ZoneIds field's value.
func (s *ComputeResourceForCreateResourceReservationPlanInput) SetZoneIds(v []*string) *ComputeResourceForCreateResourceReservationPlanInput {
	s.ZoneIds = v
	return s
}

type CreateResourceReservationPlanInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ComputeResource *ComputeResourceForCreateResourceReservationPlanInput `type:"structure" json:",omitempty"`

	Description *string `min:"1" max:"500" type:"string" json:",omitempty"`

	DryRun *bool `type:"boolean" json:",omitempty"`

	// Name is a required field
	Name *string `min:"1" max:"200" type:"string" json:",omitempty" required:"true"`

	ReservationConfig *ReservationConfigForCreateResourceReservationPlanInput `type:"structure" json:",omitempty"`

	StorageConfig *StorageConfigForCreateResourceReservationPlanInput `type:"structure" json:",omitempty"`

	WorkloadNetworkConfig *WorkloadNetworkConfigForCreateResourceReservationPlanInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CreateResourceReservationPlanInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResourceReservationPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResourceReservationPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResourceReservationPlanInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Description != nil && len(*s.Description) > 500 {
		invalidParams.Add(request.NewErrParamMaxLen("Description", 500, *s.Description))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Name != nil && len(*s.Name) > 200 {
		invalidParams.Add(request.NewErrParamMaxLen("Name", 200, *s.Name))
	}
	if s.ReservationConfig != nil {
		if err := s.ReservationConfig.Validate(); err != nil {
			invalidParams.AddNested("ReservationConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComputeResource sets the ComputeResource field's value.
func (s *CreateResourceReservationPlanInput) SetComputeResource(v *ComputeResourceForCreateResourceReservationPlanInput) *CreateResourceReservationPlanInput {
	s.ComputeResource = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateResourceReservationPlanInput) SetDescription(v string) *CreateResourceReservationPlanInput {
	s.Description = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CreateResourceReservationPlanInput) SetDryRun(v bool) *CreateResourceReservationPlanInput {
	s.DryRun = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateResourceReservationPlanInput) SetName(v string) *CreateResourceReservationPlanInput {
	s.Name = &v
	return s
}

// SetReservationConfig sets the ReservationConfig field's value.
func (s *CreateResourceReservationPlanInput) SetReservationConfig(v *ReservationConfigForCreateResourceReservationPlanInput) *CreateResourceReservationPlanInput {
	s.ReservationConfig = v
	return s
}

// SetStorageConfig sets the StorageConfig field's value.
func (s *CreateResourceReservationPlanInput) SetStorageConfig(v *StorageConfigForCreateResourceReservationPlanInput) *CreateResourceReservationPlanInput {
	s.StorageConfig = v
	return s
}

// SetWorkloadNetworkConfig sets the WorkloadNetworkConfig field's value.
func (s *CreateResourceReservationPlanInput) SetWorkloadNetworkConfig(v *WorkloadNetworkConfigForCreateResourceReservationPlanInput) *CreateResourceReservationPlanInput {
	s.WorkloadNetworkConfig = v
	return s
}

type CreateResourceReservationPlanOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Id *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateResourceReservationPlanOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResourceReservationPlanOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *CreateResourceReservationPlanOutput) SetId(v string) *CreateResourceReservationPlanOutput {
	s.Id = &v
	return s
}

type ReservationConfigForCreateResourceReservationPlanInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	MaxDurationHours *int64 `min:"4" max:"12" type:"int64" json:",omitempty"`

	MinDurationHours *int64 `min:"4" max:"12" type:"int64" json:",omitempty"`

	RecurrenceEndTime *string `type:"string" json:",omitempty"`

	RecurrenceInterval *string `type:"string" json:",omitempty"`

	RecurrenceStartTime *string `type:"string" json:",omitempty"`

	ReservationType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ReservationConfigForCreateResourceReservationPlanInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ReservationConfigForCreateResourceReservationPlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReservationConfigForCreateResourceReservationPlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReservationConfigForCreateResourceReservationPlanInput"}
	if s.MaxDurationHours != nil && *s.MaxDurationHours < 4 {
		invalidParams.Add(request.NewErrParamMinValue("MaxDurationHours", 4))
	}
	if s.MaxDurationHours != nil && *s.MaxDurationHours > 12 {
		invalidParams.Add(request.NewErrParamMaxValue("MaxDurationHours", 12))
	}
	if s.MinDurationHours != nil && *s.MinDurationHours < 4 {
		invalidParams.Add(request.NewErrParamMinValue("MinDurationHours", 4))
	}
	if s.MinDurationHours != nil && *s.MinDurationHours > 12 {
		invalidParams.Add(request.NewErrParamMaxValue("MinDurationHours", 12))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxDurationHours sets the MaxDurationHours field's value.
func (s *ReservationConfigForCreateResourceReservationPlanInput) SetMaxDurationHours(v int64) *ReservationConfigForCreateResourceReservationPlanInput {
	s.MaxDurationHours = &v
	return s
}

// SetMinDurationHours sets the MinDurationHours field's value.
func (s *ReservationConfigForCreateResourceReservationPlanInput) SetMinDurationHours(v int64) *ReservationConfigForCreateResourceReservationPlanInput {
	s.MinDurationHours = &v
	return s
}

// SetRecurrenceEndTime sets the RecurrenceEndTime field's value.
func (s *ReservationConfigForCreateResourceReservationPlanInput) SetRecurrenceEndTime(v string) *ReservationConfigForCreateResourceReservationPlanInput {
	s.RecurrenceEndTime = &v
	return s
}

// SetRecurrenceInterval sets the RecurrenceInterval field's value.
func (s *ReservationConfigForCreateResourceReservationPlanInput) SetRecurrenceInterval(v string) *ReservationConfigForCreateResourceReservationPlanInput {
	s.RecurrenceInterval = &v
	return s
}

// SetRecurrenceStartTime sets the RecurrenceStartTime field's value.
func (s *ReservationConfigForCreateResourceReservationPlanInput) SetRecurrenceStartTime(v string) *ReservationConfigForCreateResourceReservationPlanInput {
	s.RecurrenceStartTime = &v
	return s
}

// SetReservationType sets the ReservationType field's value.
func (s *ReservationConfigForCreateResourceReservationPlanInput) SetReservationType(v string) *ReservationConfigForCreateResourceReservationPlanInput {
	s.ReservationType = &v
	return s
}

type StorageConfigForCreateResourceReservationPlanInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	StorageNetworkConfig *StorageNetworkConfigForCreateResourceReservationPlanInput `type:"structure" json:",omitempty"`

	Vepfs *VepfsForCreateResourceReservationPlanInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s StorageConfigForCreateResourceReservationPlanInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageConfigForCreateResourceReservationPlanInput) GoString() string {
	return s.String()
}

// SetStorageNetworkConfig sets the StorageNetworkConfig field's value.
func (s *StorageConfigForCreateResourceReservationPlanInput) SetStorageNetworkConfig(v *StorageNetworkConfigForCreateResourceReservationPlanInput) *StorageConfigForCreateResourceReservationPlanInput {
	s.StorageNetworkConfig = v
	return s
}

// SetVepfs sets the Vepfs field's value.
func (s *StorageConfigForCreateResourceReservationPlanInput) SetVepfs(v *VepfsForCreateResourceReservationPlanInput) *StorageConfigForCreateResourceReservationPlanInput {
	s.Vepfs = v
	return s
}

type StorageNetworkConfigForCreateResourceReservationPlanInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SecurityGroupIds []*string `type:"list" json:",omitempty"`

	SubnetIds []*string `type:"list" json:",omitempty"`

	VpcId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s StorageNetworkConfigForCreateResourceReservationPlanInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageNetworkConfigForCreateResourceReservationPlanInput) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *StorageNetworkConfigForCreateResourceReservationPlanInput) SetSecurityGroupIds(v []*string) *StorageNetworkConfigForCreateResourceReservationPlanInput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *StorageNetworkConfigForCreateResourceReservationPlanInput) SetSubnetIds(v []*string) *StorageNetworkConfigForCreateResourceReservationPlanInput {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *StorageNetworkConfigForCreateResourceReservationPlanInput) SetVpcId(v string) *StorageNetworkConfigForCreateResourceReservationPlanInput {
	s.VpcId = &v
	return s
}

type VepfsForCreateResourceReservationPlanInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	EnablePrefetch *bool `type:"boolean" json:",omitempty"`

	FileSystemIds []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s VepfsForCreateResourceReservationPlanInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VepfsForCreateResourceReservationPlanInput) GoString() string {
	return s.String()
}

// SetEnablePrefetch sets the EnablePrefetch field's value.
func (s *VepfsForCreateResourceReservationPlanInput) SetEnablePrefetch(v bool) *VepfsForCreateResourceReservationPlanInput {
	s.EnablePrefetch = &v
	return s
}

// SetFileSystemIds sets the FileSystemIds field's value.
func (s *VepfsForCreateResourceReservationPlanInput) SetFileSystemIds(v []*string) *VepfsForCreateResourceReservationPlanInput {
	s.FileSystemIds = v
	return s
}

type WorkloadNetworkConfigForCreateResourceReservationPlanInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SecurityGroupIds []*string `type:"list" json:",omitempty"`

	SubnetIds []*string `type:"list" json:",omitempty"`

	VpcId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s WorkloadNetworkConfigForCreateResourceReservationPlanInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkloadNetworkConfigForCreateResourceReservationPlanInput) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *WorkloadNetworkConfigForCreateResourceReservationPlanInput) SetSecurityGroupIds(v []*string) *WorkloadNetworkConfigForCreateResourceReservationPlanInput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *WorkloadNetworkConfigForCreateResourceReservationPlanInput) SetSubnetIds(v []*string) *WorkloadNetworkConfigForCreateResourceReservationPlanInput {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *WorkloadNetworkConfigForCreateResourceReservationPlanInput) SetVpcId(v string) *WorkloadNetworkConfigForCreateResourceReservationPlanInput {
	s.VpcId = &v
	return s
}
