// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opRotateSecretCommon = "RotateSecret"

// RotateSecretCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the RotateSecretCommon operation. The "output" return
// value will be populated with the RotateSecretCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned RotateSecretCommon Request to send the API call to the service.
// the "output" return value is not valid until after RotateSecretCommon Send returns without error.
//
// See RotateSecretCommon for more information on using the RotateSecretCommon
// API call, and error handling.
//
//    // Example sending a request using the RotateSecretCommonRequest method.
//    req, resp := client.RotateSecretCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) RotateSecretCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opRotateSecretCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// RotateSecretCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation RotateSecretCommon for usage and error information.
func (c *KMS) RotateSecretCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.RotateSecretCommonRequest(input)
	return out, req.Send()
}

// RotateSecretCommonWithContext is the same as RotateSecretCommon with the addition of
// the ability to pass a context and additional request options.
//
// See RotateSecretCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) RotateSecretCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.RotateSecretCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRotateSecret = "RotateSecret"

// RotateSecretRequest generates a "volcengine/request.Request" representing the
// client's request for the RotateSecret operation. The "output" return
// value will be populated with the RotateSecretCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned RotateSecretCommon Request to send the API call to the service.
// the "output" return value is not valid until after RotateSecretCommon Send returns without error.
//
// See RotateSecret for more information on using the RotateSecret
// API call, and error handling.
//
//    // Example sending a request using the RotateSecretRequest method.
//    req, resp := client.RotateSecretRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) RotateSecretRequest(input *RotateSecretInput) (req *request.Request, output *RotateSecretOutput) {
	op := &request.Operation{
		Name:       opRotateSecret,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RotateSecretInput{}
	}

	output = &RotateSecretOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// RotateSecret API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation RotateSecret for usage and error information.
func (c *KMS) RotateSecret(input *RotateSecretInput) (*RotateSecretOutput, error) {
	req, out := c.RotateSecretRequest(input)
	return out, req.Send()
}

// RotateSecretWithContext is the same as RotateSecret with the addition of
// the ability to pass a context and additional request options.
//
// See RotateSecret for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) RotateSecretWithContext(ctx volcengine.Context, input *RotateSecretInput, opts ...request.Option) (*RotateSecretOutput, error) {
	req, out := c.RotateSecretRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type RotateSecretInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// SecretName is a required field
	SecretName *string `min:"2" max:"128" type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s RotateSecretInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RotateSecretInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RotateSecretInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RotateSecretInput"}
	if s.SecretName == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretName"))
	}
	if s.SecretName != nil && len(*s.SecretName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SecretName", 2))
	}
	if s.SecretName != nil && len(*s.SecretName) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("SecretName", 128, *s.SecretName))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecretName sets the SecretName field's value.
func (s *RotateSecretInput) SetSecretName(v string) *RotateSecretInput {
	s.SecretName = &v
	return s
}

type RotateSecretOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s RotateSecretOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RotateSecretOutput) GoString() string {
	return s.String()
}
