// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDeleteCustomKeyStoreCommon = "DeleteCustomKeyStore"

// DeleteCustomKeyStoreCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DeleteCustomKeyStoreCommon operation. The "output" return
// value will be populated with the DeleteCustomKeyStoreCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DeleteCustomKeyStoreCommon Request to send the API call to the service.
// the "output" return value is not valid until after DeleteCustomKeyStoreCommon Send returns without error.
//
// See DeleteCustomKeyStoreCommon for more information on using the DeleteCustomKeyStoreCommon
// API call, and error handling.
//
//    // Example sending a request using the DeleteCustomKeyStoreCommonRequest method.
//    req, resp := client.DeleteCustomKeyStoreCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) DeleteCustomKeyStoreCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDeleteCustomKeyStoreCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DeleteCustomKeyStoreCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation DeleteCustomKeyStoreCommon for usage and error information.
func (c *KMS) DeleteCustomKeyStoreCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DeleteCustomKeyStoreCommonRequest(input)
	return out, req.Send()
}

// DeleteCustomKeyStoreCommonWithContext is the same as DeleteCustomKeyStoreCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCustomKeyStoreCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) DeleteCustomKeyStoreCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DeleteCustomKeyStoreCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCustomKeyStore = "DeleteCustomKeyStore"

// DeleteCustomKeyStoreRequest generates a "volcengine/request.Request" representing the
// client's request for the DeleteCustomKeyStore operation. The "output" return
// value will be populated with the DeleteCustomKeyStoreCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DeleteCustomKeyStoreCommon Request to send the API call to the service.
// the "output" return value is not valid until after DeleteCustomKeyStoreCommon Send returns without error.
//
// See DeleteCustomKeyStore for more information on using the DeleteCustomKeyStore
// API call, and error handling.
//
//    // Example sending a request using the DeleteCustomKeyStoreRequest method.
//    req, resp := client.DeleteCustomKeyStoreRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) DeleteCustomKeyStoreRequest(input *DeleteCustomKeyStoreInput) (req *request.Request, output *DeleteCustomKeyStoreOutput) {
	op := &request.Operation{
		Name:       opDeleteCustomKeyStore,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCustomKeyStoreInput{}
	}

	output = &DeleteCustomKeyStoreOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DeleteCustomKeyStore API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation DeleteCustomKeyStore for usage and error information.
func (c *KMS) DeleteCustomKeyStore(input *DeleteCustomKeyStoreInput) (*DeleteCustomKeyStoreOutput, error) {
	req, out := c.DeleteCustomKeyStoreRequest(input)
	return out, req.Send()
}

// DeleteCustomKeyStoreWithContext is the same as DeleteCustomKeyStore with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCustomKeyStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) DeleteCustomKeyStoreWithContext(ctx volcengine.Context, input *DeleteCustomKeyStoreInput, opts ...request.Option) (*DeleteCustomKeyStoreOutput, error) {
	req, out := c.DeleteCustomKeyStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DeleteCustomKeyStoreInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// CustomKeyStoreID is a required field
	CustomKeyStoreID *string `min:"36" max:"36" type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s DeleteCustomKeyStoreInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCustomKeyStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCustomKeyStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCustomKeyStoreInput"}
	if s.CustomKeyStoreID == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomKeyStoreID"))
	}
	if s.CustomKeyStoreID != nil && len(*s.CustomKeyStoreID) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CustomKeyStoreID", 36))
	}
	if s.CustomKeyStoreID != nil && len(*s.CustomKeyStoreID) > 36 {
		invalidParams.Add(request.NewErrParamMaxLen("CustomKeyStoreID", 36, *s.CustomKeyStoreID))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomKeyStoreID sets the CustomKeyStoreID field's value.
func (s *DeleteCustomKeyStoreInput) SetCustomKeyStoreID(v string) *DeleteCustomKeyStoreInput {
	s.CustomKeyStoreID = &v
	return s
}

type DeleteCustomKeyStoreOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s DeleteCustomKeyStoreOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCustomKeyStoreOutput) GoString() string {
	return s.String()
}
