// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package dns

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListRecordsCommon = "ListRecords"

// ListRecordsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListRecordsCommon operation. The "output" return
// value will be populated with the ListRecordsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListRecordsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListRecordsCommon Send returns without error.
//
// See ListRecordsCommon for more information on using the ListRecordsCommon
// API call, and error handling.
//
//    // Example sending a request using the ListRecordsCommonRequest method.
//    req, resp := client.ListRecordsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DNS) ListRecordsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListRecordsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListRecordsCommon API operation for DNS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DNS's
// API operation ListRecordsCommon for usage and error information.
func (c *DNS) ListRecordsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListRecordsCommonRequest(input)
	return out, req.Send()
}

// ListRecordsCommonWithContext is the same as ListRecordsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListRecordsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DNS) ListRecordsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListRecordsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRecords = "ListRecords"

// ListRecordsRequest generates a "volcengine/request.Request" representing the
// client's request for the ListRecords operation. The "output" return
// value will be populated with the ListRecordsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListRecordsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListRecordsCommon Send returns without error.
//
// See ListRecords for more information on using the ListRecords
// API call, and error handling.
//
//    // Example sending a request using the ListRecordsRequest method.
//    req, resp := client.ListRecordsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DNS) ListRecordsRequest(input *ListRecordsInput) (req *request.Request, output *ListRecordsOutput) {
	op := &request.Operation{
		Name:       opListRecords,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRecordsInput{}
	}

	output = &ListRecordsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListRecords API operation for DNS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DNS's
// API operation ListRecords for usage and error information.
func (c *DNS) ListRecords(input *ListRecordsInput) (*ListRecordsOutput, error) {
	req, out := c.ListRecordsRequest(input)
	return out, req.Send()
}

// ListRecordsWithContext is the same as ListRecords with the addition of
// the ability to pass a context and additional request options.
//
// See ListRecords for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DNS) ListRecordsWithContext(ctx volcengine.Context, input *ListRecordsInput, opts ...request.Option) (*ListRecordsOutput, error) {
	req, out := c.ListRecordsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ListRecordsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Host *string `type:"string" json:",omitempty"`

	Line *string `type:"string" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	SearchMode *string `type:"string" json:",omitempty"`

	SearchOrder *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`

	// ZID is a required field
	ZID *int64 `type:"int64" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s ListRecordsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRecordsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRecordsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRecordsInput"}
	if s.ZID == nil {
		invalidParams.Add(request.NewErrParamRequired("ZID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHost sets the Host field's value.
func (s *ListRecordsInput) SetHost(v string) *ListRecordsInput {
	s.Host = &v
	return s
}

// SetLine sets the Line field's value.
func (s *ListRecordsInput) SetLine(v string) *ListRecordsInput {
	s.Line = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListRecordsInput) SetPageNumber(v int32) *ListRecordsInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListRecordsInput) SetPageSize(v int32) *ListRecordsInput {
	s.PageSize = &v
	return s
}

// SetSearchMode sets the SearchMode field's value.
func (s *ListRecordsInput) SetSearchMode(v string) *ListRecordsInput {
	s.SearchMode = &v
	return s
}

// SetSearchOrder sets the SearchOrder field's value.
func (s *ListRecordsInput) SetSearchOrder(v string) *ListRecordsInput {
	s.SearchOrder = &v
	return s
}

// SetType sets the Type field's value.
func (s *ListRecordsInput) SetType(v string) *ListRecordsInput {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ListRecordsInput) SetValue(v string) *ListRecordsInput {
	s.Value = &v
	return s
}

// SetZID sets the ZID field's value.
func (s *ListRecordsInput) SetZID(v int64) *ListRecordsInput {
	s.ZID = &v
	return s
}

type ListRecordsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	Records []*RecordForListRecordsOutput `type:"list" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListRecordsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRecordsOutput) GoString() string {
	return s.String()
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListRecordsOutput) SetPageNumber(v int32) *ListRecordsOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListRecordsOutput) SetPageSize(v int32) *ListRecordsOutput {
	s.PageSize = &v
	return s
}

// SetRecords sets the Records field's value.
func (s *ListRecordsOutput) SetRecords(v []*RecordForListRecordsOutput) *ListRecordsOutput {
	s.Records = v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListRecordsOutput) SetTotalCount(v int32) *ListRecordsOutput {
	s.TotalCount = &v
	return s
}

type RecordForListRecordsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreatedAt *string `type:"string" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	FQDN *string `type:"string" json:",omitempty"`

	Host *string `type:"string" json:",omitempty"`

	Line *string `type:"string" json:",omitempty"`

	Operators []*string `type:"list" json:",omitempty"`

	PQDN *string `type:"string" json:",omitempty"`

	RecordID *string `type:"string" json:",omitempty"`

	RecordSetID *string `type:"string" json:",omitempty"`

	Remark *string `type:"string" json:",omitempty"`

	TTL *int32 `type:"int32" json:",omitempty"`

	Tags []*string `type:"list" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	UpdatedAt *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`

	Weight *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s RecordForListRecordsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RecordForListRecordsOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *RecordForListRecordsOutput) SetCreatedAt(v string) *RecordForListRecordsOutput {
	s.CreatedAt = &v
	return s
}

// SetEnable sets the Enable field's value.
func (s *RecordForListRecordsOutput) SetEnable(v bool) *RecordForListRecordsOutput {
	s.Enable = &v
	return s
}

// SetFQDN sets the FQDN field's value.
func (s *RecordForListRecordsOutput) SetFQDN(v string) *RecordForListRecordsOutput {
	s.FQDN = &v
	return s
}

// SetHost sets the Host field's value.
func (s *RecordForListRecordsOutput) SetHost(v string) *RecordForListRecordsOutput {
	s.Host = &v
	return s
}

// SetLine sets the Line field's value.
func (s *RecordForListRecordsOutput) SetLine(v string) *RecordForListRecordsOutput {
	s.Line = &v
	return s
}

// SetOperators sets the Operators field's value.
func (s *RecordForListRecordsOutput) SetOperators(v []*string) *RecordForListRecordsOutput {
	s.Operators = v
	return s
}

// SetPQDN sets the PQDN field's value.
func (s *RecordForListRecordsOutput) SetPQDN(v string) *RecordForListRecordsOutput {
	s.PQDN = &v
	return s
}

// SetRecordID sets the RecordID field's value.
func (s *RecordForListRecordsOutput) SetRecordID(v string) *RecordForListRecordsOutput {
	s.RecordID = &v
	return s
}

// SetRecordSetID sets the RecordSetID field's value.
func (s *RecordForListRecordsOutput) SetRecordSetID(v string) *RecordForListRecordsOutput {
	s.RecordSetID = &v
	return s
}

// SetRemark sets the Remark field's value.
func (s *RecordForListRecordsOutput) SetRemark(v string) *RecordForListRecordsOutput {
	s.Remark = &v
	return s
}

// SetTTL sets the TTL field's value.
func (s *RecordForListRecordsOutput) SetTTL(v int32) *RecordForListRecordsOutput {
	s.TTL = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RecordForListRecordsOutput) SetTags(v []*string) *RecordForListRecordsOutput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *RecordForListRecordsOutput) SetType(v string) *RecordForListRecordsOutput {
	s.Type = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *RecordForListRecordsOutput) SetUpdatedAt(v string) *RecordForListRecordsOutput {
	s.UpdatedAt = &v
	return s
}

// SetValue sets the Value field's value.
func (s *RecordForListRecordsOutput) SetValue(v string) *RecordForListRecordsOutput {
	s.Value = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *RecordForListRecordsOutput) SetWeight(v int32) *RecordForListRecordsOutput {
	s.Weight = &v
	return s
}
