// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package cdn

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeCdnConfigCommon = "DescribeCdnConfig"

// DescribeCdnConfigCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeCdnConfigCommon operation. The "output" return
// value will be populated with the DescribeCdnConfigCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeCdnConfigCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeCdnConfigCommon Send returns without error.
//
// See DescribeCdnConfigCommon for more information on using the DescribeCdnConfigCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeCdnConfigCommonRequest method.
//    req, resp := client.DescribeCdnConfigCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CDN) DescribeCdnConfigCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeCdnConfigCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeCdnConfigCommon API operation for CDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CDN's
// API operation DescribeCdnConfigCommon for usage and error information.
func (c *CDN) DescribeCdnConfigCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeCdnConfigCommonRequest(input)
	return out, req.Send()
}

// DescribeCdnConfigCommonWithContext is the same as DescribeCdnConfigCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCdnConfigCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CDN) DescribeCdnConfigCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeCdnConfigCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCdnConfig = "DescribeCdnConfig"

// DescribeCdnConfigRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeCdnConfig operation. The "output" return
// value will be populated with the DescribeCdnConfigCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeCdnConfigCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeCdnConfigCommon Send returns without error.
//
// See DescribeCdnConfig for more information on using the DescribeCdnConfig
// API call, and error handling.
//
//    // Example sending a request using the DescribeCdnConfigRequest method.
//    req, resp := client.DescribeCdnConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CDN) DescribeCdnConfigRequest(input *DescribeCdnConfigInput) (req *request.Request, output *DescribeCdnConfigOutput) {
	op := &request.Operation{
		Name:       opDescribeCdnConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCdnConfigInput{}
	}

	output = &DescribeCdnConfigOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeCdnConfig API operation for CDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CDN's
// API operation DescribeCdnConfig for usage and error information.
func (c *CDN) DescribeCdnConfig(input *DescribeCdnConfigInput) (*DescribeCdnConfigOutput, error) {
	req, out := c.DescribeCdnConfigRequest(input)
	return out, req.Send()
}

// DescribeCdnConfigWithContext is the same as DescribeCdnConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCdnConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CDN) DescribeCdnConfigWithContext(ctx volcengine.Context, input *DescribeCdnConfigInput, opts ...request.Option) (*DescribeCdnConfigOutput, error) {
	req, out := c.DescribeCdnConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AccessActionForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AllowEmpty *bool `type:"boolean" json:",omitempty"`

	ListRules []*string `type:"list" json:",omitempty"`

	RequestHeader *string `type:"string" json:",omitempty"`

	RuleType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s AccessActionForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessActionForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetAllowEmpty sets the AllowEmpty field's value.
func (s *AccessActionForDescribeCdnConfigOutput) SetAllowEmpty(v bool) *AccessActionForDescribeCdnConfigOutput {
	s.AllowEmpty = &v
	return s
}

// SetListRules sets the ListRules field's value.
func (s *AccessActionForDescribeCdnConfigOutput) SetListRules(v []*string) *AccessActionForDescribeCdnConfigOutput {
	s.ListRules = v
	return s
}

// SetRequestHeader sets the RequestHeader field's value.
func (s *AccessActionForDescribeCdnConfigOutput) SetRequestHeader(v string) *AccessActionForDescribeCdnConfigOutput {
	s.RequestHeader = &v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *AccessActionForDescribeCdnConfigOutput) SetRuleType(v string) *AccessActionForDescribeCdnConfigOutput {
	s.RuleType = &v
	return s
}

type ActionsForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	OriginLines []*OriginLineForDescribeCdnConfigOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ActionsForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionsForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetOriginLines sets the OriginLines field's value.
func (s *ActionsForDescribeCdnConfigOutput) SetOriginLines(v []*OriginLineForDescribeCdnConfigOutput) *ActionsForDescribeCdnConfigOutput {
	s.OriginLines = v
	return s
}

type AreaAccessRuleForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Area []*string `type:"list" json:",omitempty"`

	RuleType *string `type:"string" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s AreaAccessRuleForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AreaAccessRuleForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetArea sets the Area field's value.
func (s *AreaAccessRuleForDescribeCdnConfigOutput) SetArea(v []*string) *AreaAccessRuleForDescribeCdnConfigOutput {
	s.Area = v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *AreaAccessRuleForDescribeCdnConfigOutput) SetRuleType(v string) *AreaAccessRuleForDescribeCdnConfigOutput {
	s.RuleType = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *AreaAccessRuleForDescribeCdnConfigOutput) SetSwitch(v bool) *AreaAccessRuleForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type AuthModeConfigForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BackupRemoteAddr *string `type:"string" json:",omitempty"`

	MasterRemoteAddr *string `type:"string" json:",omitempty"`

	PathType *string `type:"string" json:",omitempty"`

	PathValue *string `type:"string" json:",omitempty"`

	RequestMethod *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s AuthModeConfigForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthModeConfigForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetBackupRemoteAddr sets the BackupRemoteAddr field's value.
func (s *AuthModeConfigForDescribeCdnConfigOutput) SetBackupRemoteAddr(v string) *AuthModeConfigForDescribeCdnConfigOutput {
	s.BackupRemoteAddr = &v
	return s
}

// SetMasterRemoteAddr sets the MasterRemoteAddr field's value.
func (s *AuthModeConfigForDescribeCdnConfigOutput) SetMasterRemoteAddr(v string) *AuthModeConfigForDescribeCdnConfigOutput {
	s.MasterRemoteAddr = &v
	return s
}

// SetPathType sets the PathType field's value.
func (s *AuthModeConfigForDescribeCdnConfigOutput) SetPathType(v string) *AuthModeConfigForDescribeCdnConfigOutput {
	s.PathType = &v
	return s
}

// SetPathValue sets the PathValue field's value.
func (s *AuthModeConfigForDescribeCdnConfigOutput) SetPathValue(v string) *AuthModeConfigForDescribeCdnConfigOutput {
	s.PathValue = &v
	return s
}

// SetRequestMethod sets the RequestMethod field's value.
func (s *AuthModeConfigForDescribeCdnConfigOutput) SetRequestMethod(v string) *AuthModeConfigForDescribeCdnConfigOutput {
	s.RequestMethod = &v
	return s
}

type AuthResponseConfigForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CacheAction *ConvertCacheActionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	ResponseAction *ResponseActionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	StatusCodeAction *StatusCodeActionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	TimeOutAction *TimeOutActionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s AuthResponseConfigForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AuthResponseConfigForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCacheAction sets the CacheAction field's value.
func (s *AuthResponseConfigForDescribeCdnConfigOutput) SetCacheAction(v *ConvertCacheActionForDescribeCdnConfigOutput) *AuthResponseConfigForDescribeCdnConfigOutput {
	s.CacheAction = v
	return s
}

// SetResponseAction sets the ResponseAction field's value.
func (s *AuthResponseConfigForDescribeCdnConfigOutput) SetResponseAction(v *ResponseActionForDescribeCdnConfigOutput) *AuthResponseConfigForDescribeCdnConfigOutput {
	s.ResponseAction = v
	return s
}

// SetStatusCodeAction sets the StatusCodeAction field's value.
func (s *AuthResponseConfigForDescribeCdnConfigOutput) SetStatusCodeAction(v *StatusCodeActionForDescribeCdnConfigOutput) *AuthResponseConfigForDescribeCdnConfigOutput {
	s.StatusCodeAction = v
	return s
}

// SetTimeOutAction sets the TimeOutAction field's value.
func (s *AuthResponseConfigForDescribeCdnConfigOutput) SetTimeOutAction(v *TimeOutActionForDescribeCdnConfigOutput) *AuthResponseConfigForDescribeCdnConfigOutput {
	s.TimeOutAction = v
	return s
}

type BandwidthLimitActionForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BandwidthThreshold *int64 `type:"int64" json:",omitempty"`

	LimitType *string `type:"string" json:",omitempty"`

	SpeedLimitRate *int64 `type:"int64" json:",omitempty"`

	SpeedLimitRateMax *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s BandwidthLimitActionForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BandwidthLimitActionForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetBandwidthThreshold sets the BandwidthThreshold field's value.
func (s *BandwidthLimitActionForDescribeCdnConfigOutput) SetBandwidthThreshold(v int64) *BandwidthLimitActionForDescribeCdnConfigOutput {
	s.BandwidthThreshold = &v
	return s
}

// SetLimitType sets the LimitType field's value.
func (s *BandwidthLimitActionForDescribeCdnConfigOutput) SetLimitType(v string) *BandwidthLimitActionForDescribeCdnConfigOutput {
	s.LimitType = &v
	return s
}

// SetSpeedLimitRate sets the SpeedLimitRate field's value.
func (s *BandwidthLimitActionForDescribeCdnConfigOutput) SetSpeedLimitRate(v int64) *BandwidthLimitActionForDescribeCdnConfigOutput {
	s.SpeedLimitRate = &v
	return s
}

// SetSpeedLimitRateMax sets the SpeedLimitRateMax field's value.
func (s *BandwidthLimitActionForDescribeCdnConfigOutput) SetSpeedLimitRateMax(v int64) *BandwidthLimitActionForDescribeCdnConfigOutput {
	s.SpeedLimitRateMax = &v
	return s
}

type BandwidthLimitForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BandwidthLimitRule *BandwidthLimitRuleForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s BandwidthLimitForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BandwidthLimitForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetBandwidthLimitRule sets the BandwidthLimitRule field's value.
func (s *BandwidthLimitForDescribeCdnConfigOutput) SetBandwidthLimitRule(v *BandwidthLimitRuleForDescribeCdnConfigOutput) *BandwidthLimitForDescribeCdnConfigOutput {
	s.BandwidthLimitRule = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *BandwidthLimitForDescribeCdnConfigOutput) SetSwitch(v bool) *BandwidthLimitForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type BandwidthLimitRuleForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BandwidthLimitAction *BandwidthLimitActionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	Condition *ConditionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s BandwidthLimitRuleForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BandwidthLimitRuleForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetBandwidthLimitAction sets the BandwidthLimitAction field's value.
func (s *BandwidthLimitRuleForDescribeCdnConfigOutput) SetBandwidthLimitAction(v *BandwidthLimitActionForDescribeCdnConfigOutput) *BandwidthLimitRuleForDescribeCdnConfigOutput {
	s.BandwidthLimitAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *BandwidthLimitRuleForDescribeCdnConfigOutput) SetCondition(v *ConditionForDescribeCdnConfigOutput) *BandwidthLimitRuleForDescribeCdnConfigOutput {
	s.Condition = v
	return s
}

type BlockActionForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Action *string `type:"string" json:",omitempty"`

	ErrorPage *string `type:"string" json:",omitempty"`

	RedirectUrl *string `type:"string" json:",omitempty"`

	StatusCode *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s BlockActionForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BlockActionForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *BlockActionForDescribeCdnConfigOutput) SetAction(v string) *BlockActionForDescribeCdnConfigOutput {
	s.Action = &v
	return s
}

// SetErrorPage sets the ErrorPage field's value.
func (s *BlockActionForDescribeCdnConfigOutput) SetErrorPage(v string) *BlockActionForDescribeCdnConfigOutput {
	s.ErrorPage = &v
	return s
}

// SetRedirectUrl sets the RedirectUrl field's value.
func (s *BlockActionForDescribeCdnConfigOutput) SetRedirectUrl(v string) *BlockActionForDescribeCdnConfigOutput {
	s.RedirectUrl = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *BlockActionForDescribeCdnConfigOutput) SetStatusCode(v string) *BlockActionForDescribeCdnConfigOutput {
	s.StatusCode = &v
	return s
}

type BlockRuleForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BlockAction *BlockActionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	Condition *ConditionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	RuleName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s BlockRuleForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BlockRuleForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetBlockAction sets the BlockAction field's value.
func (s *BlockRuleForDescribeCdnConfigOutput) SetBlockAction(v *BlockActionForDescribeCdnConfigOutput) *BlockRuleForDescribeCdnConfigOutput {
	s.BlockAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *BlockRuleForDescribeCdnConfigOutput) SetCondition(v *ConditionForDescribeCdnConfigOutput) *BlockRuleForDescribeCdnConfigOutput {
	s.Condition = v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *BlockRuleForDescribeCdnConfigOutput) SetRuleName(v string) *BlockRuleForDescribeCdnConfigOutput {
	s.RuleName = &v
	return s
}

type BrowserCacheForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CacheAction *CacheActionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	Condition *ConditionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s BrowserCacheForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BrowserCacheForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCacheAction sets the CacheAction field's value.
func (s *BrowserCacheForDescribeCdnConfigOutput) SetCacheAction(v *CacheActionForDescribeCdnConfigOutput) *BrowserCacheForDescribeCdnConfigOutput {
	s.CacheAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *BrowserCacheForDescribeCdnConfigOutput) SetCondition(v *ConditionForDescribeCdnConfigOutput) *BrowserCacheForDescribeCdnConfigOutput {
	s.Condition = v
	return s
}

type CacheActionForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Action *string `type:"string" json:",omitempty"`

	DefaultPolicy *string `type:"string" json:",omitempty"`

	IgnoreCase *bool `type:"boolean" json:",omitempty"`

	Ttl *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s CacheActionForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheActionForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *CacheActionForDescribeCdnConfigOutput) SetAction(v string) *CacheActionForDescribeCdnConfigOutput {
	s.Action = &v
	return s
}

// SetDefaultPolicy sets the DefaultPolicy field's value.
func (s *CacheActionForDescribeCdnConfigOutput) SetDefaultPolicy(v string) *CacheActionForDescribeCdnConfigOutput {
	s.DefaultPolicy = &v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *CacheActionForDescribeCdnConfigOutput) SetIgnoreCase(v bool) *CacheActionForDescribeCdnConfigOutput {
	s.IgnoreCase = &v
	return s
}

// SetTtl sets the Ttl field's value.
func (s *CacheActionForDescribeCdnConfigOutput) SetTtl(v int64) *CacheActionForDescribeCdnConfigOutput {
	s.Ttl = &v
	return s
}

type CacheForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CacheAction *CacheActionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	Condition *ConditionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CacheForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCacheAction sets the CacheAction field's value.
func (s *CacheForDescribeCdnConfigOutput) SetCacheAction(v *CacheActionForDescribeCdnConfigOutput) *CacheForDescribeCdnConfigOutput {
	s.CacheAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *CacheForDescribeCdnConfigOutput) SetCondition(v *ConditionForDescribeCdnConfigOutput) *CacheForDescribeCdnConfigOutput {
	s.Condition = v
	return s
}

type CacheHostActionForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CacheHost *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CacheHostActionForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheHostActionForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCacheHost sets the CacheHost field's value.
func (s *CacheHostActionForDescribeCdnConfigOutput) SetCacheHost(v string) *CacheHostActionForDescribeCdnConfigOutput {
	s.CacheHost = &v
	return s
}

type CacheHostForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CacheHostRule []*CacheHostRuleForDescribeCdnConfigOutput `type:"list" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s CacheHostForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheHostForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCacheHostRule sets the CacheHostRule field's value.
func (s *CacheHostForDescribeCdnConfigOutput) SetCacheHostRule(v []*CacheHostRuleForDescribeCdnConfigOutput) *CacheHostForDescribeCdnConfigOutput {
	s.CacheHostRule = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *CacheHostForDescribeCdnConfigOutput) SetSwitch(v bool) *CacheHostForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type CacheHostRuleForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CacheHostAction *CacheHostActionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	Condition *ConditionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CacheHostRuleForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheHostRuleForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCacheHostAction sets the CacheHostAction field's value.
func (s *CacheHostRuleForDescribeCdnConfigOutput) SetCacheHostAction(v *CacheHostActionForDescribeCdnConfigOutput) *CacheHostRuleForDescribeCdnConfigOutput {
	s.CacheHostAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *CacheHostRuleForDescribeCdnConfigOutput) SetCondition(v *ConditionForDescribeCdnConfigOutput) *CacheHostRuleForDescribeCdnConfigOutput {
	s.Condition = v
	return s
}

type CacheKeyActionForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CacheKeyComponents []*CacheKeyComponentForDescribeCdnConfigOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s CacheKeyActionForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheKeyActionForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCacheKeyComponents sets the CacheKeyComponents field's value.
func (s *CacheKeyActionForDescribeCdnConfigOutput) SetCacheKeyComponents(v []*CacheKeyComponentForDescribeCdnConfigOutput) *CacheKeyActionForDescribeCdnConfigOutput {
	s.CacheKeyComponents = v
	return s
}

type CacheKeyComponentForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Action *string `type:"string" json:",omitempty"`

	IgnoreCase *bool `type:"boolean" json:",omitempty"`

	Object *string `type:"string" json:",omitempty"`

	Subobject *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CacheKeyComponentForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheKeyComponentForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *CacheKeyComponentForDescribeCdnConfigOutput) SetAction(v string) *CacheKeyComponentForDescribeCdnConfigOutput {
	s.Action = &v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *CacheKeyComponentForDescribeCdnConfigOutput) SetIgnoreCase(v bool) *CacheKeyComponentForDescribeCdnConfigOutput {
	s.IgnoreCase = &v
	return s
}

// SetObject sets the Object field's value.
func (s *CacheKeyComponentForDescribeCdnConfigOutput) SetObject(v string) *CacheKeyComponentForDescribeCdnConfigOutput {
	s.Object = &v
	return s
}

// SetSubobject sets the Subobject field's value.
func (s *CacheKeyComponentForDescribeCdnConfigOutput) SetSubobject(v string) *CacheKeyComponentForDescribeCdnConfigOutput {
	s.Subobject = &v
	return s
}

type CacheKeyForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CacheKeyAction *CacheKeyActionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	Condition *ConditionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CacheKeyForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheKeyForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCacheKeyAction sets the CacheKeyAction field's value.
func (s *CacheKeyForDescribeCdnConfigOutput) SetCacheKeyAction(v *CacheKeyActionForDescribeCdnConfigOutput) *CacheKeyForDescribeCdnConfigOutput {
	s.CacheKeyAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *CacheKeyForDescribeCdnConfigOutput) SetCondition(v *ConditionForDescribeCdnConfigOutput) *CacheKeyForDescribeCdnConfigOutput {
	s.Condition = v
	return s
}

type CertCheckForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CertInfoList []*CertInfoListForDescribeCdnConfigOutput `type:"list" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s CertCheckForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CertCheckForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCertInfoList sets the CertInfoList field's value.
func (s *CertCheckForDescribeCdnConfigOutput) SetCertInfoList(v []*CertInfoListForDescribeCdnConfigOutput) *CertCheckForDescribeCdnConfigOutput {
	s.CertInfoList = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *CertCheckForDescribeCdnConfigOutput) SetSwitch(v bool) *CertCheckForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type CertInfoForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CertId *string `type:"string" json:",omitempty"`

	CertName *string `type:"string" json:",omitempty"`

	Certificate *CertificateForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	Desc *string `type:"string" json:",omitempty"`

	EffectiveTime *int64 `type:"int64" json:",omitempty"`

	EncryType *string `type:"string" json:",omitempty"`

	ExpireTime *int64 `type:"int64" json:",omitempty"`

	Source *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CertInfoForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CertInfoForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCertId sets the CertId field's value.
func (s *CertInfoForDescribeCdnConfigOutput) SetCertId(v string) *CertInfoForDescribeCdnConfigOutput {
	s.CertId = &v
	return s
}

// SetCertName sets the CertName field's value.
func (s *CertInfoForDescribeCdnConfigOutput) SetCertName(v string) *CertInfoForDescribeCdnConfigOutput {
	s.CertName = &v
	return s
}

// SetCertificate sets the Certificate field's value.
func (s *CertInfoForDescribeCdnConfigOutput) SetCertificate(v *CertificateForDescribeCdnConfigOutput) *CertInfoForDescribeCdnConfigOutput {
	s.Certificate = v
	return s
}

// SetDesc sets the Desc field's value.
func (s *CertInfoForDescribeCdnConfigOutput) SetDesc(v string) *CertInfoForDescribeCdnConfigOutput {
	s.Desc = &v
	return s
}

// SetEffectiveTime sets the EffectiveTime field's value.
func (s *CertInfoForDescribeCdnConfigOutput) SetEffectiveTime(v int64) *CertInfoForDescribeCdnConfigOutput {
	s.EffectiveTime = &v
	return s
}

// SetEncryType sets the EncryType field's value.
func (s *CertInfoForDescribeCdnConfigOutput) SetEncryType(v string) *CertInfoForDescribeCdnConfigOutput {
	s.EncryType = &v
	return s
}

// SetExpireTime sets the ExpireTime field's value.
func (s *CertInfoForDescribeCdnConfigOutput) SetExpireTime(v int64) *CertInfoForDescribeCdnConfigOutput {
	s.ExpireTime = &v
	return s
}

// SetSource sets the Source field's value.
func (s *CertInfoForDescribeCdnConfigOutput) SetSource(v string) *CertInfoForDescribeCdnConfigOutput {
	s.Source = &v
	return s
}

type CertInfoListForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CertId *string `type:"string" json:",omitempty"`

	CertName *string `type:"string" json:",omitempty"`

	Certificate *CertificateForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	Desc *string `type:"string" json:",omitempty"`

	EffectiveTime *int64 `type:"int64" json:",omitempty"`

	EncryType *string `type:"string" json:",omitempty"`

	ExpireTime *int64 `type:"int64" json:",omitempty"`

	Source *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CertInfoListForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CertInfoListForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCertId sets the CertId field's value.
func (s *CertInfoListForDescribeCdnConfigOutput) SetCertId(v string) *CertInfoListForDescribeCdnConfigOutput {
	s.CertId = &v
	return s
}

// SetCertName sets the CertName field's value.
func (s *CertInfoListForDescribeCdnConfigOutput) SetCertName(v string) *CertInfoListForDescribeCdnConfigOutput {
	s.CertName = &v
	return s
}

// SetCertificate sets the Certificate field's value.
func (s *CertInfoListForDescribeCdnConfigOutput) SetCertificate(v *CertificateForDescribeCdnConfigOutput) *CertInfoListForDescribeCdnConfigOutput {
	s.Certificate = v
	return s
}

// SetDesc sets the Desc field's value.
func (s *CertInfoListForDescribeCdnConfigOutput) SetDesc(v string) *CertInfoListForDescribeCdnConfigOutput {
	s.Desc = &v
	return s
}

// SetEffectiveTime sets the EffectiveTime field's value.
func (s *CertInfoListForDescribeCdnConfigOutput) SetEffectiveTime(v int64) *CertInfoListForDescribeCdnConfigOutput {
	s.EffectiveTime = &v
	return s
}

// SetEncryType sets the EncryType field's value.
func (s *CertInfoListForDescribeCdnConfigOutput) SetEncryType(v string) *CertInfoListForDescribeCdnConfigOutput {
	s.EncryType = &v
	return s
}

// SetExpireTime sets the ExpireTime field's value.
func (s *CertInfoListForDescribeCdnConfigOutput) SetExpireTime(v int64) *CertInfoListForDescribeCdnConfigOutput {
	s.ExpireTime = &v
	return s
}

// SetSource sets the Source field's value.
func (s *CertInfoListForDescribeCdnConfigOutput) SetSource(v string) *CertInfoListForDescribeCdnConfigOutput {
	s.Source = &v
	return s
}

type CertificateForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Certificate *string `type:"string" json:",omitempty"`

	EncryptionCert *string `type:"string" json:",omitempty"`

	EncryptionKey *string `type:"string" json:",omitempty"`

	PrivateKey *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CertificateForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CertificateForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCertificate sets the Certificate field's value.
func (s *CertificateForDescribeCdnConfigOutput) SetCertificate(v string) *CertificateForDescribeCdnConfigOutput {
	s.Certificate = &v
	return s
}

// SetEncryptionCert sets the EncryptionCert field's value.
func (s *CertificateForDescribeCdnConfigOutput) SetEncryptionCert(v string) *CertificateForDescribeCdnConfigOutput {
	s.EncryptionCert = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *CertificateForDescribeCdnConfigOutput) SetEncryptionKey(v string) *CertificateForDescribeCdnConfigOutput {
	s.EncryptionKey = &v
	return s
}

// SetPrivateKey sets the PrivateKey field's value.
func (s *CertificateForDescribeCdnConfigOutput) SetPrivateKey(v string) *CertificateForDescribeCdnConfigOutput {
	s.PrivateKey = &v
	return s
}

type CommonTypeForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	IgnoreCase *bool `type:"boolean" json:",omitempty"`

	IgnoreScheme *bool `type:"boolean" json:",omitempty"`

	Referers []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s CommonTypeForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CommonTypeForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *CommonTypeForDescribeCdnConfigOutput) SetIgnoreCase(v bool) *CommonTypeForDescribeCdnConfigOutput {
	s.IgnoreCase = &v
	return s
}

// SetIgnoreScheme sets the IgnoreScheme field's value.
func (s *CommonTypeForDescribeCdnConfigOutput) SetIgnoreScheme(v bool) *CommonTypeForDescribeCdnConfigOutput {
	s.IgnoreScheme = &v
	return s
}

// SetReferers sets the Referers field's value.
func (s *CommonTypeForDescribeCdnConfigOutput) SetReferers(v []*string) *CommonTypeForDescribeCdnConfigOutput {
	s.Referers = v
	return s
}

type CompressionActionForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CompressionFormat *string `type:"string" json:",omitempty"`

	CompressionTarget *string `type:"string" json:",omitempty"`

	CompressionType []*string `type:"list" json:",omitempty"`

	MaxFileSizeKB *int64 `type:"int64" json:",omitempty"`

	MinFileSizeKB *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s CompressionActionForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CompressionActionForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCompressionFormat sets the CompressionFormat field's value.
func (s *CompressionActionForDescribeCdnConfigOutput) SetCompressionFormat(v string) *CompressionActionForDescribeCdnConfigOutput {
	s.CompressionFormat = &v
	return s
}

// SetCompressionTarget sets the CompressionTarget field's value.
func (s *CompressionActionForDescribeCdnConfigOutput) SetCompressionTarget(v string) *CompressionActionForDescribeCdnConfigOutput {
	s.CompressionTarget = &v
	return s
}

// SetCompressionType sets the CompressionType field's value.
func (s *CompressionActionForDescribeCdnConfigOutput) SetCompressionType(v []*string) *CompressionActionForDescribeCdnConfigOutput {
	s.CompressionType = v
	return s
}

// SetMaxFileSizeKB sets the MaxFileSizeKB field's value.
func (s *CompressionActionForDescribeCdnConfigOutput) SetMaxFileSizeKB(v int64) *CompressionActionForDescribeCdnConfigOutput {
	s.MaxFileSizeKB = &v
	return s
}

// SetMinFileSizeKB sets the MinFileSizeKB field's value.
func (s *CompressionActionForDescribeCdnConfigOutput) SetMinFileSizeKB(v int64) *CompressionActionForDescribeCdnConfigOutput {
	s.MinFileSizeKB = &v
	return s
}

type CompressionForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CompressionRules []*CompressionRuleForDescribeCdnConfigOutput `type:"list" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s CompressionForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CompressionForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCompressionRules sets the CompressionRules field's value.
func (s *CompressionForDescribeCdnConfigOutput) SetCompressionRules(v []*CompressionRuleForDescribeCdnConfigOutput) *CompressionForDescribeCdnConfigOutput {
	s.CompressionRules = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *CompressionForDescribeCdnConfigOutput) SetSwitch(v bool) *CompressionForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type CompressionRuleForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CompressionAction *CompressionActionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	Condition *ConditionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CompressionRuleForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CompressionRuleForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCompressionAction sets the CompressionAction field's value.
func (s *CompressionRuleForDescribeCdnConfigOutput) SetCompressionAction(v *CompressionActionForDescribeCdnConfigOutput) *CompressionRuleForDescribeCdnConfigOutput {
	s.CompressionAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *CompressionRuleForDescribeCdnConfigOutput) SetCondition(v *ConditionForDescribeCdnConfigOutput) *CompressionRuleForDescribeCdnConfigOutput {
	s.Condition = v
	return s
}

type ConditionForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ConditionRule []*ConditionRuleForDescribeCdnConfigOutput `type:"list" json:",omitempty"`

	Connective *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ConditionForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConditionForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetConditionRule sets the ConditionRule field's value.
func (s *ConditionForDescribeCdnConfigOutput) SetConditionRule(v []*ConditionRuleForDescribeCdnConfigOutput) *ConditionForDescribeCdnConfigOutput {
	s.ConditionRule = v
	return s
}

// SetConnective sets the Connective field's value.
func (s *ConditionForDescribeCdnConfigOutput) SetConnective(v string) *ConditionForDescribeCdnConfigOutput {
	s.Connective = &v
	return s
}

type ConditionGroupForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Condition *ConvertConditionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	IsGroup *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s ConditionGroupForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConditionGroupForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *ConditionGroupForDescribeCdnConfigOutput) SetCondition(v *ConvertConditionForDescribeCdnConfigOutput) *ConditionGroupForDescribeCdnConfigOutput {
	s.Condition = v
	return s
}

// SetIsGroup sets the IsGroup field's value.
func (s *ConditionGroupForDescribeCdnConfigOutput) SetIsGroup(v bool) *ConditionGroupForDescribeCdnConfigOutput {
	s.IsGroup = &v
	return s
}

type ConditionRuleForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Object *string `type:"string" json:",omitempty"`

	Operator *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ConditionRuleForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConditionRuleForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ConditionRuleForDescribeCdnConfigOutput) SetName(v string) *ConditionRuleForDescribeCdnConfigOutput {
	s.Name = &v
	return s
}

// SetObject sets the Object field's value.
func (s *ConditionRuleForDescribeCdnConfigOutput) SetObject(v string) *ConditionRuleForDescribeCdnConfigOutput {
	s.Object = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *ConditionRuleForDescribeCdnConfigOutput) SetOperator(v string) *ConditionRuleForDescribeCdnConfigOutput {
	s.Operator = &v
	return s
}

// SetType sets the Type field's value.
func (s *ConditionRuleForDescribeCdnConfigOutput) SetType(v string) *ConditionRuleForDescribeCdnConfigOutput {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ConditionRuleForDescribeCdnConfigOutput) SetValue(v string) *ConditionRuleForDescribeCdnConfigOutput {
	s.Value = &v
	return s
}

type ConditionalOriginForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	OriginRules []*OriginRuleForDescribeCdnConfigOutput `type:"list" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s ConditionalOriginForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConditionalOriginForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetOriginRules sets the OriginRules field's value.
func (s *ConditionalOriginForDescribeCdnConfigOutput) SetOriginRules(v []*OriginRuleForDescribeCdnConfigOutput) *ConditionalOriginForDescribeCdnConfigOutput {
	s.OriginRules = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *ConditionalOriginForDescribeCdnConfigOutput) SetSwitch(v bool) *ConditionalOriginForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type ConvertCacheActionForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Action *string `type:"string" json:",omitempty"`

	CacheKey []*string `type:"list" json:",omitempty"`

	IgnoreCase *bool `type:"boolean" json:",omitempty"`

	Ttl *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s ConvertCacheActionForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertCacheActionForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *ConvertCacheActionForDescribeCdnConfigOutput) SetAction(v string) *ConvertCacheActionForDescribeCdnConfigOutput {
	s.Action = &v
	return s
}

// SetCacheKey sets the CacheKey field's value.
func (s *ConvertCacheActionForDescribeCdnConfigOutput) SetCacheKey(v []*string) *ConvertCacheActionForDescribeCdnConfigOutput {
	s.CacheKey = v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *ConvertCacheActionForDescribeCdnConfigOutput) SetIgnoreCase(v bool) *ConvertCacheActionForDescribeCdnConfigOutput {
	s.IgnoreCase = &v
	return s
}

// SetTtl sets the Ttl field's value.
func (s *ConvertCacheActionForDescribeCdnConfigOutput) SetTtl(v int64) *ConvertCacheActionForDescribeCdnConfigOutput {
	s.Ttl = &v
	return s
}

type ConvertConditionForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Object *string `type:"string" json:",omitempty"`

	Operator *string `type:"string" json:",omitempty"`

	Value []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ConvertConditionForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertConditionForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetObject sets the Object field's value.
func (s *ConvertConditionForDescribeCdnConfigOutput) SetObject(v string) *ConvertConditionForDescribeCdnConfigOutput {
	s.Object = &v
	return s
}

// SetOperator sets the Operator field's value.
func (s *ConvertConditionForDescribeCdnConfigOutput) SetOperator(v string) *ConvertConditionForDescribeCdnConfigOutput {
	s.Operator = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ConvertConditionForDescribeCdnConfigOutput) SetValue(v []*string) *ConvertConditionForDescribeCdnConfigOutput {
	s.Value = v
	return s
}

type ConvertConvertConditionForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ConditionGroups []*ConditionGroupForDescribeCdnConfigOutput `type:"list" json:",omitempty"`

	Connective *string `type:"string" json:",omitempty"`

	IsGroup *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s ConvertConvertConditionForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertConvertConditionForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetConditionGroups sets the ConditionGroups field's value.
func (s *ConvertConvertConditionForDescribeCdnConfigOutput) SetConditionGroups(v []*ConditionGroupForDescribeCdnConfigOutput) *ConvertConvertConditionForDescribeCdnConfigOutput {
	s.ConditionGroups = v
	return s
}

// SetConnective sets the Connective field's value.
func (s *ConvertConvertConditionForDescribeCdnConfigOutput) SetConnective(v string) *ConvertConvertConditionForDescribeCdnConfigOutput {
	s.Connective = &v
	return s
}

// SetIsGroup sets the IsGroup field's value.
func (s *ConvertConvertConditionForDescribeCdnConfigOutput) SetIsGroup(v bool) *ConvertConvertConditionForDescribeCdnConfigOutput {
	s.IsGroup = &v
	return s
}

type ConvertOriginLineForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Address *string `type:"string" json:",omitempty"`

	BucketName *string `type:"string" json:",omitempty"`

	HttpPort *string `type:"string" json:",omitempty"`

	HttpsPort *string `type:"string" json:",omitempty"`

	InstanceType *string `type:"string" json:",omitempty"`

	OriginHost *string `type:"string" json:",omitempty"`

	OriginType *string `type:"string" json:",omitempty"`

	PrivateBucketAccess *bool `type:"boolean" json:",omitempty"`

	PrivateBucketAuth *PrivateBucketAuthForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	Region *string `type:"string" json:",omitempty"`

	Weight *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ConvertOriginLineForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertOriginLineForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *ConvertOriginLineForDescribeCdnConfigOutput) SetAddress(v string) *ConvertOriginLineForDescribeCdnConfigOutput {
	s.Address = &v
	return s
}

// SetBucketName sets the BucketName field's value.
func (s *ConvertOriginLineForDescribeCdnConfigOutput) SetBucketName(v string) *ConvertOriginLineForDescribeCdnConfigOutput {
	s.BucketName = &v
	return s
}

// SetHttpPort sets the HttpPort field's value.
func (s *ConvertOriginLineForDescribeCdnConfigOutput) SetHttpPort(v string) *ConvertOriginLineForDescribeCdnConfigOutput {
	s.HttpPort = &v
	return s
}

// SetHttpsPort sets the HttpsPort field's value.
func (s *ConvertOriginLineForDescribeCdnConfigOutput) SetHttpsPort(v string) *ConvertOriginLineForDescribeCdnConfigOutput {
	s.HttpsPort = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *ConvertOriginLineForDescribeCdnConfigOutput) SetInstanceType(v string) *ConvertOriginLineForDescribeCdnConfigOutput {
	s.InstanceType = &v
	return s
}

// SetOriginHost sets the OriginHost field's value.
func (s *ConvertOriginLineForDescribeCdnConfigOutput) SetOriginHost(v string) *ConvertOriginLineForDescribeCdnConfigOutput {
	s.OriginHost = &v
	return s
}

// SetOriginType sets the OriginType field's value.
func (s *ConvertOriginLineForDescribeCdnConfigOutput) SetOriginType(v string) *ConvertOriginLineForDescribeCdnConfigOutput {
	s.OriginType = &v
	return s
}

// SetPrivateBucketAccess sets the PrivateBucketAccess field's value.
func (s *ConvertOriginLineForDescribeCdnConfigOutput) SetPrivateBucketAccess(v bool) *ConvertOriginLineForDescribeCdnConfigOutput {
	s.PrivateBucketAccess = &v
	return s
}

// SetPrivateBucketAuth sets the PrivateBucketAuth field's value.
func (s *ConvertOriginLineForDescribeCdnConfigOutput) SetPrivateBucketAuth(v *PrivateBucketAuthForDescribeCdnConfigOutput) *ConvertOriginLineForDescribeCdnConfigOutput {
	s.PrivateBucketAuth = v
	return s
}

// SetRegion sets the Region field's value.
func (s *ConvertOriginLineForDescribeCdnConfigOutput) SetRegion(v string) *ConvertOriginLineForDescribeCdnConfigOutput {
	s.Region = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *ConvertOriginLineForDescribeCdnConfigOutput) SetWeight(v string) *ConvertOriginLineForDescribeCdnConfigOutput {
	s.Weight = &v
	return s
}

type ConvertTimeoutActionForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	HttpTimeout *int64 `type:"int64" json:",omitempty"`

	TcpTimeout *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s ConvertTimeoutActionForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertTimeoutActionForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetHttpTimeout sets the HttpTimeout field's value.
func (s *ConvertTimeoutActionForDescribeCdnConfigOutput) SetHttpTimeout(v int64) *ConvertTimeoutActionForDescribeCdnConfigOutput {
	s.HttpTimeout = &v
	return s
}

// SetTcpTimeout sets the TcpTimeout field's value.
func (s *ConvertTimeoutActionForDescribeCdnConfigOutput) SetTcpTimeout(v int64) *ConvertTimeoutActionForDescribeCdnConfigOutput {
	s.TcpTimeout = &v
	return s
}

type CustomErrorPageForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ErrorPageRule []*ErrorPageRuleForDescribeCdnConfigOutput `type:"list" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s CustomErrorPageForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomErrorPageForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetErrorPageRule sets the ErrorPageRule field's value.
func (s *CustomErrorPageForDescribeCdnConfigOutput) SetErrorPageRule(v []*ErrorPageRuleForDescribeCdnConfigOutput) *CustomErrorPageForDescribeCdnConfigOutput {
	s.ErrorPageRule = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *CustomErrorPageForDescribeCdnConfigOutput) SetSwitch(v bool) *CustomErrorPageForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type CustomVariableInstanceForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Operator *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CustomVariableInstanceForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomVariableInstanceForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetOperator sets the Operator field's value.
func (s *CustomVariableInstanceForDescribeCdnConfigOutput) SetOperator(v string) *CustomVariableInstanceForDescribeCdnConfigOutput {
	s.Operator = &v
	return s
}

// SetType sets the Type field's value.
func (s *CustomVariableInstanceForDescribeCdnConfigOutput) SetType(v string) *CustomVariableInstanceForDescribeCdnConfigOutput {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *CustomVariableInstanceForDescribeCdnConfigOutput) SetValue(v string) *CustomVariableInstanceForDescribeCdnConfigOutput {
	s.Value = &v
	return s
}

type CustomVariableRulesForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CustomVariableInstances []*CustomVariableInstanceForDescribeCdnConfigOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s CustomVariableRulesForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomVariableRulesForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCustomVariableInstances sets the CustomVariableInstances field's value.
func (s *CustomVariableRulesForDescribeCdnConfigOutput) SetCustomVariableInstances(v []*CustomVariableInstanceForDescribeCdnConfigOutput) *CustomVariableRulesForDescribeCdnConfigOutput {
	s.CustomVariableInstances = v
	return s
}

type CustomizeAccessRuleForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CustomizeInstances []*CustomizeInstanceForDescribeCdnConfigOutput `type:"list" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s CustomizeAccessRuleForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomizeAccessRuleForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCustomizeInstances sets the CustomizeInstances field's value.
func (s *CustomizeAccessRuleForDescribeCdnConfigOutput) SetCustomizeInstances(v []*CustomizeInstanceForDescribeCdnConfigOutput) *CustomizeAccessRuleForDescribeCdnConfigOutput {
	s.CustomizeInstances = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *CustomizeAccessRuleForDescribeCdnConfigOutput) SetSwitch(v bool) *CustomizeAccessRuleForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type CustomizeInstanceForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CustomizeRule *CustomizeRuleForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CustomizeInstanceForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomizeInstanceForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCustomizeRule sets the CustomizeRule field's value.
func (s *CustomizeInstanceForDescribeCdnConfigOutput) SetCustomizeRule(v *CustomizeRuleForDescribeCdnConfigOutput) *CustomizeInstanceForDescribeCdnConfigOutput {
	s.CustomizeRule = v
	return s
}

type CustomizeRuleForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessAction *AccessActionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	Condition *ConditionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CustomizeRuleForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomizeRuleForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetAccessAction sets the AccessAction field's value.
func (s *CustomizeRuleForDescribeCdnConfigOutput) SetAccessAction(v *AccessActionForDescribeCdnConfigOutput) *CustomizeRuleForDescribeCdnConfigOutput {
	s.AccessAction = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *CustomizeRuleForDescribeCdnConfigOutput) SetCondition(v *ConditionForDescribeCdnConfigOutput) *CustomizeRuleForDescribeCdnConfigOutput {
	s.Condition = v
	return s
}

type DescribeCdnConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// Domain is a required field
	Domain *string `type:"string" json:",omitempty" required:"true"`

	LockInfo *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s DescribeCdnConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCdnConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCdnConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCdnConfigInput"}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomain sets the Domain field's value.
func (s *DescribeCdnConfigInput) SetDomain(v string) *DescribeCdnConfigInput {
	s.Domain = &v
	return s
}

// SetLockInfo sets the LockInfo field's value.
func (s *DescribeCdnConfigInput) SetLockInfo(v bool) *DescribeCdnConfigInput {
	s.LockInfo = &v
	return s
}

type DescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	DomainConfig *DomainConfigForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	FeatureConfig *FeatureConfigForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	ModuleLockConfig *ModuleLockConfigForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s DescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetDomainConfig sets the DomainConfig field's value.
func (s *DescribeCdnConfigOutput) SetDomainConfig(v *DomainConfigForDescribeCdnConfigOutput) *DescribeCdnConfigOutput {
	s.DomainConfig = v
	return s
}

// SetFeatureConfig sets the FeatureConfig field's value.
func (s *DescribeCdnConfigOutput) SetFeatureConfig(v *FeatureConfigForDescribeCdnConfigOutput) *DescribeCdnConfigOutput {
	s.FeatureConfig = v
	return s
}

// SetModuleLockConfig sets the ModuleLockConfig field's value.
func (s *DescribeCdnConfigOutput) SetModuleLockConfig(v *ModuleLockConfigForDescribeCdnConfigOutput) *DescribeCdnConfigOutput {
	s.ModuleLockConfig = v
	return s
}

type DomainConfigForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AreaAccessRule *AreaAccessRuleForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	BackupCname *string `type:"string" json:",omitempty"`

	BandwidthLimit *BandwidthLimitForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	BrowserCache []*BrowserCacheForDescribeCdnConfigOutput `type:"list" json:",omitempty"`

	Cache []*CacheForDescribeCdnConfigOutput `type:"list" json:",omitempty"`

	CacheHost *CacheHostForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	CacheKey []*CacheKeyForDescribeCdnConfigOutput `type:"list" json:",omitempty"`

	Cname *string `type:"string" json:",omitempty"`

	Compression *CompressionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	ConditionalOrigin *ConditionalOriginForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	CreateTime *int64 `type:"int64" json:",omitempty"`

	CustomErrorPage *CustomErrorPageForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	CustomizeAccessRule *CustomizeAccessRuleForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	Domain *string `type:"string" json:",omitempty"`

	DownloadSpeedLimit *DownloadSpeedLimitForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	FollowRedirect *bool `type:"boolean" json:",omitempty"`

	HTTPS *HTTPSForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	HttpForcedRedirect *HttpForcedRedirectForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	IPv6 *IPv6ForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	IpAccessRule *IpAccessRuleForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	IpFreqLimit *IpFreqLimitForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	IpSpeedLimit *IpSpeedLimitForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	LockStatus *string `type:"string" json:",omitempty"`

	MethodDeniedRule *MethodDeniedRuleForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	MultiRange *MultiRangeForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	NegativeCache []*NegativeCacheForDescribeCdnConfigOutput `type:"list" json:",omitempty"`

	OfflineCache *OfflineCacheForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	Origin []*OriginForDescribeCdnConfigOutput `type:"list" json:",omitempty"`

	OriginAccessRule *OriginAccessRuleForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	OriginArg []*OriginArgForDescribeCdnConfigOutput `type:"list" json:",omitempty"`

	OriginCertCheck *OriginCertCheckForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	OriginHost *string `type:"string" json:",omitempty"`

	OriginIPv6 *string `type:"string" json:",omitempty"`

	OriginProtocol *string `type:"string" json:",omitempty"`

	OriginRange *bool `type:"boolean" json:",omitempty"`

	OriginRetry *OriginRetryForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	OriginRewrite *OriginRewriteForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	OriginSni *OriginSniForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	PageOptimization *PageOptimizationForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	Project *string `type:"string" json:",omitempty"`

	Quic *QuicForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	RedirectionRewrite *RedirectionRewriteForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	RefererAccessRule *RefererAccessRuleForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	RemoteAuth *RemoteAuthForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	RequestBlockRule *RequestBlockRuleForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	RequestHeader []*RequestHeaderForDescribeCdnConfigOutput `type:"list" json:",omitempty"`

	ResponseHeader []*ResponseHeaderForDescribeCdnConfigOutput `type:"list" json:",omitempty"`

	RewriteHLS *RewriteHLSForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	ServiceRegion *string `type:"string" json:",omitempty"`

	ServiceType *string `type:"string" json:",omitempty"`

	SignedUrlAuth *SignedUrlAuthForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	Status *string `type:"string" json:",omitempty"`

	Timeout *TimeoutForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	UaAccessRule *UaAccessRuleForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	UpdateTime *int64 `type:"int64" json:",omitempty"`

	UrlNormalize *UrlNormalizeForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	VideoDrag *VideoDragForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s DomainConfigForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainConfigForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetAreaAccessRule sets the AreaAccessRule field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetAreaAccessRule(v *AreaAccessRuleForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.AreaAccessRule = v
	return s
}

// SetBackupCname sets the BackupCname field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetBackupCname(v string) *DomainConfigForDescribeCdnConfigOutput {
	s.BackupCname = &v
	return s
}

// SetBandwidthLimit sets the BandwidthLimit field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetBandwidthLimit(v *BandwidthLimitForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.BandwidthLimit = v
	return s
}

// SetBrowserCache sets the BrowserCache field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetBrowserCache(v []*BrowserCacheForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.BrowserCache = v
	return s
}

// SetCache sets the Cache field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetCache(v []*CacheForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.Cache = v
	return s
}

// SetCacheHost sets the CacheHost field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetCacheHost(v *CacheHostForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.CacheHost = v
	return s
}

// SetCacheKey sets the CacheKey field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetCacheKey(v []*CacheKeyForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.CacheKey = v
	return s
}

// SetCname sets the Cname field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetCname(v string) *DomainConfigForDescribeCdnConfigOutput {
	s.Cname = &v
	return s
}

// SetCompression sets the Compression field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetCompression(v *CompressionForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.Compression = v
	return s
}

// SetConditionalOrigin sets the ConditionalOrigin field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetConditionalOrigin(v *ConditionalOriginForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.ConditionalOrigin = v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetCreateTime(v int64) *DomainConfigForDescribeCdnConfigOutput {
	s.CreateTime = &v
	return s
}

// SetCustomErrorPage sets the CustomErrorPage field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetCustomErrorPage(v *CustomErrorPageForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.CustomErrorPage = v
	return s
}

// SetCustomizeAccessRule sets the CustomizeAccessRule field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetCustomizeAccessRule(v *CustomizeAccessRuleForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.CustomizeAccessRule = v
	return s
}

// SetDomain sets the Domain field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetDomain(v string) *DomainConfigForDescribeCdnConfigOutput {
	s.Domain = &v
	return s
}

// SetDownloadSpeedLimit sets the DownloadSpeedLimit field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetDownloadSpeedLimit(v *DownloadSpeedLimitForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.DownloadSpeedLimit = v
	return s
}

// SetFollowRedirect sets the FollowRedirect field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetFollowRedirect(v bool) *DomainConfigForDescribeCdnConfigOutput {
	s.FollowRedirect = &v
	return s
}

// SetHTTPS sets the HTTPS field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetHTTPS(v *HTTPSForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.HTTPS = v
	return s
}

// SetHttpForcedRedirect sets the HttpForcedRedirect field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetHttpForcedRedirect(v *HttpForcedRedirectForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.HttpForcedRedirect = v
	return s
}

// SetIPv6 sets the IPv6 field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetIPv6(v *IPv6ForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.IPv6 = v
	return s
}

// SetIpAccessRule sets the IpAccessRule field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetIpAccessRule(v *IpAccessRuleForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.IpAccessRule = v
	return s
}

// SetIpFreqLimit sets the IpFreqLimit field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetIpFreqLimit(v *IpFreqLimitForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.IpFreqLimit = v
	return s
}

// SetIpSpeedLimit sets the IpSpeedLimit field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetIpSpeedLimit(v *IpSpeedLimitForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.IpSpeedLimit = v
	return s
}

// SetLockStatus sets the LockStatus field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetLockStatus(v string) *DomainConfigForDescribeCdnConfigOutput {
	s.LockStatus = &v
	return s
}

// SetMethodDeniedRule sets the MethodDeniedRule field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetMethodDeniedRule(v *MethodDeniedRuleForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.MethodDeniedRule = v
	return s
}

// SetMultiRange sets the MultiRange field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetMultiRange(v *MultiRangeForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.MultiRange = v
	return s
}

// SetNegativeCache sets the NegativeCache field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetNegativeCache(v []*NegativeCacheForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.NegativeCache = v
	return s
}

// SetOfflineCache sets the OfflineCache field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetOfflineCache(v *OfflineCacheForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.OfflineCache = v
	return s
}

// SetOrigin sets the Origin field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetOrigin(v []*OriginForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.Origin = v
	return s
}

// SetOriginAccessRule sets the OriginAccessRule field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetOriginAccessRule(v *OriginAccessRuleForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.OriginAccessRule = v
	return s
}

// SetOriginArg sets the OriginArg field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetOriginArg(v []*OriginArgForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.OriginArg = v
	return s
}

// SetOriginCertCheck sets the OriginCertCheck field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetOriginCertCheck(v *OriginCertCheckForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.OriginCertCheck = v
	return s
}

// SetOriginHost sets the OriginHost field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetOriginHost(v string) *DomainConfigForDescribeCdnConfigOutput {
	s.OriginHost = &v
	return s
}

// SetOriginIPv6 sets the OriginIPv6 field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetOriginIPv6(v string) *DomainConfigForDescribeCdnConfigOutput {
	s.OriginIPv6 = &v
	return s
}

// SetOriginProtocol sets the OriginProtocol field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetOriginProtocol(v string) *DomainConfigForDescribeCdnConfigOutput {
	s.OriginProtocol = &v
	return s
}

// SetOriginRange sets the OriginRange field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetOriginRange(v bool) *DomainConfigForDescribeCdnConfigOutput {
	s.OriginRange = &v
	return s
}

// SetOriginRetry sets the OriginRetry field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetOriginRetry(v *OriginRetryForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.OriginRetry = v
	return s
}

// SetOriginRewrite sets the OriginRewrite field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetOriginRewrite(v *OriginRewriteForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.OriginRewrite = v
	return s
}

// SetOriginSni sets the OriginSni field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetOriginSni(v *OriginSniForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.OriginSni = v
	return s
}

// SetPageOptimization sets the PageOptimization field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetPageOptimization(v *PageOptimizationForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.PageOptimization = v
	return s
}

// SetProject sets the Project field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetProject(v string) *DomainConfigForDescribeCdnConfigOutput {
	s.Project = &v
	return s
}

// SetQuic sets the Quic field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetQuic(v *QuicForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.Quic = v
	return s
}

// SetRedirectionRewrite sets the RedirectionRewrite field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetRedirectionRewrite(v *RedirectionRewriteForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.RedirectionRewrite = v
	return s
}

// SetRefererAccessRule sets the RefererAccessRule field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetRefererAccessRule(v *RefererAccessRuleForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.RefererAccessRule = v
	return s
}

// SetRemoteAuth sets the RemoteAuth field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetRemoteAuth(v *RemoteAuthForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.RemoteAuth = v
	return s
}

// SetRequestBlockRule sets the RequestBlockRule field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetRequestBlockRule(v *RequestBlockRuleForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.RequestBlockRule = v
	return s
}

// SetRequestHeader sets the RequestHeader field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetRequestHeader(v []*RequestHeaderForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.RequestHeader = v
	return s
}

// SetResponseHeader sets the ResponseHeader field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetResponseHeader(v []*ResponseHeaderForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.ResponseHeader = v
	return s
}

// SetRewriteHLS sets the RewriteHLS field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetRewriteHLS(v *RewriteHLSForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.RewriteHLS = v
	return s
}

// SetServiceRegion sets the ServiceRegion field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetServiceRegion(v string) *DomainConfigForDescribeCdnConfigOutput {
	s.ServiceRegion = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetServiceType(v string) *DomainConfigForDescribeCdnConfigOutput {
	s.ServiceType = &v
	return s
}

// SetSignedUrlAuth sets the SignedUrlAuth field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetSignedUrlAuth(v *SignedUrlAuthForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.SignedUrlAuth = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetStatus(v string) *DomainConfigForDescribeCdnConfigOutput {
	s.Status = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetTimeout(v *TimeoutForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.Timeout = v
	return s
}

// SetUaAccessRule sets the UaAccessRule field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetUaAccessRule(v *UaAccessRuleForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.UaAccessRule = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetUpdateTime(v int64) *DomainConfigForDescribeCdnConfigOutput {
	s.UpdateTime = &v
	return s
}

// SetUrlNormalize sets the UrlNormalize field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetUrlNormalize(v *UrlNormalizeForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.UrlNormalize = v
	return s
}

// SetVideoDrag sets the VideoDrag field's value.
func (s *DomainConfigForDescribeCdnConfigOutput) SetVideoDrag(v *VideoDragForDescribeCdnConfigOutput) *DomainConfigForDescribeCdnConfigOutput {
	s.VideoDrag = v
	return s
}

type DownloadSpeedLimitActionForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SpeedLimitRate *int64 `type:"int64" json:",omitempty"`

	SpeedLimitRateAfter *int64 `type:"int64" json:",omitempty"`

	SpeedLimitTime *SpeedLimitTimeForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s DownloadSpeedLimitActionForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DownloadSpeedLimitActionForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetSpeedLimitRate sets the SpeedLimitRate field's value.
func (s *DownloadSpeedLimitActionForDescribeCdnConfigOutput) SetSpeedLimitRate(v int64) *DownloadSpeedLimitActionForDescribeCdnConfigOutput {
	s.SpeedLimitRate = &v
	return s
}

// SetSpeedLimitRateAfter sets the SpeedLimitRateAfter field's value.
func (s *DownloadSpeedLimitActionForDescribeCdnConfigOutput) SetSpeedLimitRateAfter(v int64) *DownloadSpeedLimitActionForDescribeCdnConfigOutput {
	s.SpeedLimitRateAfter = &v
	return s
}

// SetSpeedLimitTime sets the SpeedLimitTime field's value.
func (s *DownloadSpeedLimitActionForDescribeCdnConfigOutput) SetSpeedLimitTime(v *SpeedLimitTimeForDescribeCdnConfigOutput) *DownloadSpeedLimitActionForDescribeCdnConfigOutput {
	s.SpeedLimitTime = v
	return s
}

type DownloadSpeedLimitForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DownloadSpeedLimitRules []*DownloadSpeedLimitRuleForDescribeCdnConfigOutput `type:"list" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s DownloadSpeedLimitForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DownloadSpeedLimitForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetDownloadSpeedLimitRules sets the DownloadSpeedLimitRules field's value.
func (s *DownloadSpeedLimitForDescribeCdnConfigOutput) SetDownloadSpeedLimitRules(v []*DownloadSpeedLimitRuleForDescribeCdnConfigOutput) *DownloadSpeedLimitForDescribeCdnConfigOutput {
	s.DownloadSpeedLimitRules = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *DownloadSpeedLimitForDescribeCdnConfigOutput) SetSwitch(v bool) *DownloadSpeedLimitForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type DownloadSpeedLimitRuleForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Condition *ConditionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	DownloadSpeedLimitAction *DownloadSpeedLimitActionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s DownloadSpeedLimitRuleForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DownloadSpeedLimitRuleForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *DownloadSpeedLimitRuleForDescribeCdnConfigOutput) SetCondition(v *ConditionForDescribeCdnConfigOutput) *DownloadSpeedLimitRuleForDescribeCdnConfigOutput {
	s.Condition = v
	return s
}

// SetDownloadSpeedLimitAction sets the DownloadSpeedLimitAction field's value.
func (s *DownloadSpeedLimitRuleForDescribeCdnConfigOutput) SetDownloadSpeedLimitAction(v *DownloadSpeedLimitActionForDescribeCdnConfigOutput) *DownloadSpeedLimitRuleForDescribeCdnConfigOutput {
	s.DownloadSpeedLimitAction = v
	return s
}

type ErrorPageActionForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Action *string `type:"string" json:",omitempty"`

	RedirectCode *string `type:"string" json:",omitempty"`

	RedirectUrl *string `type:"string" json:",omitempty"`

	StatusCode *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ErrorPageActionForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorPageActionForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *ErrorPageActionForDescribeCdnConfigOutput) SetAction(v string) *ErrorPageActionForDescribeCdnConfigOutput {
	s.Action = &v
	return s
}

// SetRedirectCode sets the RedirectCode field's value.
func (s *ErrorPageActionForDescribeCdnConfigOutput) SetRedirectCode(v string) *ErrorPageActionForDescribeCdnConfigOutput {
	s.RedirectCode = &v
	return s
}

// SetRedirectUrl sets the RedirectUrl field's value.
func (s *ErrorPageActionForDescribeCdnConfigOutput) SetRedirectUrl(v string) *ErrorPageActionForDescribeCdnConfigOutput {
	s.RedirectUrl = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *ErrorPageActionForDescribeCdnConfigOutput) SetStatusCode(v string) *ErrorPageActionForDescribeCdnConfigOutput {
	s.StatusCode = &v
	return s
}

type ErrorPageRuleForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ErrorPageAction *ErrorPageActionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ErrorPageRuleForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorPageRuleForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetErrorPageAction sets the ErrorPageAction field's value.
func (s *ErrorPageRuleForDescribeCdnConfigOutput) SetErrorPageAction(v *ErrorPageActionForDescribeCdnConfigOutput) *ErrorPageRuleForDescribeCdnConfigOutput {
	s.ErrorPageAction = v
	return s
}

type ExpTimeCapRuleForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CapMode *string `type:"string" json:",omitempty"`

	ParamName *string `type:"string" json:",omitempty"`

	UriLevel *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s ExpTimeCapRuleForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ExpTimeCapRuleForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCapMode sets the CapMode field's value.
func (s *ExpTimeCapRuleForDescribeCdnConfigOutput) SetCapMode(v string) *ExpTimeCapRuleForDescribeCdnConfigOutput {
	s.CapMode = &v
	return s
}

// SetParamName sets the ParamName field's value.
func (s *ExpTimeCapRuleForDescribeCdnConfigOutput) SetParamName(v string) *ExpTimeCapRuleForDescribeCdnConfigOutput {
	s.ParamName = &v
	return s
}

// SetUriLevel sets the UriLevel field's value.
func (s *ExpTimeCapRuleForDescribeCdnConfigOutput) SetUriLevel(v int64) *ExpTimeCapRuleForDescribeCdnConfigOutput {
	s.UriLevel = &v
	return s
}

type FeatureConfigForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	OriginV2 *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s FeatureConfigForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FeatureConfigForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetOriginV2 sets the OriginV2 field's value.
func (s *FeatureConfigForDescribeCdnConfigOutput) SetOriginV2(v bool) *FeatureConfigForDescribeCdnConfigOutput {
	s.OriginV2 = &v
	return s
}

type ForcedRedirectForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	EnableForcedRedirect *bool `type:"boolean" json:",omitempty"`

	StatusCode *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ForcedRedirectForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ForcedRedirectForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetEnableForcedRedirect sets the EnableForcedRedirect field's value.
func (s *ForcedRedirectForDescribeCdnConfigOutput) SetEnableForcedRedirect(v bool) *ForcedRedirectForDescribeCdnConfigOutput {
	s.EnableForcedRedirect = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *ForcedRedirectForDescribeCdnConfigOutput) SetStatusCode(v string) *ForcedRedirectForDescribeCdnConfigOutput {
	s.StatusCode = &v
	return s
}

type HTTPSForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CertCheck *CertCheckForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	CertInfo *CertInfoForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	CertInfoList []*CertInfoListForDescribeCdnConfigOutput `type:"list" json:",omitempty"`

	DisableHttp *bool `type:"boolean" json:",omitempty"`

	ForcedRedirect *ForcedRedirectForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	HTTP2 *bool `type:"boolean" json:",omitempty"`

	Hsts *HstsForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	OCSP *bool `type:"boolean" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`

	TlsVersion []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s HTTPSForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HTTPSForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCertCheck sets the CertCheck field's value.
func (s *HTTPSForDescribeCdnConfigOutput) SetCertCheck(v *CertCheckForDescribeCdnConfigOutput) *HTTPSForDescribeCdnConfigOutput {
	s.CertCheck = v
	return s
}

// SetCertInfo sets the CertInfo field's value.
func (s *HTTPSForDescribeCdnConfigOutput) SetCertInfo(v *CertInfoForDescribeCdnConfigOutput) *HTTPSForDescribeCdnConfigOutput {
	s.CertInfo = v
	return s
}

// SetCertInfoList sets the CertInfoList field's value.
func (s *HTTPSForDescribeCdnConfigOutput) SetCertInfoList(v []*CertInfoListForDescribeCdnConfigOutput) *HTTPSForDescribeCdnConfigOutput {
	s.CertInfoList = v
	return s
}

// SetDisableHttp sets the DisableHttp field's value.
func (s *HTTPSForDescribeCdnConfigOutput) SetDisableHttp(v bool) *HTTPSForDescribeCdnConfigOutput {
	s.DisableHttp = &v
	return s
}

// SetForcedRedirect sets the ForcedRedirect field's value.
func (s *HTTPSForDescribeCdnConfigOutput) SetForcedRedirect(v *ForcedRedirectForDescribeCdnConfigOutput) *HTTPSForDescribeCdnConfigOutput {
	s.ForcedRedirect = v
	return s
}

// SetHTTP2 sets the HTTP2 field's value.
func (s *HTTPSForDescribeCdnConfigOutput) SetHTTP2(v bool) *HTTPSForDescribeCdnConfigOutput {
	s.HTTP2 = &v
	return s
}

// SetHsts sets the Hsts field's value.
func (s *HTTPSForDescribeCdnConfigOutput) SetHsts(v *HstsForDescribeCdnConfigOutput) *HTTPSForDescribeCdnConfigOutput {
	s.Hsts = v
	return s
}

// SetOCSP sets the OCSP field's value.
func (s *HTTPSForDescribeCdnConfigOutput) SetOCSP(v bool) *HTTPSForDescribeCdnConfigOutput {
	s.OCSP = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *HTTPSForDescribeCdnConfigOutput) SetSwitch(v bool) *HTTPSForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

// SetTlsVersion sets the TlsVersion field's value.
func (s *HTTPSForDescribeCdnConfigOutput) SetTlsVersion(v []*string) *HTTPSForDescribeCdnConfigOutput {
	s.TlsVersion = v
	return s
}

type HstsForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Subdomain *string `type:"string" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`

	Ttl *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s HstsForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HstsForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetSubdomain sets the Subdomain field's value.
func (s *HstsForDescribeCdnConfigOutput) SetSubdomain(v string) *HstsForDescribeCdnConfigOutput {
	s.Subdomain = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *HstsForDescribeCdnConfigOutput) SetSwitch(v bool) *HstsForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

// SetTtl sets the Ttl field's value.
func (s *HstsForDescribeCdnConfigOutput) SetTtl(v int64) *HstsForDescribeCdnConfigOutput {
	s.Ttl = &v
	return s
}

type HttpForcedRedirectForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	EnableForcedRedirect *bool `type:"boolean" json:",omitempty"`

	StatusCode *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s HttpForcedRedirectForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HttpForcedRedirectForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetEnableForcedRedirect sets the EnableForcedRedirect field's value.
func (s *HttpForcedRedirectForDescribeCdnConfigOutput) SetEnableForcedRedirect(v bool) *HttpForcedRedirectForDescribeCdnConfigOutput {
	s.EnableForcedRedirect = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *HttpForcedRedirectForDescribeCdnConfigOutput) SetStatusCode(v string) *HttpForcedRedirectForDescribeCdnConfigOutput {
	s.StatusCode = &v
	return s
}

type IPv6ForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s IPv6ForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IPv6ForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetSwitch sets the Switch field's value.
func (s *IPv6ForDescribeCdnConfigOutput) SetSwitch(v bool) *IPv6ForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type IpAccessRuleForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Ip []*string `type:"list" json:",omitempty"`

	RuleType *string `type:"string" json:",omitempty"`

	SharedConfig *SharedConfigForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s IpAccessRuleForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IpAccessRuleForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetIp sets the Ip field's value.
func (s *IpAccessRuleForDescribeCdnConfigOutput) SetIp(v []*string) *IpAccessRuleForDescribeCdnConfigOutput {
	s.Ip = v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *IpAccessRuleForDescribeCdnConfigOutput) SetRuleType(v string) *IpAccessRuleForDescribeCdnConfigOutput {
	s.RuleType = &v
	return s
}

// SetSharedConfig sets the SharedConfig field's value.
func (s *IpAccessRuleForDescribeCdnConfigOutput) SetSharedConfig(v *SharedConfigForDescribeCdnConfigOutput) *IpAccessRuleForDescribeCdnConfigOutput {
	s.SharedConfig = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *IpAccessRuleForDescribeCdnConfigOutput) SetSwitch(v bool) *IpAccessRuleForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type IpFreqLimitActionForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Action *string `type:"string" json:",omitempty"`

	FreqLimitRate *int64 `type:"int64" json:",omitempty"`

	StatusCode *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s IpFreqLimitActionForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IpFreqLimitActionForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *IpFreqLimitActionForDescribeCdnConfigOutput) SetAction(v string) *IpFreqLimitActionForDescribeCdnConfigOutput {
	s.Action = &v
	return s
}

// SetFreqLimitRate sets the FreqLimitRate field's value.
func (s *IpFreqLimitActionForDescribeCdnConfigOutput) SetFreqLimitRate(v int64) *IpFreqLimitActionForDescribeCdnConfigOutput {
	s.FreqLimitRate = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *IpFreqLimitActionForDescribeCdnConfigOutput) SetStatusCode(v string) *IpFreqLimitActionForDescribeCdnConfigOutput {
	s.StatusCode = &v
	return s
}

type IpFreqLimitForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	IpFreqLimitRules []*IpFreqLimitRuleForDescribeCdnConfigOutput `type:"list" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s IpFreqLimitForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IpFreqLimitForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetIpFreqLimitRules sets the IpFreqLimitRules field's value.
func (s *IpFreqLimitForDescribeCdnConfigOutput) SetIpFreqLimitRules(v []*IpFreqLimitRuleForDescribeCdnConfigOutput) *IpFreqLimitForDescribeCdnConfigOutput {
	s.IpFreqLimitRules = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *IpFreqLimitForDescribeCdnConfigOutput) SetSwitch(v bool) *IpFreqLimitForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type IpFreqLimitRuleForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Condition *ConditionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	IpFreqLimitAction *IpFreqLimitActionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s IpFreqLimitRuleForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IpFreqLimitRuleForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *IpFreqLimitRuleForDescribeCdnConfigOutput) SetCondition(v *ConditionForDescribeCdnConfigOutput) *IpFreqLimitRuleForDescribeCdnConfigOutput {
	s.Condition = v
	return s
}

// SetIpFreqLimitAction sets the IpFreqLimitAction field's value.
func (s *IpFreqLimitRuleForDescribeCdnConfigOutput) SetIpFreqLimitAction(v *IpFreqLimitActionForDescribeCdnConfigOutput) *IpFreqLimitRuleForDescribeCdnConfigOutput {
	s.IpFreqLimitAction = v
	return s
}

type IpSpeedLimitActionForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SpeedLimitRate *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s IpSpeedLimitActionForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IpSpeedLimitActionForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetSpeedLimitRate sets the SpeedLimitRate field's value.
func (s *IpSpeedLimitActionForDescribeCdnConfigOutput) SetSpeedLimitRate(v int64) *IpSpeedLimitActionForDescribeCdnConfigOutput {
	s.SpeedLimitRate = &v
	return s
}

type IpSpeedLimitForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	IpSpeedLimitRules []*IpSpeedLimitRuleForDescribeCdnConfigOutput `type:"list" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s IpSpeedLimitForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IpSpeedLimitForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetIpSpeedLimitRules sets the IpSpeedLimitRules field's value.
func (s *IpSpeedLimitForDescribeCdnConfigOutput) SetIpSpeedLimitRules(v []*IpSpeedLimitRuleForDescribeCdnConfigOutput) *IpSpeedLimitForDescribeCdnConfigOutput {
	s.IpSpeedLimitRules = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *IpSpeedLimitForDescribeCdnConfigOutput) SetSwitch(v bool) *IpSpeedLimitForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type IpSpeedLimitRuleForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Condition *ConditionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	IpSpeedLimitAction *IpSpeedLimitActionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s IpSpeedLimitRuleForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IpSpeedLimitRuleForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *IpSpeedLimitRuleForDescribeCdnConfigOutput) SetCondition(v *ConditionForDescribeCdnConfigOutput) *IpSpeedLimitRuleForDescribeCdnConfigOutput {
	s.Condition = v
	return s
}

// SetIpSpeedLimitAction sets the IpSpeedLimitAction field's value.
func (s *IpSpeedLimitRuleForDescribeCdnConfigOutput) SetIpSpeedLimitAction(v *IpSpeedLimitActionForDescribeCdnConfigOutput) *IpSpeedLimitRuleForDescribeCdnConfigOutput {
	s.IpSpeedLimitAction = v
	return s
}

type MethodDeniedRuleForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Methods *string `type:"string" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s MethodDeniedRuleForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MethodDeniedRuleForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetMethods sets the Methods field's value.
func (s *MethodDeniedRuleForDescribeCdnConfigOutput) SetMethods(v string) *MethodDeniedRuleForDescribeCdnConfigOutput {
	s.Methods = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *MethodDeniedRuleForDescribeCdnConfigOutput) SetSwitch(v bool) *MethodDeniedRuleForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type ModuleLockConfigForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BrowserCacheLocked *bool `type:"boolean" json:",omitempty"`

	CacheKeyLocked *bool `type:"boolean" json:",omitempty"`

	CacheLocked *bool `type:"boolean" json:",omitempty"`

	CompressionLocked *bool `type:"boolean" json:",omitempty"`

	CustomizeAccessRuleLocked *bool `type:"boolean" json:",omitempty"`

	DownloadSpeedLimitLocked *bool `type:"boolean" json:",omitempty"`

	ErrorPageLocked *bool `type:"boolean" json:",omitempty"`

	IpAccessRuleLocked *bool `type:"boolean" json:",omitempty"`

	NegativeCacheLocked *bool `type:"boolean" json:",omitempty"`

	OriginAccessRuleLocked *bool `type:"boolean" json:",omitempty"`

	OriginArgLocked *bool `type:"boolean" json:",omitempty"`

	OriginLocked *bool `type:"boolean" json:",omitempty"`

	OriginResponseHeaderLocked *bool `type:"boolean" json:",omitempty"`

	OriginRewriteLocked *bool `type:"boolean" json:",omitempty"`

	QuicLocked *bool `type:"boolean" json:",omitempty"`

	RedirectionRewriteLocked *bool `type:"boolean" json:",omitempty"`

	RefererAccessRuleLocked *bool `type:"boolean" json:",omitempty"`

	RemoteAuthLocked *bool `type:"boolean" json:",omitempty"`

	RequestBlockRuleLocked *bool `type:"boolean" json:",omitempty"`

	RequestHeaderLocked *bool `type:"boolean" json:",omitempty"`

	ResponseHeaderLocked *bool `type:"boolean" json:",omitempty"`

	RuleEngineLocked *bool `type:"boolean" json:",omitempty"`

	ShareCacheLocked *bool `type:"boolean" json:",omitempty"`

	SignUrlAuthLocked *bool `type:"boolean" json:",omitempty"`

	UAAccessRuleLocked *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s ModuleLockConfigForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModuleLockConfigForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetBrowserCacheLocked sets the BrowserCacheLocked field's value.
func (s *ModuleLockConfigForDescribeCdnConfigOutput) SetBrowserCacheLocked(v bool) *ModuleLockConfigForDescribeCdnConfigOutput {
	s.BrowserCacheLocked = &v
	return s
}

// SetCacheKeyLocked sets the CacheKeyLocked field's value.
func (s *ModuleLockConfigForDescribeCdnConfigOutput) SetCacheKeyLocked(v bool) *ModuleLockConfigForDescribeCdnConfigOutput {
	s.CacheKeyLocked = &v
	return s
}

// SetCacheLocked sets the CacheLocked field's value.
func (s *ModuleLockConfigForDescribeCdnConfigOutput) SetCacheLocked(v bool) *ModuleLockConfigForDescribeCdnConfigOutput {
	s.CacheLocked = &v
	return s
}

// SetCompressionLocked sets the CompressionLocked field's value.
func (s *ModuleLockConfigForDescribeCdnConfigOutput) SetCompressionLocked(v bool) *ModuleLockConfigForDescribeCdnConfigOutput {
	s.CompressionLocked = &v
	return s
}

// SetCustomizeAccessRuleLocked sets the CustomizeAccessRuleLocked field's value.
func (s *ModuleLockConfigForDescribeCdnConfigOutput) SetCustomizeAccessRuleLocked(v bool) *ModuleLockConfigForDescribeCdnConfigOutput {
	s.CustomizeAccessRuleLocked = &v
	return s
}

// SetDownloadSpeedLimitLocked sets the DownloadSpeedLimitLocked field's value.
func (s *ModuleLockConfigForDescribeCdnConfigOutput) SetDownloadSpeedLimitLocked(v bool) *ModuleLockConfigForDescribeCdnConfigOutput {
	s.DownloadSpeedLimitLocked = &v
	return s
}

// SetErrorPageLocked sets the ErrorPageLocked field's value.
func (s *ModuleLockConfigForDescribeCdnConfigOutput) SetErrorPageLocked(v bool) *ModuleLockConfigForDescribeCdnConfigOutput {
	s.ErrorPageLocked = &v
	return s
}

// SetIpAccessRuleLocked sets the IpAccessRuleLocked field's value.
func (s *ModuleLockConfigForDescribeCdnConfigOutput) SetIpAccessRuleLocked(v bool) *ModuleLockConfigForDescribeCdnConfigOutput {
	s.IpAccessRuleLocked = &v
	return s
}

// SetNegativeCacheLocked sets the NegativeCacheLocked field's value.
func (s *ModuleLockConfigForDescribeCdnConfigOutput) SetNegativeCacheLocked(v bool) *ModuleLockConfigForDescribeCdnConfigOutput {
	s.NegativeCacheLocked = &v
	return s
}

// SetOriginAccessRuleLocked sets the OriginAccessRuleLocked field's value.
func (s *ModuleLockConfigForDescribeCdnConfigOutput) SetOriginAccessRuleLocked(v bool) *ModuleLockConfigForDescribeCdnConfigOutput {
	s.OriginAccessRuleLocked = &v
	return s
}

// SetOriginArgLocked sets the OriginArgLocked field's value.
func (s *ModuleLockConfigForDescribeCdnConfigOutput) SetOriginArgLocked(v bool) *ModuleLockConfigForDescribeCdnConfigOutput {
	s.OriginArgLocked = &v
	return s
}

// SetOriginLocked sets the OriginLocked field's value.
func (s *ModuleLockConfigForDescribeCdnConfigOutput) SetOriginLocked(v bool) *ModuleLockConfigForDescribeCdnConfigOutput {
	s.OriginLocked = &v
	return s
}

// SetOriginResponseHeaderLocked sets the OriginResponseHeaderLocked field's value.
func (s *ModuleLockConfigForDescribeCdnConfigOutput) SetOriginResponseHeaderLocked(v bool) *ModuleLockConfigForDescribeCdnConfigOutput {
	s.OriginResponseHeaderLocked = &v
	return s
}

// SetOriginRewriteLocked sets the OriginRewriteLocked field's value.
func (s *ModuleLockConfigForDescribeCdnConfigOutput) SetOriginRewriteLocked(v bool) *ModuleLockConfigForDescribeCdnConfigOutput {
	s.OriginRewriteLocked = &v
	return s
}

// SetQuicLocked sets the QuicLocked field's value.
func (s *ModuleLockConfigForDescribeCdnConfigOutput) SetQuicLocked(v bool) *ModuleLockConfigForDescribeCdnConfigOutput {
	s.QuicLocked = &v
	return s
}

// SetRedirectionRewriteLocked sets the RedirectionRewriteLocked field's value.
func (s *ModuleLockConfigForDescribeCdnConfigOutput) SetRedirectionRewriteLocked(v bool) *ModuleLockConfigForDescribeCdnConfigOutput {
	s.RedirectionRewriteLocked = &v
	return s
}

// SetRefererAccessRuleLocked sets the RefererAccessRuleLocked field's value.
func (s *ModuleLockConfigForDescribeCdnConfigOutput) SetRefererAccessRuleLocked(v bool) *ModuleLockConfigForDescribeCdnConfigOutput {
	s.RefererAccessRuleLocked = &v
	return s
}

// SetRemoteAuthLocked sets the RemoteAuthLocked field's value.
func (s *ModuleLockConfigForDescribeCdnConfigOutput) SetRemoteAuthLocked(v bool) *ModuleLockConfigForDescribeCdnConfigOutput {
	s.RemoteAuthLocked = &v
	return s
}

// SetRequestBlockRuleLocked sets the RequestBlockRuleLocked field's value.
func (s *ModuleLockConfigForDescribeCdnConfigOutput) SetRequestBlockRuleLocked(v bool) *ModuleLockConfigForDescribeCdnConfigOutput {
	s.RequestBlockRuleLocked = &v
	return s
}

// SetRequestHeaderLocked sets the RequestHeaderLocked field's value.
func (s *ModuleLockConfigForDescribeCdnConfigOutput) SetRequestHeaderLocked(v bool) *ModuleLockConfigForDescribeCdnConfigOutput {
	s.RequestHeaderLocked = &v
	return s
}

// SetResponseHeaderLocked sets the ResponseHeaderLocked field's value.
func (s *ModuleLockConfigForDescribeCdnConfigOutput) SetResponseHeaderLocked(v bool) *ModuleLockConfigForDescribeCdnConfigOutput {
	s.ResponseHeaderLocked = &v
	return s
}

// SetRuleEngineLocked sets the RuleEngineLocked field's value.
func (s *ModuleLockConfigForDescribeCdnConfigOutput) SetRuleEngineLocked(v bool) *ModuleLockConfigForDescribeCdnConfigOutput {
	s.RuleEngineLocked = &v
	return s
}

// SetShareCacheLocked sets the ShareCacheLocked field's value.
func (s *ModuleLockConfigForDescribeCdnConfigOutput) SetShareCacheLocked(v bool) *ModuleLockConfigForDescribeCdnConfigOutput {
	s.ShareCacheLocked = &v
	return s
}

// SetSignUrlAuthLocked sets the SignUrlAuthLocked field's value.
func (s *ModuleLockConfigForDescribeCdnConfigOutput) SetSignUrlAuthLocked(v bool) *ModuleLockConfigForDescribeCdnConfigOutput {
	s.SignUrlAuthLocked = &v
	return s
}

// SetUAAccessRuleLocked sets the UAAccessRuleLocked field's value.
func (s *ModuleLockConfigForDescribeCdnConfigOutput) SetUAAccessRuleLocked(v bool) *ModuleLockConfigForDescribeCdnConfigOutput {
	s.UAAccessRuleLocked = &v
	return s
}

type MultiRangeForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s MultiRangeForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MultiRangeForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetSwitch sets the Switch field's value.
func (s *MultiRangeForDescribeCdnConfigOutput) SetSwitch(v bool) *MultiRangeForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type NegativeCacheForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Condition *ConditionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	NegativeCacheRule *NegativeCacheRuleForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s NegativeCacheForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NegativeCacheForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *NegativeCacheForDescribeCdnConfigOutput) SetCondition(v *ConditionForDescribeCdnConfigOutput) *NegativeCacheForDescribeCdnConfigOutput {
	s.Condition = v
	return s
}

// SetNegativeCacheRule sets the NegativeCacheRule field's value.
func (s *NegativeCacheForDescribeCdnConfigOutput) SetNegativeCacheRule(v *NegativeCacheRuleForDescribeCdnConfigOutput) *NegativeCacheForDescribeCdnConfigOutput {
	s.NegativeCacheRule = v
	return s
}

type NegativeCacheRuleForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Action *string `type:"string" json:",omitempty"`

	IgnoreCase *bool `type:"boolean" json:",omitempty"`

	StatusCode *string `type:"string" json:",omitempty"`

	Ttl *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s NegativeCacheRuleForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NegativeCacheRuleForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *NegativeCacheRuleForDescribeCdnConfigOutput) SetAction(v string) *NegativeCacheRuleForDescribeCdnConfigOutput {
	s.Action = &v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *NegativeCacheRuleForDescribeCdnConfigOutput) SetIgnoreCase(v bool) *NegativeCacheRuleForDescribeCdnConfigOutput {
	s.IgnoreCase = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *NegativeCacheRuleForDescribeCdnConfigOutput) SetStatusCode(v string) *NegativeCacheRuleForDescribeCdnConfigOutput {
	s.StatusCode = &v
	return s
}

// SetTtl sets the Ttl field's value.
func (s *NegativeCacheRuleForDescribeCdnConfigOutput) SetTtl(v int64) *NegativeCacheRuleForDescribeCdnConfigOutput {
	s.Ttl = &v
	return s
}

type OfflineCacheForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Object *string `type:"string" json:",omitempty"`

	StatusCode *string `type:"string" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s OfflineCacheForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OfflineCacheForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetObject sets the Object field's value.
func (s *OfflineCacheForDescribeCdnConfigOutput) SetObject(v string) *OfflineCacheForDescribeCdnConfigOutput {
	s.Object = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *OfflineCacheForDescribeCdnConfigOutput) SetStatusCode(v string) *OfflineCacheForDescribeCdnConfigOutput {
	s.StatusCode = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *OfflineCacheForDescribeCdnConfigOutput) SetSwitch(v bool) *OfflineCacheForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type OriginAccessRuleForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AllowEmpty *bool `type:"boolean" json:",omitempty"`

	IgnoreCase *bool `type:"boolean" json:",omitempty"`

	Origins []*string `type:"list" json:",omitempty"`

	RuleType *string `type:"string" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s OriginAccessRuleForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginAccessRuleForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetAllowEmpty sets the AllowEmpty field's value.
func (s *OriginAccessRuleForDescribeCdnConfigOutput) SetAllowEmpty(v bool) *OriginAccessRuleForDescribeCdnConfigOutput {
	s.AllowEmpty = &v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *OriginAccessRuleForDescribeCdnConfigOutput) SetIgnoreCase(v bool) *OriginAccessRuleForDescribeCdnConfigOutput {
	s.IgnoreCase = &v
	return s
}

// SetOrigins sets the Origins field's value.
func (s *OriginAccessRuleForDescribeCdnConfigOutput) SetOrigins(v []*string) *OriginAccessRuleForDescribeCdnConfigOutput {
	s.Origins = v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *OriginAccessRuleForDescribeCdnConfigOutput) SetRuleType(v string) *OriginAccessRuleForDescribeCdnConfigOutput {
	s.RuleType = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *OriginAccessRuleForDescribeCdnConfigOutput) SetSwitch(v bool) *OriginAccessRuleForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type OriginActionForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	OriginLines []*ConvertOriginLineForDescribeCdnConfigOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s OriginActionForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginActionForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetOriginLines sets the OriginLines field's value.
func (s *OriginActionForDescribeCdnConfigOutput) SetOriginLines(v []*ConvertOriginLineForDescribeCdnConfigOutput) *OriginActionForDescribeCdnConfigOutput {
	s.OriginLines = v
	return s
}

type OriginArgActionForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	OriginArgComponents []*OriginArgComponentForDescribeCdnConfigOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s OriginArgActionForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginArgActionForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetOriginArgComponents sets the OriginArgComponents field's value.
func (s *OriginArgActionForDescribeCdnConfigOutput) SetOriginArgComponents(v []*OriginArgComponentForDescribeCdnConfigOutput) *OriginArgActionForDescribeCdnConfigOutput {
	s.OriginArgComponents = v
	return s
}

type OriginArgComponentForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Action *string `type:"string" json:",omitempty"`

	Object *string `type:"string" json:",omitempty"`

	Subobject *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s OriginArgComponentForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginArgComponentForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *OriginArgComponentForDescribeCdnConfigOutput) SetAction(v string) *OriginArgComponentForDescribeCdnConfigOutput {
	s.Action = &v
	return s
}

// SetObject sets the Object field's value.
func (s *OriginArgComponentForDescribeCdnConfigOutput) SetObject(v string) *OriginArgComponentForDescribeCdnConfigOutput {
	s.Object = &v
	return s
}

// SetSubobject sets the Subobject field's value.
func (s *OriginArgComponentForDescribeCdnConfigOutput) SetSubobject(v string) *OriginArgComponentForDescribeCdnConfigOutput {
	s.Subobject = &v
	return s
}

type OriginArgForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Condition *ConditionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	OriginArgAction *OriginArgActionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s OriginArgForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginArgForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *OriginArgForDescribeCdnConfigOutput) SetCondition(v *ConditionForDescribeCdnConfigOutput) *OriginArgForDescribeCdnConfigOutput {
	s.Condition = v
	return s
}

// SetOriginArgAction sets the OriginArgAction field's value.
func (s *OriginArgForDescribeCdnConfigOutput) SetOriginArgAction(v *OriginArgActionForDescribeCdnConfigOutput) *OriginArgForDescribeCdnConfigOutput {
	s.OriginArgAction = v
	return s
}

type OriginCertCheckForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s OriginCertCheckForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginCertCheckForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetSwitch sets the Switch field's value.
func (s *OriginCertCheckForDescribeCdnConfigOutput) SetSwitch(v bool) *OriginCertCheckForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type OriginForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Condition *ConditionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	OriginAction *OriginActionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s OriginForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *OriginForDescribeCdnConfigOutput) SetCondition(v *ConditionForDescribeCdnConfigOutput) *OriginForDescribeCdnConfigOutput {
	s.Condition = v
	return s
}

// SetOriginAction sets the OriginAction field's value.
func (s *OriginForDescribeCdnConfigOutput) SetOriginAction(v *OriginActionForDescribeCdnConfigOutput) *OriginForDescribeCdnConfigOutput {
	s.OriginAction = v
	return s
}

type OriginLineForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Address *string `type:"string" json:",omitempty"`

	HttpPort *string `type:"string" json:",omitempty"`

	HttpsPort *string `type:"string" json:",omitempty"`

	InstanceType *string `type:"string" json:",omitempty"`

	OriginHost *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s OriginLineForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginLineForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *OriginLineForDescribeCdnConfigOutput) SetAddress(v string) *OriginLineForDescribeCdnConfigOutput {
	s.Address = &v
	return s
}

// SetHttpPort sets the HttpPort field's value.
func (s *OriginLineForDescribeCdnConfigOutput) SetHttpPort(v string) *OriginLineForDescribeCdnConfigOutput {
	s.HttpPort = &v
	return s
}

// SetHttpsPort sets the HttpsPort field's value.
func (s *OriginLineForDescribeCdnConfigOutput) SetHttpsPort(v string) *OriginLineForDescribeCdnConfigOutput {
	s.HttpsPort = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *OriginLineForDescribeCdnConfigOutput) SetInstanceType(v string) *OriginLineForDescribeCdnConfigOutput {
	s.InstanceType = &v
	return s
}

// SetOriginHost sets the OriginHost field's value.
func (s *OriginLineForDescribeCdnConfigOutput) SetOriginHost(v string) *OriginLineForDescribeCdnConfigOutput {
	s.OriginHost = &v
	return s
}

type OriginRetryForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	StatusCode *string `type:"string" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s OriginRetryForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRetryForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetStatusCode sets the StatusCode field's value.
func (s *OriginRetryForDescribeCdnConfigOutput) SetStatusCode(v string) *OriginRetryForDescribeCdnConfigOutput {
	s.StatusCode = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *OriginRetryForDescribeCdnConfigOutput) SetSwitch(v bool) *OriginRetryForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type OriginRewriteActionForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	RewriteType *string `type:"string" json:",omitempty"`

	SourcePath *string `type:"string" json:",omitempty"`

	TargetPath *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s OriginRewriteActionForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRewriteActionForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetRewriteType sets the RewriteType field's value.
func (s *OriginRewriteActionForDescribeCdnConfigOutput) SetRewriteType(v string) *OriginRewriteActionForDescribeCdnConfigOutput {
	s.RewriteType = &v
	return s
}

// SetSourcePath sets the SourcePath field's value.
func (s *OriginRewriteActionForDescribeCdnConfigOutput) SetSourcePath(v string) *OriginRewriteActionForDescribeCdnConfigOutput {
	s.SourcePath = &v
	return s
}

// SetTargetPath sets the TargetPath field's value.
func (s *OriginRewriteActionForDescribeCdnConfigOutput) SetTargetPath(v string) *OriginRewriteActionForDescribeCdnConfigOutput {
	s.TargetPath = &v
	return s
}

type OriginRewriteForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	OriginRewriteRule []*OriginRewriteRuleForDescribeCdnConfigOutput `type:"list" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s OriginRewriteForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRewriteForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetOriginRewriteRule sets the OriginRewriteRule field's value.
func (s *OriginRewriteForDescribeCdnConfigOutput) SetOriginRewriteRule(v []*OriginRewriteRuleForDescribeCdnConfigOutput) *OriginRewriteForDescribeCdnConfigOutput {
	s.OriginRewriteRule = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *OriginRewriteForDescribeCdnConfigOutput) SetSwitch(v bool) *OriginRewriteForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type OriginRewriteRuleForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Condition *ConditionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	OriginRewriteAction *OriginRewriteActionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s OriginRewriteRuleForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRewriteRuleForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *OriginRewriteRuleForDescribeCdnConfigOutput) SetCondition(v *ConditionForDescribeCdnConfigOutput) *OriginRewriteRuleForDescribeCdnConfigOutput {
	s.Condition = v
	return s
}

// SetOriginRewriteAction sets the OriginRewriteAction field's value.
func (s *OriginRewriteRuleForDescribeCdnConfigOutput) SetOriginRewriteAction(v *OriginRewriteActionForDescribeCdnConfigOutput) *OriginRewriteRuleForDescribeCdnConfigOutput {
	s.OriginRewriteAction = v
	return s
}

type OriginRuleForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Actions *ActionsForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	Condition *ConvertConvertConditionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s OriginRuleForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRuleForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetActions sets the Actions field's value.
func (s *OriginRuleForDescribeCdnConfigOutput) SetActions(v *ActionsForDescribeCdnConfigOutput) *OriginRuleForDescribeCdnConfigOutput {
	s.Actions = v
	return s
}

// SetCondition sets the Condition field's value.
func (s *OriginRuleForDescribeCdnConfigOutput) SetCondition(v *ConvertConvertConditionForDescribeCdnConfigOutput) *OriginRuleForDescribeCdnConfigOutput {
	s.Condition = v
	return s
}

type OriginSniForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SniDomain *string `type:"string" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s OriginSniForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginSniForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetSniDomain sets the SniDomain field's value.
func (s *OriginSniForDescribeCdnConfigOutput) SetSniDomain(v string) *OriginSniForDescribeCdnConfigOutput {
	s.SniDomain = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *OriginSniForDescribeCdnConfigOutput) SetSwitch(v bool) *OriginSniForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type PageOptimizationForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	OptimizationType []*string `type:"list" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s PageOptimizationForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PageOptimizationForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetOptimizationType sets the OptimizationType field's value.
func (s *PageOptimizationForDescribeCdnConfigOutput) SetOptimizationType(v []*string) *PageOptimizationForDescribeCdnConfigOutput {
	s.OptimizationType = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *PageOptimizationForDescribeCdnConfigOutput) SetSwitch(v bool) *PageOptimizationForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type PrivateBucketAuthForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AuthType *string `type:"string" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`

	TosAuthInformation *TosAuthInformationForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s PrivateBucketAuthForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PrivateBucketAuthForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetAuthType sets the AuthType field's value.
func (s *PrivateBucketAuthForDescribeCdnConfigOutput) SetAuthType(v string) *PrivateBucketAuthForDescribeCdnConfigOutput {
	s.AuthType = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *PrivateBucketAuthForDescribeCdnConfigOutput) SetSwitch(v bool) *PrivateBucketAuthForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

// SetTosAuthInformation sets the TosAuthInformation field's value.
func (s *PrivateBucketAuthForDescribeCdnConfigOutput) SetTosAuthInformation(v *TosAuthInformationForDescribeCdnConfigOutput) *PrivateBucketAuthForDescribeCdnConfigOutput {
	s.TosAuthInformation = v
	return s
}

type QueryStringComponentsForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Action *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s QueryStringComponentsForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryStringComponentsForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *QueryStringComponentsForDescribeCdnConfigOutput) SetAction(v string) *QueryStringComponentsForDescribeCdnConfigOutput {
	s.Action = &v
	return s
}

// SetValue sets the Value field's value.
func (s *QueryStringComponentsForDescribeCdnConfigOutput) SetValue(v string) *QueryStringComponentsForDescribeCdnConfigOutput {
	s.Value = &v
	return s
}

type QueryStringInstanceForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Action *string `type:"string" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`

	ValueType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s QueryStringInstanceForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryStringInstanceForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *QueryStringInstanceForDescribeCdnConfigOutput) SetAction(v string) *QueryStringInstanceForDescribeCdnConfigOutput {
	s.Action = &v
	return s
}

// SetKey sets the Key field's value.
func (s *QueryStringInstanceForDescribeCdnConfigOutput) SetKey(v string) *QueryStringInstanceForDescribeCdnConfigOutput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *QueryStringInstanceForDescribeCdnConfigOutput) SetValue(v string) *QueryStringInstanceForDescribeCdnConfigOutput {
	s.Value = &v
	return s
}

// SetValueType sets the ValueType field's value.
func (s *QueryStringInstanceForDescribeCdnConfigOutput) SetValueType(v string) *QueryStringInstanceForDescribeCdnConfigOutput {
	s.ValueType = &v
	return s
}

type QueryStringRulesForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	QueryStringComponents *QueryStringComponentsForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	QueryStringInstances []*QueryStringInstanceForDescribeCdnConfigOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s QueryStringRulesForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryStringRulesForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetQueryStringComponents sets the QueryStringComponents field's value.
func (s *QueryStringRulesForDescribeCdnConfigOutput) SetQueryStringComponents(v *QueryStringComponentsForDescribeCdnConfigOutput) *QueryStringRulesForDescribeCdnConfigOutput {
	s.QueryStringComponents = v
	return s
}

// SetQueryStringInstances sets the QueryStringInstances field's value.
func (s *QueryStringRulesForDescribeCdnConfigOutput) SetQueryStringInstances(v []*QueryStringInstanceForDescribeCdnConfigOutput) *QueryStringRulesForDescribeCdnConfigOutput {
	s.QueryStringInstances = v
	return s
}

type QuicForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s QuicForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QuicForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetSwitch sets the Switch field's value.
func (s *QuicForDescribeCdnConfigOutput) SetSwitch(v bool) *QuicForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type RedirectionActionForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	RedirectCode *string `type:"string" json:",omitempty"`

	SourcePath *string `type:"string" json:",omitempty"`

	TargetHost *string `type:"string" json:",omitempty"`

	TargetPath *string `type:"string" json:",omitempty"`

	TargetProtocol *string `type:"string" json:",omitempty"`

	TargetQueryComponents *TargetQueryComponentsForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s RedirectionActionForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RedirectionActionForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetRedirectCode sets the RedirectCode field's value.
func (s *RedirectionActionForDescribeCdnConfigOutput) SetRedirectCode(v string) *RedirectionActionForDescribeCdnConfigOutput {
	s.RedirectCode = &v
	return s
}

// SetSourcePath sets the SourcePath field's value.
func (s *RedirectionActionForDescribeCdnConfigOutput) SetSourcePath(v string) *RedirectionActionForDescribeCdnConfigOutput {
	s.SourcePath = &v
	return s
}

// SetTargetHost sets the TargetHost field's value.
func (s *RedirectionActionForDescribeCdnConfigOutput) SetTargetHost(v string) *RedirectionActionForDescribeCdnConfigOutput {
	s.TargetHost = &v
	return s
}

// SetTargetPath sets the TargetPath field's value.
func (s *RedirectionActionForDescribeCdnConfigOutput) SetTargetPath(v string) *RedirectionActionForDescribeCdnConfigOutput {
	s.TargetPath = &v
	return s
}

// SetTargetProtocol sets the TargetProtocol field's value.
func (s *RedirectionActionForDescribeCdnConfigOutput) SetTargetProtocol(v string) *RedirectionActionForDescribeCdnConfigOutput {
	s.TargetProtocol = &v
	return s
}

// SetTargetQueryComponents sets the TargetQueryComponents field's value.
func (s *RedirectionActionForDescribeCdnConfigOutput) SetTargetQueryComponents(v *TargetQueryComponentsForDescribeCdnConfigOutput) *RedirectionActionForDescribeCdnConfigOutput {
	s.TargetQueryComponents = v
	return s
}

type RedirectionRewriteForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	RedirectionRule []*RedirectionRuleForDescribeCdnConfigOutput `type:"list" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s RedirectionRewriteForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RedirectionRewriteForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetRedirectionRule sets the RedirectionRule field's value.
func (s *RedirectionRewriteForDescribeCdnConfigOutput) SetRedirectionRule(v []*RedirectionRuleForDescribeCdnConfigOutput) *RedirectionRewriteForDescribeCdnConfigOutput {
	s.RedirectionRule = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *RedirectionRewriteForDescribeCdnConfigOutput) SetSwitch(v bool) *RedirectionRewriteForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type RedirectionRuleForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	RedirectionAction *RedirectionActionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s RedirectionRuleForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RedirectionRuleForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetRedirectionAction sets the RedirectionAction field's value.
func (s *RedirectionRuleForDescribeCdnConfigOutput) SetRedirectionAction(v *RedirectionActionForDescribeCdnConfigOutput) *RedirectionRuleForDescribeCdnConfigOutput {
	s.RedirectionAction = v
	return s
}

type RefererAccessRuleForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AllowEmpty *bool `type:"boolean" json:",omitempty"`

	Referers []*string `type:"list" json:",omitempty"`

	ReferersType *ReferersTypeForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	RuleType *string `type:"string" json:",omitempty"`

	SharedConfig *SharedConfigForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s RefererAccessRuleForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RefererAccessRuleForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetAllowEmpty sets the AllowEmpty field's value.
func (s *RefererAccessRuleForDescribeCdnConfigOutput) SetAllowEmpty(v bool) *RefererAccessRuleForDescribeCdnConfigOutput {
	s.AllowEmpty = &v
	return s
}

// SetReferers sets the Referers field's value.
func (s *RefererAccessRuleForDescribeCdnConfigOutput) SetReferers(v []*string) *RefererAccessRuleForDescribeCdnConfigOutput {
	s.Referers = v
	return s
}

// SetReferersType sets the ReferersType field's value.
func (s *RefererAccessRuleForDescribeCdnConfigOutput) SetReferersType(v *ReferersTypeForDescribeCdnConfigOutput) *RefererAccessRuleForDescribeCdnConfigOutput {
	s.ReferersType = v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *RefererAccessRuleForDescribeCdnConfigOutput) SetRuleType(v string) *RefererAccessRuleForDescribeCdnConfigOutput {
	s.RuleType = &v
	return s
}

// SetSharedConfig sets the SharedConfig field's value.
func (s *RefererAccessRuleForDescribeCdnConfigOutput) SetSharedConfig(v *SharedConfigForDescribeCdnConfigOutput) *RefererAccessRuleForDescribeCdnConfigOutput {
	s.SharedConfig = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *RefererAccessRuleForDescribeCdnConfigOutput) SetSwitch(v bool) *RefererAccessRuleForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type ReferersTypeForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CommonType *CommonTypeForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	RegularType *RegularTypeForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ReferersTypeForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ReferersTypeForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCommonType sets the CommonType field's value.
func (s *ReferersTypeForDescribeCdnConfigOutput) SetCommonType(v *CommonTypeForDescribeCdnConfigOutput) *ReferersTypeForDescribeCdnConfigOutput {
	s.CommonType = v
	return s
}

// SetRegularType sets the RegularType field's value.
func (s *ReferersTypeForDescribeCdnConfigOutput) SetRegularType(v *RegularTypeForDescribeCdnConfigOutput) *ReferersTypeForDescribeCdnConfigOutput {
	s.RegularType = v
	return s
}

type RegularTypeForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Referers []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s RegularTypeForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RegularTypeForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetReferers sets the Referers field's value.
func (s *RegularTypeForDescribeCdnConfigOutput) SetReferers(v []*string) *RegularTypeForDescribeCdnConfigOutput {
	s.Referers = v
	return s
}

type RemoteAuthForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	RemoteAuthRules []*RemoteAuthRuleForDescribeCdnConfigOutput `type:"list" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s RemoteAuthForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoteAuthForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetRemoteAuthRules sets the RemoteAuthRules field's value.
func (s *RemoteAuthForDescribeCdnConfigOutput) SetRemoteAuthRules(v []*RemoteAuthRuleForDescribeCdnConfigOutput) *RemoteAuthForDescribeCdnConfigOutput {
	s.RemoteAuthRules = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *RemoteAuthForDescribeCdnConfigOutput) SetSwitch(v bool) *RemoteAuthForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type RemoteAuthRuleActionForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AuthModeConfig *AuthModeConfigForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	AuthResponseConfig *AuthResponseConfigForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	QueryStringRules *QueryStringRulesForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	RequestBodyRules *string `type:"string" json:",omitempty"`

	RequestHeaderRules *RequestHeaderRulesForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s RemoteAuthRuleActionForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoteAuthRuleActionForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetAuthModeConfig sets the AuthModeConfig field's value.
func (s *RemoteAuthRuleActionForDescribeCdnConfigOutput) SetAuthModeConfig(v *AuthModeConfigForDescribeCdnConfigOutput) *RemoteAuthRuleActionForDescribeCdnConfigOutput {
	s.AuthModeConfig = v
	return s
}

// SetAuthResponseConfig sets the AuthResponseConfig field's value.
func (s *RemoteAuthRuleActionForDescribeCdnConfigOutput) SetAuthResponseConfig(v *AuthResponseConfigForDescribeCdnConfigOutput) *RemoteAuthRuleActionForDescribeCdnConfigOutput {
	s.AuthResponseConfig = v
	return s
}

// SetQueryStringRules sets the QueryStringRules field's value.
func (s *RemoteAuthRuleActionForDescribeCdnConfigOutput) SetQueryStringRules(v *QueryStringRulesForDescribeCdnConfigOutput) *RemoteAuthRuleActionForDescribeCdnConfigOutput {
	s.QueryStringRules = v
	return s
}

// SetRequestBodyRules sets the RequestBodyRules field's value.
func (s *RemoteAuthRuleActionForDescribeCdnConfigOutput) SetRequestBodyRules(v string) *RemoteAuthRuleActionForDescribeCdnConfigOutput {
	s.RequestBodyRules = &v
	return s
}

// SetRequestHeaderRules sets the RequestHeaderRules field's value.
func (s *RemoteAuthRuleActionForDescribeCdnConfigOutput) SetRequestHeaderRules(v *RequestHeaderRulesForDescribeCdnConfigOutput) *RemoteAuthRuleActionForDescribeCdnConfigOutput {
	s.RequestHeaderRules = v
	return s
}

type RemoteAuthRuleForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Condition *ConditionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	RemoteAuthRuleAction *RemoteAuthRuleActionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s RemoteAuthRuleForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoteAuthRuleForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *RemoteAuthRuleForDescribeCdnConfigOutput) SetCondition(v *ConditionForDescribeCdnConfigOutput) *RemoteAuthRuleForDescribeCdnConfigOutput {
	s.Condition = v
	return s
}

// SetRemoteAuthRuleAction sets the RemoteAuthRuleAction field's value.
func (s *RemoteAuthRuleForDescribeCdnConfigOutput) SetRemoteAuthRuleAction(v *RemoteAuthRuleActionForDescribeCdnConfigOutput) *RemoteAuthRuleForDescribeCdnConfigOutput {
	s.RemoteAuthRuleAction = v
	return s
}

type RequestBlockRuleForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BlockRule []*BlockRuleForDescribeCdnConfigOutput `type:"list" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s RequestBlockRuleForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestBlockRuleForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetBlockRule sets the BlockRule field's value.
func (s *RequestBlockRuleForDescribeCdnConfigOutput) SetBlockRule(v []*BlockRuleForDescribeCdnConfigOutput) *RequestBlockRuleForDescribeCdnConfigOutput {
	s.BlockRule = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *RequestBlockRuleForDescribeCdnConfigOutput) SetSwitch(v bool) *RequestBlockRuleForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type RequestHeaderActionForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	RequestHeaderInstances []*RequestHeaderInstanceForDescribeCdnConfigOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s RequestHeaderActionForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestHeaderActionForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetRequestHeaderInstances sets the RequestHeaderInstances field's value.
func (s *RequestHeaderActionForDescribeCdnConfigOutput) SetRequestHeaderInstances(v []*RequestHeaderInstanceForDescribeCdnConfigOutput) *RequestHeaderActionForDescribeCdnConfigOutput {
	s.RequestHeaderInstances = v
	return s
}

type RequestHeaderComponentsForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Action *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s RequestHeaderComponentsForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestHeaderComponentsForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *RequestHeaderComponentsForDescribeCdnConfigOutput) SetAction(v string) *RequestHeaderComponentsForDescribeCdnConfigOutput {
	s.Action = &v
	return s
}

// SetValue sets the Value field's value.
func (s *RequestHeaderComponentsForDescribeCdnConfigOutput) SetValue(v string) *RequestHeaderComponentsForDescribeCdnConfigOutput {
	s.Value = &v
	return s
}

type RequestHeaderForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Condition *ConditionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	RequestHeaderAction *RequestHeaderActionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s RequestHeaderForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestHeaderForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *RequestHeaderForDescribeCdnConfigOutput) SetCondition(v *ConditionForDescribeCdnConfigOutput) *RequestHeaderForDescribeCdnConfigOutput {
	s.Condition = v
	return s
}

// SetRequestHeaderAction sets the RequestHeaderAction field's value.
func (s *RequestHeaderForDescribeCdnConfigOutput) SetRequestHeaderAction(v *RequestHeaderActionForDescribeCdnConfigOutput) *RequestHeaderForDescribeCdnConfigOutput {
	s.RequestHeaderAction = v
	return s
}

type RequestHeaderInstanceForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Action *string `type:"string" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`

	ValueType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s RequestHeaderInstanceForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestHeaderInstanceForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *RequestHeaderInstanceForDescribeCdnConfigOutput) SetAction(v string) *RequestHeaderInstanceForDescribeCdnConfigOutput {
	s.Action = &v
	return s
}

// SetKey sets the Key field's value.
func (s *RequestHeaderInstanceForDescribeCdnConfigOutput) SetKey(v string) *RequestHeaderInstanceForDescribeCdnConfigOutput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *RequestHeaderInstanceForDescribeCdnConfigOutput) SetValue(v string) *RequestHeaderInstanceForDescribeCdnConfigOutput {
	s.Value = &v
	return s
}

// SetValueType sets the ValueType field's value.
func (s *RequestHeaderInstanceForDescribeCdnConfigOutput) SetValueType(v string) *RequestHeaderInstanceForDescribeCdnConfigOutput {
	s.ValueType = &v
	return s
}

type RequestHeaderRulesForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	RequestHeaderComponents *RequestHeaderComponentsForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	RequestHeaderInstances []*RequestHeaderInstanceForDescribeCdnConfigOutput `type:"list" json:",omitempty"`

	RequestHost *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s RequestHeaderRulesForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestHeaderRulesForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetRequestHeaderComponents sets the RequestHeaderComponents field's value.
func (s *RequestHeaderRulesForDescribeCdnConfigOutput) SetRequestHeaderComponents(v *RequestHeaderComponentsForDescribeCdnConfigOutput) *RequestHeaderRulesForDescribeCdnConfigOutput {
	s.RequestHeaderComponents = v
	return s
}

// SetRequestHeaderInstances sets the RequestHeaderInstances field's value.
func (s *RequestHeaderRulesForDescribeCdnConfigOutput) SetRequestHeaderInstances(v []*RequestHeaderInstanceForDescribeCdnConfigOutput) *RequestHeaderRulesForDescribeCdnConfigOutput {
	s.RequestHeaderInstances = v
	return s
}

// SetRequestHost sets the RequestHost field's value.
func (s *RequestHeaderRulesForDescribeCdnConfigOutput) SetRequestHost(v string) *RequestHeaderRulesForDescribeCdnConfigOutput {
	s.RequestHost = &v
	return s
}

type ResponseActionForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	StatusCode *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ResponseActionForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResponseActionForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetStatusCode sets the StatusCode field's value.
func (s *ResponseActionForDescribeCdnConfigOutput) SetStatusCode(v string) *ResponseActionForDescribeCdnConfigOutput {
	s.StatusCode = &v
	return s
}

type ResponseHeaderActionForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ResponseHeaderInstances []*ResponseHeaderInstanceForDescribeCdnConfigOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ResponseHeaderActionForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResponseHeaderActionForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetResponseHeaderInstances sets the ResponseHeaderInstances field's value.
func (s *ResponseHeaderActionForDescribeCdnConfigOutput) SetResponseHeaderInstances(v []*ResponseHeaderInstanceForDescribeCdnConfigOutput) *ResponseHeaderActionForDescribeCdnConfigOutput {
	s.ResponseHeaderInstances = v
	return s
}

type ResponseHeaderForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Condition *ConditionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	ResponseHeaderAction *ResponseHeaderActionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ResponseHeaderForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResponseHeaderForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *ResponseHeaderForDescribeCdnConfigOutput) SetCondition(v *ConditionForDescribeCdnConfigOutput) *ResponseHeaderForDescribeCdnConfigOutput {
	s.Condition = v
	return s
}

// SetResponseHeaderAction sets the ResponseHeaderAction field's value.
func (s *ResponseHeaderForDescribeCdnConfigOutput) SetResponseHeaderAction(v *ResponseHeaderActionForDescribeCdnConfigOutput) *ResponseHeaderForDescribeCdnConfigOutput {
	s.ResponseHeaderAction = v
	return s
}

type ResponseHeaderInstanceForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessOriginControl *bool `type:"boolean" json:",omitempty"`

	Action *string `type:"string" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`

	ValueType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ResponseHeaderInstanceForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResponseHeaderInstanceForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetAccessOriginControl sets the AccessOriginControl field's value.
func (s *ResponseHeaderInstanceForDescribeCdnConfigOutput) SetAccessOriginControl(v bool) *ResponseHeaderInstanceForDescribeCdnConfigOutput {
	s.AccessOriginControl = &v
	return s
}

// SetAction sets the Action field's value.
func (s *ResponseHeaderInstanceForDescribeCdnConfigOutput) SetAction(v string) *ResponseHeaderInstanceForDescribeCdnConfigOutput {
	s.Action = &v
	return s
}

// SetKey sets the Key field's value.
func (s *ResponseHeaderInstanceForDescribeCdnConfigOutput) SetKey(v string) *ResponseHeaderInstanceForDescribeCdnConfigOutput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ResponseHeaderInstanceForDescribeCdnConfigOutput) SetValue(v string) *ResponseHeaderInstanceForDescribeCdnConfigOutput {
	s.Value = &v
	return s
}

// SetValueType sets the ValueType field's value.
func (s *ResponseHeaderInstanceForDescribeCdnConfigOutput) SetValueType(v string) *ResponseHeaderInstanceForDescribeCdnConfigOutput {
	s.ValueType = &v
	return s
}

type RewriteHLSForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SignName *string `type:"string" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s RewriteHLSForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RewriteHLSForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetSignName sets the SignName field's value.
func (s *RewriteHLSForDescribeCdnConfigOutput) SetSignName(v string) *RewriteHLSForDescribeCdnConfigOutput {
	s.SignName = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *RewriteHLSForDescribeCdnConfigOutput) SetSwitch(v bool) *RewriteHLSForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type RewriteM3u8RuleForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DeleteParam *bool `type:"boolean" json:",omitempty"`

	KeepM3u8Param *bool `type:"boolean" json:",omitempty"`

	TransferEncoding *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s RewriteM3u8RuleForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RewriteM3u8RuleForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetDeleteParam sets the DeleteParam field's value.
func (s *RewriteM3u8RuleForDescribeCdnConfigOutput) SetDeleteParam(v bool) *RewriteM3u8RuleForDescribeCdnConfigOutput {
	s.DeleteParam = &v
	return s
}

// SetKeepM3u8Param sets the KeepM3u8Param field's value.
func (s *RewriteM3u8RuleForDescribeCdnConfigOutput) SetKeepM3u8Param(v bool) *RewriteM3u8RuleForDescribeCdnConfigOutput {
	s.KeepM3u8Param = &v
	return s
}

// SetTransferEncoding sets the TransferEncoding field's value.
func (s *RewriteM3u8RuleForDescribeCdnConfigOutput) SetTransferEncoding(v bool) *RewriteM3u8RuleForDescribeCdnConfigOutput {
	s.TransferEncoding = &v
	return s
}

type SharedConfigForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ConfigName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s SharedConfigForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SharedConfigForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetConfigName sets the ConfigName field's value.
func (s *SharedConfigForDescribeCdnConfigOutput) SetConfigName(v string) *SharedConfigForDescribeCdnConfigOutput {
	s.ConfigName = &v
	return s
}

type SignCapRuleForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CapMode *string `type:"string" json:",omitempty"`

	ParamName *string `type:"string" json:",omitempty"`

	UriLevel *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s SignCapRuleForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SignCapRuleForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCapMode sets the CapMode field's value.
func (s *SignCapRuleForDescribeCdnConfigOutput) SetCapMode(v string) *SignCapRuleForDescribeCdnConfigOutput {
	s.CapMode = &v
	return s
}

// SetParamName sets the ParamName field's value.
func (s *SignCapRuleForDescribeCdnConfigOutput) SetParamName(v string) *SignCapRuleForDescribeCdnConfigOutput {
	s.ParamName = &v
	return s
}

// SetUriLevel sets the UriLevel field's value.
func (s *SignCapRuleForDescribeCdnConfigOutput) SetUriLevel(v int64) *SignCapRuleForDescribeCdnConfigOutput {
	s.UriLevel = &v
	return s
}

type SignParamForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ParamType *string `type:"string" json:",omitempty"`

	RequestHeader *string `type:"string" json:",omitempty"`

	SupContent *string `type:"string" json:",omitempty"`

	UriParamSup *UriParamSupForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	UrlParam *SignCapRuleForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s SignParamForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SignParamForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetParamType sets the ParamType field's value.
func (s *SignParamForDescribeCdnConfigOutput) SetParamType(v string) *SignParamForDescribeCdnConfigOutput {
	s.ParamType = &v
	return s
}

// SetRequestHeader sets the RequestHeader field's value.
func (s *SignParamForDescribeCdnConfigOutput) SetRequestHeader(v string) *SignParamForDescribeCdnConfigOutput {
	s.RequestHeader = &v
	return s
}

// SetSupContent sets the SupContent field's value.
func (s *SignParamForDescribeCdnConfigOutput) SetSupContent(v string) *SignParamForDescribeCdnConfigOutput {
	s.SupContent = &v
	return s
}

// SetUriParamSup sets the UriParamSup field's value.
func (s *SignParamForDescribeCdnConfigOutput) SetUriParamSup(v *UriParamSupForDescribeCdnConfigOutput) *SignParamForDescribeCdnConfigOutput {
	s.UriParamSup = v
	return s
}

// SetUrlParam sets the UrlParam field's value.
func (s *SignParamForDescribeCdnConfigOutput) SetUrlParam(v *SignCapRuleForDescribeCdnConfigOutput) *SignParamForDescribeCdnConfigOutput {
	s.UrlParam = v
	return s
}

type SignedUrlAuthActionForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AuthAlgorithm *string `type:"string" json:",omitempty"`

	BackupSecretKey *string `type:"string" json:",omitempty"`

	CustomVariableRules *CustomVariableRulesForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	Duration *int64 `type:"int64" json:",omitempty"`

	KeepOriginArg *bool `type:"boolean" json:",omitempty"`

	MasterSecretKey *string `type:"string" json:",omitempty"`

	MpdVarExpand *bool `type:"boolean" json:",omitempty"`

	RewriteM3u8 *bool `type:"boolean" json:",omitempty"`

	RewriteM3u8Rule *RewriteM3u8RuleForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	RewriteMpd *bool `type:"boolean" json:",omitempty"`

	SignName *string `type:"string" json:",omitempty"`

	SignatureRule []*string `type:"list" json:",omitempty"`

	TimeFormat *string `type:"string" json:",omitempty"`

	TimeName *string `type:"string" json:",omitempty"`

	URLAuthType *string `type:"string" json:",omitempty"`

	UrlAuthCustomAction *UrlAuthCustomActionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s SignedUrlAuthActionForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SignedUrlAuthActionForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetAuthAlgorithm sets the AuthAlgorithm field's value.
func (s *SignedUrlAuthActionForDescribeCdnConfigOutput) SetAuthAlgorithm(v string) *SignedUrlAuthActionForDescribeCdnConfigOutput {
	s.AuthAlgorithm = &v
	return s
}

// SetBackupSecretKey sets the BackupSecretKey field's value.
func (s *SignedUrlAuthActionForDescribeCdnConfigOutput) SetBackupSecretKey(v string) *SignedUrlAuthActionForDescribeCdnConfigOutput {
	s.BackupSecretKey = &v
	return s
}

// SetCustomVariableRules sets the CustomVariableRules field's value.
func (s *SignedUrlAuthActionForDescribeCdnConfigOutput) SetCustomVariableRules(v *CustomVariableRulesForDescribeCdnConfigOutput) *SignedUrlAuthActionForDescribeCdnConfigOutput {
	s.CustomVariableRules = v
	return s
}

// SetDuration sets the Duration field's value.
func (s *SignedUrlAuthActionForDescribeCdnConfigOutput) SetDuration(v int64) *SignedUrlAuthActionForDescribeCdnConfigOutput {
	s.Duration = &v
	return s
}

// SetKeepOriginArg sets the KeepOriginArg field's value.
func (s *SignedUrlAuthActionForDescribeCdnConfigOutput) SetKeepOriginArg(v bool) *SignedUrlAuthActionForDescribeCdnConfigOutput {
	s.KeepOriginArg = &v
	return s
}

// SetMasterSecretKey sets the MasterSecretKey field's value.
func (s *SignedUrlAuthActionForDescribeCdnConfigOutput) SetMasterSecretKey(v string) *SignedUrlAuthActionForDescribeCdnConfigOutput {
	s.MasterSecretKey = &v
	return s
}

// SetMpdVarExpand sets the MpdVarExpand field's value.
func (s *SignedUrlAuthActionForDescribeCdnConfigOutput) SetMpdVarExpand(v bool) *SignedUrlAuthActionForDescribeCdnConfigOutput {
	s.MpdVarExpand = &v
	return s
}

// SetRewriteM3u8 sets the RewriteM3u8 field's value.
func (s *SignedUrlAuthActionForDescribeCdnConfigOutput) SetRewriteM3u8(v bool) *SignedUrlAuthActionForDescribeCdnConfigOutput {
	s.RewriteM3u8 = &v
	return s
}

// SetRewriteM3u8Rule sets the RewriteM3u8Rule field's value.
func (s *SignedUrlAuthActionForDescribeCdnConfigOutput) SetRewriteM3u8Rule(v *RewriteM3u8RuleForDescribeCdnConfigOutput) *SignedUrlAuthActionForDescribeCdnConfigOutput {
	s.RewriteM3u8Rule = v
	return s
}

// SetRewriteMpd sets the RewriteMpd field's value.
func (s *SignedUrlAuthActionForDescribeCdnConfigOutput) SetRewriteMpd(v bool) *SignedUrlAuthActionForDescribeCdnConfigOutput {
	s.RewriteMpd = &v
	return s
}

// SetSignName sets the SignName field's value.
func (s *SignedUrlAuthActionForDescribeCdnConfigOutput) SetSignName(v string) *SignedUrlAuthActionForDescribeCdnConfigOutput {
	s.SignName = &v
	return s
}

// SetSignatureRule sets the SignatureRule field's value.
func (s *SignedUrlAuthActionForDescribeCdnConfigOutput) SetSignatureRule(v []*string) *SignedUrlAuthActionForDescribeCdnConfigOutput {
	s.SignatureRule = v
	return s
}

// SetTimeFormat sets the TimeFormat field's value.
func (s *SignedUrlAuthActionForDescribeCdnConfigOutput) SetTimeFormat(v string) *SignedUrlAuthActionForDescribeCdnConfigOutput {
	s.TimeFormat = &v
	return s
}

// SetTimeName sets the TimeName field's value.
func (s *SignedUrlAuthActionForDescribeCdnConfigOutput) SetTimeName(v string) *SignedUrlAuthActionForDescribeCdnConfigOutput {
	s.TimeName = &v
	return s
}

// SetURLAuthType sets the URLAuthType field's value.
func (s *SignedUrlAuthActionForDescribeCdnConfigOutput) SetURLAuthType(v string) *SignedUrlAuthActionForDescribeCdnConfigOutput {
	s.URLAuthType = &v
	return s
}

// SetUrlAuthCustomAction sets the UrlAuthCustomAction field's value.
func (s *SignedUrlAuthActionForDescribeCdnConfigOutput) SetUrlAuthCustomAction(v *UrlAuthCustomActionForDescribeCdnConfigOutput) *SignedUrlAuthActionForDescribeCdnConfigOutput {
	s.UrlAuthCustomAction = v
	return s
}

type SignedUrlAuthForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SignedUrlAuthRules []*SignedUrlAuthRuleForDescribeCdnConfigOutput `type:"list" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s SignedUrlAuthForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SignedUrlAuthForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetSignedUrlAuthRules sets the SignedUrlAuthRules field's value.
func (s *SignedUrlAuthForDescribeCdnConfigOutput) SetSignedUrlAuthRules(v []*SignedUrlAuthRuleForDescribeCdnConfigOutput) *SignedUrlAuthForDescribeCdnConfigOutput {
	s.SignedUrlAuthRules = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *SignedUrlAuthForDescribeCdnConfigOutput) SetSwitch(v bool) *SignedUrlAuthForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type SignedUrlAuthRuleForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Condition *ConditionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	SignedUrlAuthAction *SignedUrlAuthActionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s SignedUrlAuthRuleForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SignedUrlAuthRuleForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *SignedUrlAuthRuleForDescribeCdnConfigOutput) SetCondition(v *ConditionForDescribeCdnConfigOutput) *SignedUrlAuthRuleForDescribeCdnConfigOutput {
	s.Condition = v
	return s
}

// SetSignedUrlAuthAction sets the SignedUrlAuthAction field's value.
func (s *SignedUrlAuthRuleForDescribeCdnConfigOutput) SetSignedUrlAuthAction(v *SignedUrlAuthActionForDescribeCdnConfigOutput) *SignedUrlAuthRuleForDescribeCdnConfigOutput {
	s.SignedUrlAuthAction = v
	return s
}

type SpeedLimitTimeForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BeginTime *string `type:"string" json:",omitempty"`

	DayWeek *string `type:"string" json:",omitempty"`

	EndTime *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s SpeedLimitTimeForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SpeedLimitTimeForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetBeginTime sets the BeginTime field's value.
func (s *SpeedLimitTimeForDescribeCdnConfigOutput) SetBeginTime(v string) *SpeedLimitTimeForDescribeCdnConfigOutput {
	s.BeginTime = &v
	return s
}

// SetDayWeek sets the DayWeek field's value.
func (s *SpeedLimitTimeForDescribeCdnConfigOutput) SetDayWeek(v string) *SpeedLimitTimeForDescribeCdnConfigOutput {
	s.DayWeek = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *SpeedLimitTimeForDescribeCdnConfigOutput) SetEndTime(v string) *SpeedLimitTimeForDescribeCdnConfigOutput {
	s.EndTime = &v
	return s
}

type StatusCodeActionForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DefaultAction *string `type:"string" json:",omitempty"`

	FailCode *string `type:"string" json:",omitempty"`

	SuccessCode *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s StatusCodeActionForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusCodeActionForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetDefaultAction sets the DefaultAction field's value.
func (s *StatusCodeActionForDescribeCdnConfigOutput) SetDefaultAction(v string) *StatusCodeActionForDescribeCdnConfigOutput {
	s.DefaultAction = &v
	return s
}

// SetFailCode sets the FailCode field's value.
func (s *StatusCodeActionForDescribeCdnConfigOutput) SetFailCode(v string) *StatusCodeActionForDescribeCdnConfigOutput {
	s.FailCode = &v
	return s
}

// SetSuccessCode sets the SuccessCode field's value.
func (s *StatusCodeActionForDescribeCdnConfigOutput) SetSuccessCode(v string) *StatusCodeActionForDescribeCdnConfigOutput {
	s.SuccessCode = &v
	return s
}

type TargetQueryComponentsForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Action *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TargetQueryComponentsForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TargetQueryComponentsForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *TargetQueryComponentsForDescribeCdnConfigOutput) SetAction(v string) *TargetQueryComponentsForDescribeCdnConfigOutput {
	s.Action = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TargetQueryComponentsForDescribeCdnConfigOutput) SetValue(v string) *TargetQueryComponentsForDescribeCdnConfigOutput {
	s.Value = &v
	return s
}

type TimeOutActionForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Action *string `type:"string" json:",omitempty"`

	Time *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s TimeOutActionForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeOutActionForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *TimeOutActionForDescribeCdnConfigOutput) SetAction(v string) *TimeOutActionForDescribeCdnConfigOutput {
	s.Action = &v
	return s
}

// SetTime sets the Time field's value.
func (s *TimeOutActionForDescribeCdnConfigOutput) SetTime(v int64) *TimeOutActionForDescribeCdnConfigOutput {
	s.Time = &v
	return s
}

type TimeoutForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`

	TimeoutRules []*TimeoutRuleForDescribeCdnConfigOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s TimeoutForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeoutForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetSwitch sets the Switch field's value.
func (s *TimeoutForDescribeCdnConfigOutput) SetSwitch(v bool) *TimeoutForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

// SetTimeoutRules sets the TimeoutRules field's value.
func (s *TimeoutForDescribeCdnConfigOutput) SetTimeoutRules(v []*TimeoutRuleForDescribeCdnConfigOutput) *TimeoutForDescribeCdnConfigOutput {
	s.TimeoutRules = v
	return s
}

type TimeoutRuleForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Condition *ConditionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	TimeoutAction *ConvertTimeoutActionForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s TimeoutRuleForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeoutRuleForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *TimeoutRuleForDescribeCdnConfigOutput) SetCondition(v *ConditionForDescribeCdnConfigOutput) *TimeoutRuleForDescribeCdnConfigOutput {
	s.Condition = v
	return s
}

// SetTimeoutAction sets the TimeoutAction field's value.
func (s *TimeoutRuleForDescribeCdnConfigOutput) SetTimeoutAction(v *ConvertTimeoutActionForDescribeCdnConfigOutput) *TimeoutRuleForDescribeCdnConfigOutput {
	s.TimeoutAction = v
	return s
}

type TosAuthInformationForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessKeyId *string `type:"string" json:",omitempty"`

	AccessKeySecret *string `type:"string" json:",omitempty"`

	AccountKey *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TosAuthInformationForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TosAuthInformationForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetAccessKeyId sets the AccessKeyId field's value.
func (s *TosAuthInformationForDescribeCdnConfigOutput) SetAccessKeyId(v string) *TosAuthInformationForDescribeCdnConfigOutput {
	s.AccessKeyId = &v
	return s
}

// SetAccessKeySecret sets the AccessKeySecret field's value.
func (s *TosAuthInformationForDescribeCdnConfigOutput) SetAccessKeySecret(v string) *TosAuthInformationForDescribeCdnConfigOutput {
	s.AccessKeySecret = &v
	return s
}

// SetAccountKey sets the AccountKey field's value.
func (s *TosAuthInformationForDescribeCdnConfigOutput) SetAccountKey(v string) *TosAuthInformationForDescribeCdnConfigOutput {
	s.AccountKey = &v
	return s
}

type UaAccessRuleForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AllowEmpty *bool `type:"boolean" json:",omitempty"`

	IgnoreCase *bool `type:"boolean" json:",omitempty"`

	RuleType *string `type:"string" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`

	UserAgent []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s UaAccessRuleForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UaAccessRuleForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetAllowEmpty sets the AllowEmpty field's value.
func (s *UaAccessRuleForDescribeCdnConfigOutput) SetAllowEmpty(v bool) *UaAccessRuleForDescribeCdnConfigOutput {
	s.AllowEmpty = &v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *UaAccessRuleForDescribeCdnConfigOutput) SetIgnoreCase(v bool) *UaAccessRuleForDescribeCdnConfigOutput {
	s.IgnoreCase = &v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *UaAccessRuleForDescribeCdnConfigOutput) SetRuleType(v string) *UaAccessRuleForDescribeCdnConfigOutput {
	s.RuleType = &v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *UaAccessRuleForDescribeCdnConfigOutput) SetSwitch(v bool) *UaAccessRuleForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

// SetUserAgent sets the UserAgent field's value.
func (s *UaAccessRuleForDescribeCdnConfigOutput) SetUserAgent(v []*string) *UaAccessRuleForDescribeCdnConfigOutput {
	s.UserAgent = v
	return s
}

type UriParamSupForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	JoinSymbol *string `type:"string" json:",omitempty"`

	SplitSymbol *string `type:"string" json:",omitempty"`

	StartLevel *int64 `type:"int64" json:",omitempty"`

	TermLevel *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s UriParamSupForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UriParamSupForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetJoinSymbol sets the JoinSymbol field's value.
func (s *UriParamSupForDescribeCdnConfigOutput) SetJoinSymbol(v string) *UriParamSupForDescribeCdnConfigOutput {
	s.JoinSymbol = &v
	return s
}

// SetSplitSymbol sets the SplitSymbol field's value.
func (s *UriParamSupForDescribeCdnConfigOutput) SetSplitSymbol(v string) *UriParamSupForDescribeCdnConfigOutput {
	s.SplitSymbol = &v
	return s
}

// SetStartLevel sets the StartLevel field's value.
func (s *UriParamSupForDescribeCdnConfigOutput) SetStartLevel(v int64) *UriParamSupForDescribeCdnConfigOutput {
	s.StartLevel = &v
	return s
}

// SetTermLevel sets the TermLevel field's value.
func (s *UriParamSupForDescribeCdnConfigOutput) SetTermLevel(v int64) *UriParamSupForDescribeCdnConfigOutput {
	s.TermLevel = &v
	return s
}

type UrlAuthCustomActionForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ExpTimeCapRule *ExpTimeCapRuleForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	ParamCalRules []*string `type:"list" json:",omitempty"`

	SignCapRule *SignCapRuleForDescribeCdnConfigOutput `type:"structure" json:",omitempty"`

	SignJoinSymbol *string `type:"string" json:",omitempty"`

	SignParam []*SignParamForDescribeCdnConfigOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s UrlAuthCustomActionForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UrlAuthCustomActionForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetExpTimeCapRule sets the ExpTimeCapRule field's value.
func (s *UrlAuthCustomActionForDescribeCdnConfigOutput) SetExpTimeCapRule(v *ExpTimeCapRuleForDescribeCdnConfigOutput) *UrlAuthCustomActionForDescribeCdnConfigOutput {
	s.ExpTimeCapRule = v
	return s
}

// SetParamCalRules sets the ParamCalRules field's value.
func (s *UrlAuthCustomActionForDescribeCdnConfigOutput) SetParamCalRules(v []*string) *UrlAuthCustomActionForDescribeCdnConfigOutput {
	s.ParamCalRules = v
	return s
}

// SetSignCapRule sets the SignCapRule field's value.
func (s *UrlAuthCustomActionForDescribeCdnConfigOutput) SetSignCapRule(v *SignCapRuleForDescribeCdnConfigOutput) *UrlAuthCustomActionForDescribeCdnConfigOutput {
	s.SignCapRule = v
	return s
}

// SetSignJoinSymbol sets the SignJoinSymbol field's value.
func (s *UrlAuthCustomActionForDescribeCdnConfigOutput) SetSignJoinSymbol(v string) *UrlAuthCustomActionForDescribeCdnConfigOutput {
	s.SignJoinSymbol = &v
	return s
}

// SetSignParam sets the SignParam field's value.
func (s *UrlAuthCustomActionForDescribeCdnConfigOutput) SetSignParam(v []*SignParamForDescribeCdnConfigOutput) *UrlAuthCustomActionForDescribeCdnConfigOutput {
	s.SignParam = v
	return s
}

type UrlNormalizeForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	NormalizeObject []*string `type:"list" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s UrlNormalizeForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UrlNormalizeForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetNormalizeObject sets the NormalizeObject field's value.
func (s *UrlNormalizeForDescribeCdnConfigOutput) SetNormalizeObject(v []*string) *UrlNormalizeForDescribeCdnConfigOutput {
	s.NormalizeObject = v
	return s
}

// SetSwitch sets the Switch field's value.
func (s *UrlNormalizeForDescribeCdnConfigOutput) SetSwitch(v bool) *UrlNormalizeForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}

type VideoDragForDescribeCdnConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Switch *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s VideoDragForDescribeCdnConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VideoDragForDescribeCdnConfigOutput) GoString() string {
	return s.String()
}

// SetSwitch sets the Switch field's value.
func (s *VideoDragForDescribeCdnConfigOutput) SetSwitch(v bool) *VideoDragForDescribeCdnConfigOutput {
	s.Switch = &v
	return s
}
