// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package bio

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListTasksCommon = "ListTasks"

// ListTasksCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListTasksCommon operation. The "output" return
// value will be populated with the ListTasksCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListTasksCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListTasksCommon Send returns without error.
//
// See ListTasksCommon for more information on using the ListTasksCommon
// API call, and error handling.
//
//    // Example sending a request using the ListTasksCommonRequest method.
//    req, resp := client.ListTasksCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BIO) ListTasksCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListTasksCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListTasksCommon API operation for BIO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BIO's
// API operation ListTasksCommon for usage and error information.
func (c *BIO) ListTasksCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListTasksCommonRequest(input)
	return out, req.Send()
}

// ListTasksCommonWithContext is the same as ListTasksCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListTasksCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BIO) ListTasksCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListTasksCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTasks = "ListTasks"

// ListTasksRequest generates a "volcengine/request.Request" representing the
// client's request for the ListTasks operation. The "output" return
// value will be populated with the ListTasksCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListTasksCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListTasksCommon Send returns without error.
//
// See ListTasks for more information on using the ListTasks
// API call, and error handling.
//
//    // Example sending a request using the ListTasksRequest method.
//    req, resp := client.ListTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *BIO) ListTasksRequest(input *ListTasksInput) (req *request.Request, output *ListTasksOutput) {
	op := &request.Operation{
		Name:       opListTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTasksInput{}
	}

	output = &ListTasksOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListTasks API operation for BIO.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for BIO's
// API operation ListTasks for usage and error information.
func (c *BIO) ListTasks(input *ListTasksInput) (*ListTasksOutput, error) {
	req, out := c.ListTasksRequest(input)
	return out, req.Send()
}

// ListTasksWithContext is the same as ListTasks with the addition of
// the ability to pass a context and additional request options.
//
// See ListTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *BIO) ListTasksWithContext(ctx volcengine.Context, input *ListTasksInput, opts ...request.Option) (*ListTasksOutput, error) {
	req, out := c.ListTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ItemForListTasksOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Duration *int32 `type:"int32" json:",omitempty"`

	ExecuteDuration *int32 `type:"int32" json:",omitempty"`

	FinishTime *int32 `type:"int32" json:",omitempty"`

	JobName *string `type:"string" json:",omitempty"`

	Log *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	ResourceClaimed *ResourceClaimedForListTasksOutput `type:"structure" json:"resourceClaimed,omitempty"`

	ResourceUsed *ResourceUsedForListTasksOutput `type:"structure" json:"resourceUsed,omitempty"`

	RunID *string `type:"string" json:",omitempty"`

	StartTime *int32 `type:"int32" json:",omitempty"`

	Status *string `type:"string" json:",omitempty" enum:"EnumOfStatusForListTasksOutput"`

	Stderr *string `type:"string" json:",omitempty"`

	Stdout *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ItemForListTasksOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ItemForListTasksOutput) GoString() string {
	return s.String()
}

// SetDuration sets the Duration field's value.
func (s *ItemForListTasksOutput) SetDuration(v int32) *ItemForListTasksOutput {
	s.Duration = &v
	return s
}

// SetExecuteDuration sets the ExecuteDuration field's value.
func (s *ItemForListTasksOutput) SetExecuteDuration(v int32) *ItemForListTasksOutput {
	s.ExecuteDuration = &v
	return s
}

// SetFinishTime sets the FinishTime field's value.
func (s *ItemForListTasksOutput) SetFinishTime(v int32) *ItemForListTasksOutput {
	s.FinishTime = &v
	return s
}

// SetJobName sets the JobName field's value.
func (s *ItemForListTasksOutput) SetJobName(v string) *ItemForListTasksOutput {
	s.JobName = &v
	return s
}

// SetLog sets the Log field's value.
func (s *ItemForListTasksOutput) SetLog(v string) *ItemForListTasksOutput {
	s.Log = &v
	return s
}

// SetName sets the Name field's value.
func (s *ItemForListTasksOutput) SetName(v string) *ItemForListTasksOutput {
	s.Name = &v
	return s
}

// SetResourceClaimed sets the ResourceClaimed field's value.
func (s *ItemForListTasksOutput) SetResourceClaimed(v *ResourceClaimedForListTasksOutput) *ItemForListTasksOutput {
	s.ResourceClaimed = v
	return s
}

// SetResourceUsed sets the ResourceUsed field's value.
func (s *ItemForListTasksOutput) SetResourceUsed(v *ResourceUsedForListTasksOutput) *ItemForListTasksOutput {
	s.ResourceUsed = v
	return s
}

// SetRunID sets the RunID field's value.
func (s *ItemForListTasksOutput) SetRunID(v string) *ItemForListTasksOutput {
	s.RunID = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ItemForListTasksOutput) SetStartTime(v int32) *ItemForListTasksOutput {
	s.StartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ItemForListTasksOutput) SetStatus(v string) *ItemForListTasksOutput {
	s.Status = &v
	return s
}

// SetStderr sets the Stderr field's value.
func (s *ItemForListTasksOutput) SetStderr(v string) *ItemForListTasksOutput {
	s.Stderr = &v
	return s
}

// SetStdout sets the Stdout field's value.
func (s *ItemForListTasksOutput) SetStdout(v string) *ItemForListTasksOutput {
	s.Stdout = &v
	return s
}

type ListTasksInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	PageNumber *int32 `min:"1" type:"int32" json:",omitempty"`

	PageSize *int32 `max:"100" type:"int32" json:",omitempty"`

	// RunID is a required field
	RunID *string `type:"string" json:",omitempty" required:"true"`

	// WorkspaceID is a required field
	WorkspaceID *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s ListTasksInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTasksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTasksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTasksInput"}
	if s.PageNumber != nil && *s.PageNumber < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageNumber", 1))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}
	if s.RunID == nil {
		invalidParams.Add(request.NewErrParamRequired("RunID"))
	}
	if s.WorkspaceID == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListTasksInput) SetPageNumber(v int32) *ListTasksInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListTasksInput) SetPageSize(v int32) *ListTasksInput {
	s.PageSize = &v
	return s
}

// SetRunID sets the RunID field's value.
func (s *ListTasksInput) SetRunID(v string) *ListTasksInput {
	s.RunID = &v
	return s
}

// SetWorkspaceID sets the WorkspaceID field's value.
func (s *ListTasksInput) SetWorkspaceID(v string) *ListTasksInput {
	s.WorkspaceID = &v
	return s
}

type ListTasksOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Items []*ItemForListTasksOutput `type:"list" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListTasksOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTasksOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListTasksOutput) SetItems(v []*ItemForListTasksOutput) *ListTasksOutput {
	s.Items = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListTasksOutput) SetPageNumber(v int32) *ListTasksOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListTasksOutput) SetPageSize(v int32) *ListTasksOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListTasksOutput) SetTotalCount(v int32) *ListTasksOutput {
	s.TotalCount = &v
	return s
}

type ResourceClaimedForListTasksOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CPUCore *float64 `type:"double" json:",omitempty"`

	GPUGiB *float64 `type:"double" json:",omitempty"`

	MemoryGiB *float64 `type:"double" json:",omitempty"`

	StorageGiB *float64 `type:"double" json:",omitempty"`
}

// String returns the string representation
func (s ResourceClaimedForListTasksOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceClaimedForListTasksOutput) GoString() string {
	return s.String()
}

// SetCPUCore sets the CPUCore field's value.
func (s *ResourceClaimedForListTasksOutput) SetCPUCore(v float64) *ResourceClaimedForListTasksOutput {
	s.CPUCore = &v
	return s
}

// SetGPUGiB sets the GPUGiB field's value.
func (s *ResourceClaimedForListTasksOutput) SetGPUGiB(v float64) *ResourceClaimedForListTasksOutput {
	s.GPUGiB = &v
	return s
}

// SetMemoryGiB sets the MemoryGiB field's value.
func (s *ResourceClaimedForListTasksOutput) SetMemoryGiB(v float64) *ResourceClaimedForListTasksOutput {
	s.MemoryGiB = &v
	return s
}

// SetStorageGiB sets the StorageGiB field's value.
func (s *ResourceClaimedForListTasksOutput) SetStorageGiB(v float64) *ResourceClaimedForListTasksOutput {
	s.StorageGiB = &v
	return s
}

type ResourceUsedForListTasksOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CPUCore *float64 `type:"double" json:",omitempty"`

	GPUGiB *float64 `type:"double" json:",omitempty"`

	MemoryGiB *float64 `type:"double" json:",omitempty"`

	StorageGiB *float64 `type:"double" json:",omitempty"`
}

// String returns the string representation
func (s ResourceUsedForListTasksOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceUsedForListTasksOutput) GoString() string {
	return s.String()
}

// SetCPUCore sets the CPUCore field's value.
func (s *ResourceUsedForListTasksOutput) SetCPUCore(v float64) *ResourceUsedForListTasksOutput {
	s.CPUCore = &v
	return s
}

// SetGPUGiB sets the GPUGiB field's value.
func (s *ResourceUsedForListTasksOutput) SetGPUGiB(v float64) *ResourceUsedForListTasksOutput {
	s.GPUGiB = &v
	return s
}

// SetMemoryGiB sets the MemoryGiB field's value.
func (s *ResourceUsedForListTasksOutput) SetMemoryGiB(v float64) *ResourceUsedForListTasksOutput {
	s.MemoryGiB = &v
	return s
}

// SetStorageGiB sets the StorageGiB field's value.
func (s *ResourceUsedForListTasksOutput) SetStorageGiB(v float64) *ResourceUsedForListTasksOutput {
	s.StorageGiB = &v
	return s
}

const (
	// EnumOfStatusForListTasksOutputSucceeded is a EnumOfStatusForListTasksOutput enum value
	EnumOfStatusForListTasksOutputSucceeded = "Succeeded"

	// EnumOfStatusForListTasksOutputFailed is a EnumOfStatusForListTasksOutput enum value
	EnumOfStatusForListTasksOutputFailed = "Failed"

	// EnumOfStatusForListTasksOutputRunning is a EnumOfStatusForListTasksOutput enum value
	EnumOfStatusForListTasksOutputRunning = "Running"

	// EnumOfStatusForListTasksOutputQueued is a EnumOfStatusForListTasksOutput enum value
	EnumOfStatusForListTasksOutputQueued = "Queued"

	// EnumOfStatusForListTasksOutputInitializing is a EnumOfStatusForListTasksOutput enum value
	EnumOfStatusForListTasksOutputInitializing = "Initializing"

	// EnumOfStatusForListTasksOutputCancelled is a EnumOfStatusForListTasksOutput enum value
	EnumOfStatusForListTasksOutputCancelled = "Cancelled"
)
