// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package aiotvideo20231001

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCloudControlCommon = "CloudControl"

// CloudControlCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CloudControlCommon operation. The "output" return
// value will be populated with the CloudControlCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CloudControlCommon Request to send the API call to the service.
// the "output" return value is not valid until after CloudControlCommon Send returns without error.
//
// See CloudControlCommon for more information on using the CloudControlCommon
// API call, and error handling.
//
//    // Example sending a request using the CloudControlCommonRequest method.
//    req, resp := client.CloudControlCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *AIOTVIDEO20231001) CloudControlCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCloudControlCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CloudControlCommon API operation for AIOTVIDEO20231001.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for AIOTVIDEO20231001's
// API operation CloudControlCommon for usage and error information.
func (c *AIOTVIDEO20231001) CloudControlCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CloudControlCommonRequest(input)
	return out, req.Send()
}

// CloudControlCommonWithContext is the same as CloudControlCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CloudControlCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AIOTVIDEO20231001) CloudControlCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CloudControlCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCloudControl = "CloudControl"

// CloudControlRequest generates a "volcengine/request.Request" representing the
// client's request for the CloudControl operation. The "output" return
// value will be populated with the CloudControlCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CloudControlCommon Request to send the API call to the service.
// the "output" return value is not valid until after CloudControlCommon Send returns without error.
//
// See CloudControl for more information on using the CloudControl
// API call, and error handling.
//
//    // Example sending a request using the CloudControlRequest method.
//    req, resp := client.CloudControlRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *AIOTVIDEO20231001) CloudControlRequest(input *CloudControlInput) (req *request.Request, output *CloudControlOutput) {
	op := &request.Operation{
		Name:       opCloudControl,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CloudControlInput{}
	}

	output = &CloudControlOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CloudControl API operation for AIOTVIDEO20231001.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for AIOTVIDEO20231001's
// API operation CloudControl for usage and error information.
func (c *AIOTVIDEO20231001) CloudControl(input *CloudControlInput) (*CloudControlOutput, error) {
	req, out := c.CloudControlRequest(input)
	return out, req.Send()
}

// CloudControlWithContext is the same as CloudControl with the addition of
// the ability to pass a context and additional request options.
//
// See CloudControl for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AIOTVIDEO20231001) CloudControlWithContext(ctx volcengine.Context, input *CloudControlInput, opts ...request.Option) (*CloudControlOutput, error) {
	req, out := c.CloudControlRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CloudControlInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// Action is a required field
	Action *string `type:"string" json:",omitempty" required:"true"`

	// Cmd is a required field
	Cmd *string `type:"string" json:",omitempty" required:"true"`

	// Para is a required field
	Para *int32 `type:"int32" json:",omitempty" required:"true"`

	// StreamID is a required field
	StreamID *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s CloudControlInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudControlInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CloudControlInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CloudControlInput"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Cmd == nil {
		invalidParams.Add(request.NewErrParamRequired("Cmd"))
	}
	if s.Para == nil {
		invalidParams.Add(request.NewErrParamRequired("Para"))
	}
	if s.StreamID == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *CloudControlInput) SetAction(v string) *CloudControlInput {
	s.Action = &v
	return s
}

// SetCmd sets the Cmd field's value.
func (s *CloudControlInput) SetCmd(v string) *CloudControlInput {
	s.Cmd = &v
	return s
}

// SetPara sets the Para field's value.
func (s *CloudControlInput) SetPara(v int32) *CloudControlInput {
	s.Para = &v
	return s
}

// SetStreamID sets the StreamID field's value.
func (s *CloudControlInput) SetStreamID(v string) *CloudControlInput {
	s.StreamID = &v
	return s
}

type CloudControlOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s CloudControlOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudControlOutput) GoString() string {
	return s.String()
}
