// Example Code generated by Beijing Volcanoengine Technology.
package ecsexample

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/service/ecs"
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/credentials"
	"github.com/volcengine/volcengine-go-sdk/volcengine/session"
)

func CopyImage() {
	ak, sk, region := "Your AK", "Your SK", "cn-beijing"
	config := volcengine.NewConfig().
		WithRegion(region).
		WithCredentials(credentials.NewStaticCredentials(ak, sk, ""))
	sess, err := session.NewSession(config)
	if err != nil {
		panic(err)
	}
	svc := ecs.New(sess)
	copyImageInput := &ecs.CopyImageInput{
		DestinationRegion: volcengine.String("cn-changsha-sdv"),
		ImageId:           volcengine.String("image-4431h3l7hl31a0******"),
		ImageName:         volcengine.String("testlyb1"),
	}

	resp, err := svc.CopyImage(copyImageInput)
	if err != nil {
		panic(err)
	}
	fmt.Println(resp)
}
