*** Settings ***
Documentation  This resource provides any keywords related to the Harbor private registry appliance
Resource  ../../resources/Util.robot

*** Variables ***

*** Keywords ***
Disable Scan Schedule
    Retry Double Keywords When Error  Retry Element Click  ${vulnerability_edit_btn}  Retry Wait Until Page Not Contains Element  ${vulnerability_edit_btn}
    Retry Element Click  ${vulnerability_dropdown_list}
    Retry Element Click  ${vulnerability_dropdown_list_item_none}
    Retry Double Keywords When Error  Retry Element Click  ${vulnerability_save_btn}  Retry Wait Until Page Not Contains Element  ${vulnerability_save_btn}

Set Scan Schedule
    [Arguments]  ${type}  ${value}=${null}
    Retry Double Keywords When Error  Retry Element Click  ${vulnerability_edit_btn}  Retry Wait Until Page Not Contains Element  ${vulnerability_edit_btn}
    Retry Double Keywords When Error  Retry Element Click  ${vulnerability_dropdown_list}  Retry Element Click  //select[@id='selectPolicy']//option[contains(.,'${type}')]
    Run Keyword If  '${type}'=='Custom'  Retry Text Input  ${targetCron_id}  ${value}
    Retry Double Keywords When Error  Retry Element Click  ${vulnerability_save_btn}  Retry Wait Until Page Not Contains Element  ${vulnerability_save_btn}

Trigger Scan Now And Wait Until The Result Appears
    Retry Element Click  xpath=${scan_now_button}
    Retry Keyword N Times When Error  11  Wait Until Element Is Visible And Enabled  ${scan_now_button}

Switch To Vulnerability Page
    Retry Element Click  xpath=//clr-main-container//clr-vertical-nav//a[contains(.,'Interrogation')]
    Retry Element Click  xpath=//app-interrogation-services//a[contains(.,'Vulnerability')]
    Retry Wait Element  ${scan_now_button}

Set Vulnerabilty Serverity
    [Arguments]  ${level}
    Goto Project Config
    #enable first
    Retry Element Click  ${project_config_prevent_vulenrability_checkbox_label}
    Checkbox Should Be Selected  //project-detail//clr-checkbox-wrapper//input[@name='prevent-vulenrability-image-input']
    Retry Element Click  //project-detail//select
    #wait for dropdown popup
    Select From List By Index  //project-detail//select  ${level}
    Retry Element Click  ${project_config_save_btn}

Scan Is Disabled
    Retry Wait Until Page Contains Element  //button[@id='scan-btn' and @disabled='']

Scan Repo
    [Arguments]  ${tagname}  ${status}
    Retry Element Click  //clr-dg-row[contains(.,'${tagname}')]//label[contains(@class,'clr-control-label')]
    Retry Element Click  //button[@id='scan-btn']
    Run Keyword If  '${status}' == 'Succeed'  Wait Until Element Is Visible  //hbr-vulnerability-bar//hbr-result-tip-histogram  300
    Run Keyword If  '${status}' == 'Fail'  Wait Until Element Is Visible  //hbr-vulnerability-bar//a  300

Scan Result Should Display In List Row
    [Arguments]  ${tagname}  ${is_no_vulerabilty}=${false}
    Run Keyword If  ${is_no_vulerabilty}==${true}  Retry Wait Until Page Contains Element  //artifact-list-tab//clr-dg-row[contains(.,'No vulnerability') and contains(.,'${tagname}')]//clr-dg-cell//clr-tooltip
    ...  ELSE  Retry Wait Until Page Contains Element  //artifact-list-tab//clr-dg-row[contains(.,'Total') and contains(.,'Fixable') and contains(.,'${tagname}')]//clr-dg-cell//clr-tooltip

Enable Scan On Push
    Checkbox Should Not Be Selected  //clr-checkbox-wrapper[@id='scan-image-on-push-wrapper']//input
    Retry Element Click  //clr-checkbox-wrapper[@id='scan-image-on-push-wrapper']//label[contains(@class,'clr-control-label')]
    Checkbox Should Be Selected  //clr-checkbox-wrapper[@id='scan-image-on-push-wrapper']//input
    Retry Element Click  ${project_config_save_btn}

Generate Repo SBOM
    [Arguments]  ${tagname}  ${status}
    Retry Element Click  //clr-dg-row[contains(.,'${tagname}')]//label[contains(@class,'clr-control-label')]
    Retry Element Click  //button[@id='generate-sbom-btn']
    Run Keyword If  '${status}' == 'Succeed'  Wait Until Element Is Visible  //a[@title='SBOM details']  300

Checkout And Review SBOM Details
    [Arguments]  ${tagname}
    Retry Element Click  //clr-dg-row[contains(.,'${tagname}')]//a[@title='SBOM details']
    # Download SBOM file
    Retry Element Click  //button[@id='sbom-btn']
    ${sbom_artifact_short_sha256}=  Get Text  //span[@class='margin-left-10px']
    ${sbom_filename_raw}=  Get Text  //clr-dg-cell[contains(text(),'${sbom_artifact_short_sha256}')]
    ${sbom_filename}=  Replace String  ${sbom_filename_raw}  :  _  count=-1
    ${sbom_filename}=  Replace String  ${sbom_filename}  /  _  count=-1
    ${sbom_json_path}=  Set Variable  ${download_directory}/${sbom_filename}.json
    Retry File Should Exist  ${sbom_json_path}
    # Load the downloaded SBOM json file and verify the first N package records
    ${sbom_json_content}=  Load Json From File  ${sbom_json_path}
    ${items}=  Get Value From JSON  ${sbom_json_content}  packages
    ${items_length}=  Get Length  ${items}
    ${first_n_records}=  Evaluate  min(5, ${items_length})
    FOR  ${idx}  IN RANGE  1  ${first_n_records}
        ${item}=  Get From List  ${items}  ${idx}
        Wait Until Element Is Visible  //clr-dg-cell[normalize-space()='${item.name}']
        Wait Until Element Is Visible  //clr-dg-cell[normalize-space()='${item.versionInfo}']
        Wait Until Element Is Visible  //clr-dg-cell[normalize-space()='${item.licenseConcluded}']
    END

Enable Generating SBOM On Push
    Checkbox Should Not Be Selected  //clr-checkbox-wrapper[@id='generate-sbom-on-push-wrapper']//input
    Retry Element Click  //clr-checkbox-wrapper[@id='generate-sbom-on-push-wrapper']//label[contains(@class,'clr-control-label')]
    Checkbox Should Be Selected  //clr-checkbox-wrapper[@id='generate-sbom-on-push-wrapper']//input
    Retry Element Click  ${project_config_save_btn}

Vulnerability Not Ready Project Hint
    Sleep  2
    ${element}=  Set Variable  xpath=//span[contains(@class, 'db-status-warning')]
    Wait Until Element Is Visible And Enabled  ${element}

Switch To Scanners Page
    Retry Element Click  xpath=//clr-main-container//clr-vertical-nav//a[contains(.,'Interrogation')]
    Retry Element Click  xpath=//app-interrogation-services//a[normalize-space()='Scanners']
    Retry Wait Until Page Contains Element  ${set_default_scanner}

Should Display The Default Trivy Scanner
    Retry Wait Until Page Contains Element  //clr-datagrid//clr-dg-row//clr-dg-cell[contains(.,'Trivy')]//span[contains(.,'Default')]

Trivy Is Immutable Scanner
    Retry Element Click  //clr-dg-row[contains(.,'Trivy')]//clr-radio-wrapper/label[contains(@class,'clr-control-label')]
    Retry Double Keywords When Error  Retry Element Click  ${scanner_action_xpath}  Retry Wait Until Page Contains Element  ${delete_scanner_action_xpath}
    Retry Double Keywords When Error  Retry Element Click  ${delete_scanner_action_xpath}  Retry Wait Until Page Contains Element  ${delete_scanner_confirm_btn}
    Retry Double Keywords When Error  Retry Element Click  ${delete_scanner_confirm_btn}  Retry Wait Until Page Contains Element  ${immutable_trivy_msg_xpath}

Set Default Scanner
    [Arguments]  ${scanner_name}
    Retry Element Click  //clr-dg-row[contains(.,'${scanner_name}')]//clr-radio-wrapper/label[contains(@class,'clr-control-label')]
    Retry Double Keywords When Error  Retry Element Click  ${scanner_set_default}  Retry Wait Until Page Contains Element  ${scanner_set_default_success_xpath}

Check Listed In CVE Allowlist
    [Arguments]  ${project_name}  ${image}  ${tag}  ${cve_id}  ${is_in}=Yes
    Go Into Repo  ${project_name}  ${image}
    Go Into Artifact   ${tag}

    Scroll Element Into View  //clr-dg-row[contains(.,'${cve_id}')]
    ${text}=  Get Text  //clr-dg-row[contains(.,'${cve_id}')]//clr-dg-cell[8]
    Capture Page Screenshot

    Log All  is_in_allow_list:${text}
    Should Be Equal As Strings  '${text}'  '${is_in}'

Scan All Artifact
    Switch To Vulnerability Page
    Retry Element Click  ${scan_now_button}

Stop Scan All Artifact
    Retry Element Click  ${stop_scan_button}

Check Scan All Artifact Job Status Is Stopped
    Wait Until Element Is Visible  ${stopped_icon}
    ${stopped_total}=  Get Text  ${stopped_icon}
    Should Be True  ${stopped_total} > 0

Filter Scanner By Name
    [Arguments]  ${name}
    Retry Button Click  (//clr-dg-column//button)[2]
    Retry Text Input  //input[@name='search']  ${name}
    Retry Button Click  (//clr-dg-column//button)[2]

Filter Scanner By Endpoint
    [Arguments]  ${endpoint}
    Retry Button Click  (//clr-dg-column//button)[5]
    Retry Text Input  //input[@name='search']  ${endpoint}
    Retry Button Click  (//clr-dg-column//button)[5]

Select Scanner Auth Mode
    [Arguments]  ${auth}
    Retry Element Click  ${scanner_auth_select}
    Retry Element Click  ${scanner_auth_select}//option[contains(text(),'${auth}')]

Add A New Scanner
    [Arguments]  ${name}  ${endpoint}  ${auth}  ${desc}=${null}  ${skip_cert_cerification}=${false}  ${internal_registry_address}=${false}  ${username}=${null}  ${password}=${null}  ${token}=${null}  ${api_key}=${null}  ${apikey}=${null}
    Retry Button Click  ${add_scanner_btn}
    Retry Text Input  ${scanner_name_input}  ${name}
    Run Keyword If  '${desc}'!='${null}'  Retry Text Input  ${scanner_desc_input}  ${desc}
    Retry Text Input  ${scanner_endpoint_input}  ${endpoint}
    Select Scanner Auth Mode  ${auth}
    IF  '${auth}'=='Basic'
        Retry Text Input  ${scanner_username_input}  ${username}
        Retry Text Input  ${scanner_password_input}  ${password}
    ELSE IF  '${auth}'=='Bearer'
        Retry Text Input  ${scanner_token_input}  ${token}
    ELSE IF  '${auth}'=='APIKey'
        Retry Text Input  ${scanner_apikey_input}  ${apikey}
    END
    Run Keyword If  '${skip_cert_cerification}'==${true}  Retry Element Click  ${scanner_skip_cert_checkbox}
    Run Keyword If  '${internal_registry_address}'==${true}  Retry Element Click  ${add_scanner_internal_registry_checkbox}
    Retry Double Keywords When Error  Retry Button Click  ${scanner_test_connection_btn}  Wait Until Page Contains  Test passed
    Retry Double Keywords When Error  Retry Element Click  ${scanner_add_btn}  Wait Until Page Does Not Contain Element  ${scanner_add_btn}
    Retry Wait Until Page Contains Element  //clr-dg-row[.//span[text()='${name}'] and .//clr-dg-cell[text()='${endpoint}'] and .//span[text()='Healthy'] and .//span[text()='Enabled'] and .//clr-dg-cell[text()='${auth}']]

Update Scanner
    [Arguments]  ${origin_name}  ${name}  ${endpoint}  ${auth}  ${desc}=${null}  ${skip_cert_cerification}=${false}  ${internal_registry_address}=${false}  ${username}=${null}  ${password}=${null}  ${token}=${null}  ${api_key}=${null}
    Filter Scanner By Name  ${origin_name}
    Retry Element Click  //clr-dg-row[.//span[text()='${origin_name}']]//label[contains(@class,'clr-control-label')]
    Retry Double Keywords When Error  Retry Element Click  ${scanner_action_xpath}  Retry Element Click  ${edit_scanner_action_xpath}
    Retry Text Input  ${scanner_name_input}  ${name}
    Run Keyword If  '${desc}'!='${null}'  Retry Text Input  ${scanner_desc_input}  ${desc}
    Retry Text Input  ${scanner_endpoint_input}  ${endpoint}
    Select Scanner Auth Mode  ${auth}
    IF  '${auth}'=='Basic'
        Retry Text Input  ${scanner_username_input}  ${username}
        Retry Text Input  ${scanner_password_input}  ${password}
    ELSE IF  '${auth}'=='Bearer'
        Retry Text Input  ${scanner_token_input}  ${token}
    ELSE IF  '${auth}'=='APIKey'
        Retry Text Input  ${scanner_apikey_input}  ${api_key}
    END
    Run Keyword If  '${skip_cert_cerification}'==${true}  Retry Element Click  ${scanner_skip_cert_checkbox}
    Run Keyword If  '${internal_registry_address}'==${true}  Retry Element Click  ${add_scanner_internal_registry_checkbox}
    Retry Double Keywords When Error  Retry Element Click  ${scanner_save_btn}  Wait Until Page Does Not Contain Element  ${scanner_save_btn}
    Retry Wait Until Page Contains Element  //clr-dg-row[.//span[text()='${name}'] and .//clr-dg-cell[text()='${endpoint}'] and .//clr-dg-cell[text()='${auth}']]

Delete Scanner
    [Arguments]  ${name}
    Filter Scanner By Name  ${name}
    Retry Double Keywords When Error  Retry Element Click  //clr-dg-row[.//span[text()='${name}']]//label[contains(@class,'clr-control-label')]  Retry Element Click  ${scanner_action_xpath}
    Retry Double Keywords When Error  Retry Element Click  ${delete_scanner_action_xpath}  Retry Element Click  ${delete_scanner_confirm_btn}
    Reload Page
    Retry Double Keywords When Error  Filter Scanner By Name  ${name}  Retry Wait Until Page Contains  Can not find any scanner

Enable Or Deactivate Scanner
    [Arguments]  ${name}  ${action}
    Filter Scanner By Name  ${name}
    Retry Double Keywords When Error  Retry Element Click  //clr-dg-row[.//span[text()='${name}']]//label[contains(@class,'clr-control-label')]  Retry Element Click  ${scanner_action_xpath}
    Retry Element Click  //clr-dropdown-menu//span[text()='${action}']
    ${action}=  Set Variable  ${action[0].upper()}${action[1:].lower()}d
    Retry Wait Until Page Contains Element  //clr-dg-row[.//span[text()='${name}'] and .//span[text()='${action}']]

Set Scanner As Default
    [Arguments]  ${name}
    Retry Element Click  //clr-dg-row[.//span[text()='${name}']]//label[contains(@class,'clr-control-label')]
    Retry Double Keywords When Error  Retry Element Click  ${scanner_set_default_btn}  Retry Wait Element Visible  //clr-dg-row[.//span[text()='${name}'] and .//span[text()='Default']]
