// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package waf

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateDomainCommon = "CreateDomain"

// CreateDomainCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateDomainCommon operation. The "output" return
// value will be populated with the CreateDomainCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateDomainCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateDomainCommon Send returns without error.
//
// See CreateDomainCommon for more information on using the CreateDomainCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateDomainCommonRequest method.
//    req, resp := client.CreateDomainCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *WAF) CreateDomainCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateDomainCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateDomainCommon API operation for WAF.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for WAF's
// API operation CreateDomainCommon for usage and error information.
func (c *WAF) CreateDomainCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateDomainCommonRequest(input)
	return out, req.Send()
}

// CreateDomainCommonWithContext is the same as CreateDomainCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDomainCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) CreateDomainCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateDomainCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDomain = "CreateDomain"

// CreateDomainRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateDomain operation. The "output" return
// value will be populated with the CreateDomainCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateDomainCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateDomainCommon Send returns without error.
//
// See CreateDomain for more information on using the CreateDomain
// API call, and error handling.
//
//    // Example sending a request using the CreateDomainRequest method.
//    req, resp := client.CreateDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *WAF) CreateDomainRequest(input *CreateDomainInput) (req *request.Request, output *CreateDomainOutput) {
	op := &request.Operation{
		Name:       opCreateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDomainInput{}
	}

	output = &CreateDomainOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateDomain API operation for WAF.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for WAF's
// API operation CreateDomain for usage and error information.
func (c *WAF) CreateDomain(input *CreateDomainInput) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	return out, req.Send()
}

// CreateDomainWithContext is the same as CreateDomain with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDomain for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) CreateDomainWithContext(ctx volcengine.Context, input *CreateDomainInput, opts ...request.Option) (*CreateDomainOutput, error) {
	req, out := c.CreateDomainRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type APIForCreateDomainOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ApiEnable *int32 `type:"int32" json:",omitempty"`

	EnableAutoLearning *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s APIForCreateDomainOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s APIForCreateDomainOutput) GoString() string {
	return s.String()
}

// SetApiEnable sets the ApiEnable field's value.
func (s *APIForCreateDomainOutput) SetApiEnable(v int32) *APIForCreateDomainOutput {
	s.ApiEnable = &v
	return s
}

// SetEnableAutoLearning sets the EnableAutoLearning field's value.
func (s *APIForCreateDomainOutput) SetEnableAutoLearning(v int32) *APIForCreateDomainOutput {
	s.EnableAutoLearning = &v
	return s
}

type AutoCCForCreateDomainOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Action *string `type:"string" json:",omitempty"`

	AutoCCEnable *int32 `type:"int32" json:",omitempty"`

	DefenceLevel *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s AutoCCForCreateDomainOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoCCForCreateDomainOutput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *AutoCCForCreateDomainOutput) SetAction(v string) *AutoCCForCreateDomainOutput {
	s.Action = &v
	return s
}

// SetAutoCCEnable sets the AutoCCEnable field's value.
func (s *AutoCCForCreateDomainOutput) SetAutoCCEnable(v int32) *AutoCCForCreateDomainOutput {
	s.AutoCCEnable = &v
	return s
}

// SetDefenceLevel sets the DefenceLevel field's value.
func (s *AutoCCForCreateDomainOutput) SetDefenceLevel(v string) *AutoCCForCreateDomainOutput {
	s.DefenceLevel = &v
	return s
}

type BackendForCreateDomainInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	IP *string `type:"string" json:",omitempty"`

	Port *int32 `type:"int32" json:",omitempty"`

	Protocol *string `type:"string" json:",omitempty"`

	Weight *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s BackendForCreateDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BackendForCreateDomainInput) GoString() string {
	return s.String()
}

// SetIP sets the IP field's value.
func (s *BackendForCreateDomainInput) SetIP(v string) *BackendForCreateDomainInput {
	s.IP = &v
	return s
}

// SetPort sets the Port field's value.
func (s *BackendForCreateDomainInput) SetPort(v int32) *BackendForCreateDomainInput {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *BackendForCreateDomainInput) SetProtocol(v string) *BackendForCreateDomainInput {
	s.Protocol = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *BackendForCreateDomainInput) SetWeight(v int32) *BackendForCreateDomainInput {
	s.Weight = &v
	return s
}

type BackendGroupForCreateDomainInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessPort []*int32 `type:"list" json:",omitempty"`

	Backends []*BackendForCreateDomainInput `type:"list" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s BackendGroupForCreateDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BackendGroupForCreateDomainInput) GoString() string {
	return s.String()
}

// SetAccessPort sets the AccessPort field's value.
func (s *BackendGroupForCreateDomainInput) SetAccessPort(v []*int32) *BackendGroupForCreateDomainInput {
	s.AccessPort = v
	return s
}

// SetBackends sets the Backends field's value.
func (s *BackendGroupForCreateDomainInput) SetBackends(v []*BackendForCreateDomainInput) *BackendGroupForCreateDomainInput {
	s.Backends = v
	return s
}

// SetName sets the Name field's value.
func (s *BackendGroupForCreateDomainInput) SetName(v string) *BackendGroupForCreateDomainInput {
	s.Name = &v
	return s
}

type BotSequenceForCreateDomainOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BotSequenceDefaultAction *int32 `type:"int32" json:",omitempty"`

	BotSequenceEnable *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s BotSequenceForCreateDomainOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BotSequenceForCreateDomainOutput) GoString() string {
	return s.String()
}

// SetBotSequenceDefaultAction sets the BotSequenceDefaultAction field's value.
func (s *BotSequenceForCreateDomainOutput) SetBotSequenceDefaultAction(v int32) *BotSequenceForCreateDomainOutput {
	s.BotSequenceDefaultAction = &v
	return s
}

// SetBotSequenceEnable sets the BotSequenceEnable field's value.
func (s *BotSequenceForCreateDomainOutput) SetBotSequenceEnable(v int32) *BotSequenceForCreateDomainOutput {
	s.BotSequenceEnable = &v
	return s
}

type CloudAccessConfigForCreateDomainInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessProtocol *string `type:"string" json:",omitempty"`

	DefenceMode *int32 `type:"int32" json:",omitempty"`

	InstanceID *string `type:"string" json:",omitempty"`

	InstanceName *string `type:"string" json:",omitempty"`

	ListenerID *string `type:"string" json:",omitempty"`

	LostAssociationFromALB *int32 `type:"int32" json:",omitempty"`

	Port *string `type:"string" json:",omitempty"`

	Protocol *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CloudAccessConfigForCreateDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CloudAccessConfigForCreateDomainInput) GoString() string {
	return s.String()
}

// SetAccessProtocol sets the AccessProtocol field's value.
func (s *CloudAccessConfigForCreateDomainInput) SetAccessProtocol(v string) *CloudAccessConfigForCreateDomainInput {
	s.AccessProtocol = &v
	return s
}

// SetDefenceMode sets the DefenceMode field's value.
func (s *CloudAccessConfigForCreateDomainInput) SetDefenceMode(v int32) *CloudAccessConfigForCreateDomainInput {
	s.DefenceMode = &v
	return s
}

// SetInstanceID sets the InstanceID field's value.
func (s *CloudAccessConfigForCreateDomainInput) SetInstanceID(v string) *CloudAccessConfigForCreateDomainInput {
	s.InstanceID = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *CloudAccessConfigForCreateDomainInput) SetInstanceName(v string) *CloudAccessConfigForCreateDomainInput {
	s.InstanceName = &v
	return s
}

// SetListenerID sets the ListenerID field's value.
func (s *CloudAccessConfigForCreateDomainInput) SetListenerID(v string) *CloudAccessConfigForCreateDomainInput {
	s.ListenerID = &v
	return s
}

// SetLostAssociationFromALB sets the LostAssociationFromALB field's value.
func (s *CloudAccessConfigForCreateDomainInput) SetLostAssociationFromALB(v int32) *CloudAccessConfigForCreateDomainInput {
	s.LostAssociationFromALB = &v
	return s
}

// SetPort sets the Port field's value.
func (s *CloudAccessConfigForCreateDomainInput) SetPort(v string) *CloudAccessConfigForCreateDomainInput {
	s.Port = &v
	return s
}

// SetProtocol sets the Protocol field's value.
func (s *CloudAccessConfigForCreateDomainInput) SetProtocol(v string) *CloudAccessConfigForCreateDomainInput {
	s.Protocol = &v
	return s
}

type CreateDomainInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// AccessMode is a required field
	AccessMode *int32 `type:"int32" json:",omitempty" required:"true"`

	BackendGroups []*BackendGroupForCreateDomainInput `type:"list" json:",omitempty"`

	CertificateID *int32 `type:"int32" json:",omitempty"`

	CertificatePlatform *string `type:"string" json:",omitempty"`

	ClientIPLocation *int32 `type:"int32" json:",omitempty"`

	ClientMaxBodySize *int32 `type:"int32" json:",omitempty"`

	CloudAccessConfig []*CloudAccessConfigForCreateDomainInput `type:"list" json:",omitempty"`

	CustomHeader []*string `type:"list" json:",omitempty"`

	CustomSNI *string `type:"string" json:",omitempty"`

	// Domain is a required field
	Domain *string `type:"string" json:",omitempty" required:"true"`

	EnableCustomRedirect *int32 `type:"int32" json:",omitempty"`

	EnableHTTP2 *int32 `type:"int32" json:",omitempty"`

	EnableIPv6 *int32 `type:"int32" json:",omitempty"`

	EnableSNI *int32 `type:"int32" json:",omitempty"`

	KeepAliveRequest *int32 `type:"int32" json:",omitempty"`

	KeepAliveTimeOut *int32 `type:"int32" json:",omitempty"`

	LBAlgorithm *string `type:"string" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	ProtocolFollow *int32 `type:"int32" json:",omitempty"`

	ProtocolPorts *ProtocolPortsForCreateDomainInput `type:"structure" json:",omitempty"`

	Protocols []*string `type:"list" json:",omitempty"`

	ProxyConfig *int32 `type:"int32" json:",omitempty"`

	ProxyConnectTimeOut *int32 `type:"int32" json:",omitempty"`

	ProxyKeepAlive *int32 `type:"int32" json:",omitempty"`

	ProxyKeepAliveTimeOut *int32 `type:"int32" json:",omitempty"`

	ProxyReadTimeOut *int32 `type:"int32" json:",omitempty"`

	ProxyRetry *int32 `type:"int32" json:",omitempty"`

	ProxyWriteTimeOut *int32 `type:"int32" json:",omitempty"`

	PublicRealServer *int32 `type:"int32" json:",omitempty"`

	RedirectHTTPS *bool `type:"boolean" json:",omitempty"`

	// Region is a required field
	Region *string `type:"string" json:",omitempty" required:"true"`

	SSLCiphers []*string `type:"list" json:",omitempty"`

	SSLProtocols []*string `type:"list" json:",omitempty"`

	TLSEnable *int32 `type:"int32" json:",omitempty"`

	TLSFieldsConfig *TLSFieldsConfigForCreateDomainInput `type:"structure" json:",omitempty"`

	VolcCertificateID *string `type:"string" json:",omitempty"`

	VpcID *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDomainInput"}
	if s.AccessMode == nil {
		invalidParams.Add(request.NewErrParamRequired("AccessMode"))
	}
	if s.Domain == nil {
		invalidParams.Add(request.NewErrParamRequired("Domain"))
	}
	if s.Region == nil {
		invalidParams.Add(request.NewErrParamRequired("Region"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessMode sets the AccessMode field's value.
func (s *CreateDomainInput) SetAccessMode(v int32) *CreateDomainInput {
	s.AccessMode = &v
	return s
}

// SetBackendGroups sets the BackendGroups field's value.
func (s *CreateDomainInput) SetBackendGroups(v []*BackendGroupForCreateDomainInput) *CreateDomainInput {
	s.BackendGroups = v
	return s
}

// SetCertificateID sets the CertificateID field's value.
func (s *CreateDomainInput) SetCertificateID(v int32) *CreateDomainInput {
	s.CertificateID = &v
	return s
}

// SetCertificatePlatform sets the CertificatePlatform field's value.
func (s *CreateDomainInput) SetCertificatePlatform(v string) *CreateDomainInput {
	s.CertificatePlatform = &v
	return s
}

// SetClientIPLocation sets the ClientIPLocation field's value.
func (s *CreateDomainInput) SetClientIPLocation(v int32) *CreateDomainInput {
	s.ClientIPLocation = &v
	return s
}

// SetClientMaxBodySize sets the ClientMaxBodySize field's value.
func (s *CreateDomainInput) SetClientMaxBodySize(v int32) *CreateDomainInput {
	s.ClientMaxBodySize = &v
	return s
}

// SetCloudAccessConfig sets the CloudAccessConfig field's value.
func (s *CreateDomainInput) SetCloudAccessConfig(v []*CloudAccessConfigForCreateDomainInput) *CreateDomainInput {
	s.CloudAccessConfig = v
	return s
}

// SetCustomHeader sets the CustomHeader field's value.
func (s *CreateDomainInput) SetCustomHeader(v []*string) *CreateDomainInput {
	s.CustomHeader = v
	return s
}

// SetCustomSNI sets the CustomSNI field's value.
func (s *CreateDomainInput) SetCustomSNI(v string) *CreateDomainInput {
	s.CustomSNI = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *CreateDomainInput) SetDomain(v string) *CreateDomainInput {
	s.Domain = &v
	return s
}

// SetEnableCustomRedirect sets the EnableCustomRedirect field's value.
func (s *CreateDomainInput) SetEnableCustomRedirect(v int32) *CreateDomainInput {
	s.EnableCustomRedirect = &v
	return s
}

// SetEnableHTTP2 sets the EnableHTTP2 field's value.
func (s *CreateDomainInput) SetEnableHTTP2(v int32) *CreateDomainInput {
	s.EnableHTTP2 = &v
	return s
}

// SetEnableIPv6 sets the EnableIPv6 field's value.
func (s *CreateDomainInput) SetEnableIPv6(v int32) *CreateDomainInput {
	s.EnableIPv6 = &v
	return s
}

// SetEnableSNI sets the EnableSNI field's value.
func (s *CreateDomainInput) SetEnableSNI(v int32) *CreateDomainInput {
	s.EnableSNI = &v
	return s
}

// SetKeepAliveRequest sets the KeepAliveRequest field's value.
func (s *CreateDomainInput) SetKeepAliveRequest(v int32) *CreateDomainInput {
	s.KeepAliveRequest = &v
	return s
}

// SetKeepAliveTimeOut sets the KeepAliveTimeOut field's value.
func (s *CreateDomainInput) SetKeepAliveTimeOut(v int32) *CreateDomainInput {
	s.KeepAliveTimeOut = &v
	return s
}

// SetLBAlgorithm sets the LBAlgorithm field's value.
func (s *CreateDomainInput) SetLBAlgorithm(v string) *CreateDomainInput {
	s.LBAlgorithm = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateDomainInput) SetProjectName(v string) *CreateDomainInput {
	s.ProjectName = &v
	return s
}

// SetProtocolFollow sets the ProtocolFollow field's value.
func (s *CreateDomainInput) SetProtocolFollow(v int32) *CreateDomainInput {
	s.ProtocolFollow = &v
	return s
}

// SetProtocolPorts sets the ProtocolPorts field's value.
func (s *CreateDomainInput) SetProtocolPorts(v *ProtocolPortsForCreateDomainInput) *CreateDomainInput {
	s.ProtocolPorts = v
	return s
}

// SetProtocols sets the Protocols field's value.
func (s *CreateDomainInput) SetProtocols(v []*string) *CreateDomainInput {
	s.Protocols = v
	return s
}

// SetProxyConfig sets the ProxyConfig field's value.
func (s *CreateDomainInput) SetProxyConfig(v int32) *CreateDomainInput {
	s.ProxyConfig = &v
	return s
}

// SetProxyConnectTimeOut sets the ProxyConnectTimeOut field's value.
func (s *CreateDomainInput) SetProxyConnectTimeOut(v int32) *CreateDomainInput {
	s.ProxyConnectTimeOut = &v
	return s
}

// SetProxyKeepAlive sets the ProxyKeepAlive field's value.
func (s *CreateDomainInput) SetProxyKeepAlive(v int32) *CreateDomainInput {
	s.ProxyKeepAlive = &v
	return s
}

// SetProxyKeepAliveTimeOut sets the ProxyKeepAliveTimeOut field's value.
func (s *CreateDomainInput) SetProxyKeepAliveTimeOut(v int32) *CreateDomainInput {
	s.ProxyKeepAliveTimeOut = &v
	return s
}

// SetProxyReadTimeOut sets the ProxyReadTimeOut field's value.
func (s *CreateDomainInput) SetProxyReadTimeOut(v int32) *CreateDomainInput {
	s.ProxyReadTimeOut = &v
	return s
}

// SetProxyRetry sets the ProxyRetry field's value.
func (s *CreateDomainInput) SetProxyRetry(v int32) *CreateDomainInput {
	s.ProxyRetry = &v
	return s
}

// SetProxyWriteTimeOut sets the ProxyWriteTimeOut field's value.
func (s *CreateDomainInput) SetProxyWriteTimeOut(v int32) *CreateDomainInput {
	s.ProxyWriteTimeOut = &v
	return s
}

// SetPublicRealServer sets the PublicRealServer field's value.
func (s *CreateDomainInput) SetPublicRealServer(v int32) *CreateDomainInput {
	s.PublicRealServer = &v
	return s
}

// SetRedirectHTTPS sets the RedirectHTTPS field's value.
func (s *CreateDomainInput) SetRedirectHTTPS(v bool) *CreateDomainInput {
	s.RedirectHTTPS = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *CreateDomainInput) SetRegion(v string) *CreateDomainInput {
	s.Region = &v
	return s
}

// SetSSLCiphers sets the SSLCiphers field's value.
func (s *CreateDomainInput) SetSSLCiphers(v []*string) *CreateDomainInput {
	s.SSLCiphers = v
	return s
}

// SetSSLProtocols sets the SSLProtocols field's value.
func (s *CreateDomainInput) SetSSLProtocols(v []*string) *CreateDomainInput {
	s.SSLProtocols = v
	return s
}

// SetTLSEnable sets the TLSEnable field's value.
func (s *CreateDomainInput) SetTLSEnable(v int32) *CreateDomainInput {
	s.TLSEnable = &v
	return s
}

// SetTLSFieldsConfig sets the TLSFieldsConfig field's value.
func (s *CreateDomainInput) SetTLSFieldsConfig(v *TLSFieldsConfigForCreateDomainInput) *CreateDomainInput {
	s.TLSFieldsConfig = v
	return s
}

// SetVolcCertificateID sets the VolcCertificateID field's value.
func (s *CreateDomainInput) SetVolcCertificateID(v string) *CreateDomainInput {
	s.VolcCertificateID = &v
	return s
}

// SetVpcID sets the VpcID field's value.
func (s *CreateDomainInput) SetVpcID(v string) *CreateDomainInput {
	s.VpcID = &v
	return s
}

type CreateDomainOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Cname *string `type:"string" json:",omitempty"`

	DefaultModuleQuickConf *DefaultModuleQuickConfForCreateDomainOutput `type:"structure" json:",omitempty"`

	Domain *string `type:"string" json:",omitempty"`

	ServerIps *string `type:"string" json:",omitempty"`

	SrcIps *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateDomainOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDomainOutput) GoString() string {
	return s.String()
}

// SetCname sets the Cname field's value.
func (s *CreateDomainOutput) SetCname(v string) *CreateDomainOutput {
	s.Cname = &v
	return s
}

// SetDefaultModuleQuickConf sets the DefaultModuleQuickConf field's value.
func (s *CreateDomainOutput) SetDefaultModuleQuickConf(v *DefaultModuleQuickConfForCreateDomainOutput) *CreateDomainOutput {
	s.DefaultModuleQuickConf = v
	return s
}

// SetDomain sets the Domain field's value.
func (s *CreateDomainOutput) SetDomain(v string) *CreateDomainOutput {
	s.Domain = &v
	return s
}

// SetServerIps sets the ServerIps field's value.
func (s *CreateDomainOutput) SetServerIps(v string) *CreateDomainOutput {
	s.ServerIps = &v
	return s
}

// SetSrcIps sets the SrcIps field's value.
func (s *CreateDomainOutput) SetSrcIps(v string) *CreateDomainOutput {
	s.SrcIps = &v
	return s
}

type DefaultModuleQuickConfForCreateDomainOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *int32 `type:"int32" json:",omitempty"`

	ModuleQuickConf *ModuleQuickConfForCreateDomainOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s DefaultModuleQuickConfForCreateDomainOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DefaultModuleQuickConfForCreateDomainOutput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *DefaultModuleQuickConfForCreateDomainOutput) SetEnable(v int32) *DefaultModuleQuickConfForCreateDomainOutput {
	s.Enable = &v
	return s
}

// SetModuleQuickConf sets the ModuleQuickConf field's value.
func (s *DefaultModuleQuickConfForCreateDomainOutput) SetModuleQuickConf(v *ModuleQuickConfForCreateDomainOutput) *DefaultModuleQuickConfForCreateDomainOutput {
	s.ModuleQuickConf = v
	return s
}

type HeadersConfigForCreateDomainInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *int32 `type:"int32" json:",omitempty"`

	ExcludedKeyList []*string `type:"list" json:",omitempty"`

	StatisticalKeyList []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s HeadersConfigForCreateDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HeadersConfigForCreateDomainInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *HeadersConfigForCreateDomainInput) SetEnable(v int32) *HeadersConfigForCreateDomainInput {
	s.Enable = &v
	return s
}

// SetExcludedKeyList sets the ExcludedKeyList field's value.
func (s *HeadersConfigForCreateDomainInput) SetExcludedKeyList(v []*string) *HeadersConfigForCreateDomainInput {
	s.ExcludedKeyList = v
	return s
}

// SetStatisticalKeyList sets the StatisticalKeyList field's value.
func (s *HeadersConfigForCreateDomainInput) SetStatisticalKeyList(v []*string) *HeadersConfigForCreateDomainInput {
	s.StatisticalKeyList = v
	return s
}

type ModuleQuickConfForCreateDomainOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	API *APIForCreateDomainOutput `type:"structure" json:",omitempty"`

	AutoCC *AutoCCForCreateDomainOutput `type:"structure" json:",omitempty"`

	BotSequence *BotSequenceForCreateDomainOutput `type:"structure" json:",omitempty"`

	SystemBot *SystemBotForCreateDomainOutput `type:"structure" json:",omitempty"`

	Vul *VulForCreateDomainOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ModuleQuickConfForCreateDomainOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModuleQuickConfForCreateDomainOutput) GoString() string {
	return s.String()
}

// SetAPI sets the API field's value.
func (s *ModuleQuickConfForCreateDomainOutput) SetAPI(v *APIForCreateDomainOutput) *ModuleQuickConfForCreateDomainOutput {
	s.API = v
	return s
}

// SetAutoCC sets the AutoCC field's value.
func (s *ModuleQuickConfForCreateDomainOutput) SetAutoCC(v *AutoCCForCreateDomainOutput) *ModuleQuickConfForCreateDomainOutput {
	s.AutoCC = v
	return s
}

// SetBotSequence sets the BotSequence field's value.
func (s *ModuleQuickConfForCreateDomainOutput) SetBotSequence(v *BotSequenceForCreateDomainOutput) *ModuleQuickConfForCreateDomainOutput {
	s.BotSequence = v
	return s
}

// SetSystemBot sets the SystemBot field's value.
func (s *ModuleQuickConfForCreateDomainOutput) SetSystemBot(v *SystemBotForCreateDomainOutput) *ModuleQuickConfForCreateDomainOutput {
	s.SystemBot = v
	return s
}

// SetVul sets the Vul field's value.
func (s *ModuleQuickConfForCreateDomainOutput) SetVul(v *VulForCreateDomainOutput) *ModuleQuickConfForCreateDomainOutput {
	s.Vul = v
	return s
}

type ProtocolPortsForCreateDomainInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	HTTP []*int32 `type:"list" json:",omitempty"`

	HTTPS []*int32 `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ProtocolPortsForCreateDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ProtocolPortsForCreateDomainInput) GoString() string {
	return s.String()
}

// SetHTTP sets the HTTP field's value.
func (s *ProtocolPortsForCreateDomainInput) SetHTTP(v []*int32) *ProtocolPortsForCreateDomainInput {
	s.HTTP = v
	return s
}

// SetHTTPS sets the HTTPS field's value.
func (s *ProtocolPortsForCreateDomainInput) SetHTTPS(v []*int32) *ProtocolPortsForCreateDomainInput {
	s.HTTPS = v
	return s
}

type SystemBotForCreateDomainOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SystemBotEnable *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s SystemBotForCreateDomainOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SystemBotForCreateDomainOutput) GoString() string {
	return s.String()
}

// SetSystemBotEnable sets the SystemBotEnable field's value.
func (s *SystemBotForCreateDomainOutput) SetSystemBotEnable(v int32) *SystemBotForCreateDomainOutput {
	s.SystemBotEnable = &v
	return s
}

type TLSFieldsConfigForCreateDomainInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	HeadersConfig *HeadersConfigForCreateDomainInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s TLSFieldsConfigForCreateDomainInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TLSFieldsConfigForCreateDomainInput) GoString() string {
	return s.String()
}

// SetHeadersConfig sets the HeadersConfig field's value.
func (s *TLSFieldsConfigForCreateDomainInput) SetHeadersConfig(v *HeadersConfigForCreateDomainInput) *TLSFieldsConfigForCreateDomainInput {
	s.HeadersConfig = v
	return s
}

type VulForCreateDomainOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Action *string `type:"string" json:",omitempty"`

	RuleMode *string `type:"string" json:",omitempty"`

	WafEnable *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s VulForCreateDomainOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VulForCreateDomainOutput) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *VulForCreateDomainOutput) SetAction(v string) *VulForCreateDomainOutput {
	s.Action = &v
	return s
}

// SetRuleMode sets the RuleMode field's value.
func (s *VulForCreateDomainOutput) SetRuleMode(v string) *VulForCreateDomainOutput {
	s.RuleMode = &v
	return s
}

// SetWafEnable sets the WafEnable field's value.
func (s *VulForCreateDomainOutput) SetWafEnable(v int32) *VulForCreateDomainOutput {
	s.WafEnable = &v
	return s
}
