// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vpn

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opModifyVpnConnectionHealthCheckerCommon = "ModifyVpnConnectionHealthChecker"

// ModifyVpnConnectionHealthCheckerCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ModifyVpnConnectionHealthCheckerCommon operation. The "output" return
// value will be populated with the ModifyVpnConnectionHealthCheckerCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ModifyVpnConnectionHealthCheckerCommon Request to send the API call to the service.
// the "output" return value is not valid until after ModifyVpnConnectionHealthCheckerCommon Send returns without error.
//
// See ModifyVpnConnectionHealthCheckerCommon for more information on using the ModifyVpnConnectionHealthCheckerCommon
// API call, and error handling.
//
//    // Example sending a request using the ModifyVpnConnectionHealthCheckerCommonRequest method.
//    req, resp := client.ModifyVpnConnectionHealthCheckerCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPN) ModifyVpnConnectionHealthCheckerCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opModifyVpnConnectionHealthCheckerCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// ModifyVpnConnectionHealthCheckerCommon API operation for VPN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPN's
// API operation ModifyVpnConnectionHealthCheckerCommon for usage and error information.
func (c *VPN) ModifyVpnConnectionHealthCheckerCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ModifyVpnConnectionHealthCheckerCommonRequest(input)
	return out, req.Send()
}

// ModifyVpnConnectionHealthCheckerCommonWithContext is the same as ModifyVpnConnectionHealthCheckerCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyVpnConnectionHealthCheckerCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPN) ModifyVpnConnectionHealthCheckerCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ModifyVpnConnectionHealthCheckerCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyVpnConnectionHealthChecker = "ModifyVpnConnectionHealthChecker"

// ModifyVpnConnectionHealthCheckerRequest generates a "volcengine/request.Request" representing the
// client's request for the ModifyVpnConnectionHealthChecker operation. The "output" return
// value will be populated with the ModifyVpnConnectionHealthCheckerCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ModifyVpnConnectionHealthCheckerCommon Request to send the API call to the service.
// the "output" return value is not valid until after ModifyVpnConnectionHealthCheckerCommon Send returns without error.
//
// See ModifyVpnConnectionHealthChecker for more information on using the ModifyVpnConnectionHealthChecker
// API call, and error handling.
//
//    // Example sending a request using the ModifyVpnConnectionHealthCheckerRequest method.
//    req, resp := client.ModifyVpnConnectionHealthCheckerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPN) ModifyVpnConnectionHealthCheckerRequest(input *ModifyVpnConnectionHealthCheckerInput) (req *request.Request, output *ModifyVpnConnectionHealthCheckerOutput) {
	op := &request.Operation{
		Name:       opModifyVpnConnectionHealthChecker,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyVpnConnectionHealthCheckerInput{}
	}

	output = &ModifyVpnConnectionHealthCheckerOutput{}
	req = c.newRequest(op, input, output)

	return
}

// ModifyVpnConnectionHealthChecker API operation for VPN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPN's
// API operation ModifyVpnConnectionHealthChecker for usage and error information.
func (c *VPN) ModifyVpnConnectionHealthChecker(input *ModifyVpnConnectionHealthCheckerInput) (*ModifyVpnConnectionHealthCheckerOutput, error) {
	req, out := c.ModifyVpnConnectionHealthCheckerRequest(input)
	return out, req.Send()
}

// ModifyVpnConnectionHealthCheckerWithContext is the same as ModifyVpnConnectionHealthChecker with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyVpnConnectionHealthChecker for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPN) ModifyVpnConnectionHealthCheckerWithContext(ctx volcengine.Context, input *ModifyVpnConnectionHealthCheckerInput, opts ...request.Option) (*ModifyVpnConnectionHealthCheckerOutput, error) {
	req, out := c.ModifyVpnConnectionHealthCheckerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ModifyVpnConnectionHealthCheckerInput struct {
	_ struct{} `type:"structure"`

	// CheckInterval is a required field
	CheckInterval *int64 `min:"3" max:"300" type:"integer" required:"true"`

	// CheckerId is a required field
	CheckerId *string `type:"string" required:"true"`

	ClientToken *string `type:"string"`

	DownTime *int64 `min:"1" max:"10" type:"integer"`

	LocalIp *string `type:"string"`

	RemoteIp *string `type:"string"`

	Timeout *int64 `min:"1" max:"300" type:"integer"`

	UpTime *int64 `type:"integer"`

	// VpnConnectionId is a required field
	VpnConnectionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyVpnConnectionHealthCheckerInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyVpnConnectionHealthCheckerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyVpnConnectionHealthCheckerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyVpnConnectionHealthCheckerInput"}
	if s.CheckInterval == nil {
		invalidParams.Add(request.NewErrParamRequired("CheckInterval"))
	}
	if s.CheckInterval != nil && *s.CheckInterval < 3 {
		invalidParams.Add(request.NewErrParamMinValue("CheckInterval", 3))
	}
	if s.CheckInterval != nil && *s.CheckInterval > 300 {
		invalidParams.Add(request.NewErrParamMaxValue("CheckInterval", 300))
	}
	if s.CheckerId == nil {
		invalidParams.Add(request.NewErrParamRequired("CheckerId"))
	}
	if s.DownTime != nil && *s.DownTime < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DownTime", 1))
	}
	if s.DownTime != nil && *s.DownTime > 10 {
		invalidParams.Add(request.NewErrParamMaxValue("DownTime", 10))
	}
	if s.Timeout != nil && *s.Timeout < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Timeout", 1))
	}
	if s.Timeout != nil && *s.Timeout > 300 {
		invalidParams.Add(request.NewErrParamMaxValue("Timeout", 300))
	}
	if s.VpnConnectionId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpnConnectionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCheckInterval sets the CheckInterval field's value.
func (s *ModifyVpnConnectionHealthCheckerInput) SetCheckInterval(v int64) *ModifyVpnConnectionHealthCheckerInput {
	s.CheckInterval = &v
	return s
}

// SetCheckerId sets the CheckerId field's value.
func (s *ModifyVpnConnectionHealthCheckerInput) SetCheckerId(v string) *ModifyVpnConnectionHealthCheckerInput {
	s.CheckerId = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *ModifyVpnConnectionHealthCheckerInput) SetClientToken(v string) *ModifyVpnConnectionHealthCheckerInput {
	s.ClientToken = &v
	return s
}

// SetDownTime sets the DownTime field's value.
func (s *ModifyVpnConnectionHealthCheckerInput) SetDownTime(v int64) *ModifyVpnConnectionHealthCheckerInput {
	s.DownTime = &v
	return s
}

// SetLocalIp sets the LocalIp field's value.
func (s *ModifyVpnConnectionHealthCheckerInput) SetLocalIp(v string) *ModifyVpnConnectionHealthCheckerInput {
	s.LocalIp = &v
	return s
}

// SetRemoteIp sets the RemoteIp field's value.
func (s *ModifyVpnConnectionHealthCheckerInput) SetRemoteIp(v string) *ModifyVpnConnectionHealthCheckerInput {
	s.RemoteIp = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *ModifyVpnConnectionHealthCheckerInput) SetTimeout(v int64) *ModifyVpnConnectionHealthCheckerInput {
	s.Timeout = &v
	return s
}

// SetUpTime sets the UpTime field's value.
func (s *ModifyVpnConnectionHealthCheckerInput) SetUpTime(v int64) *ModifyVpnConnectionHealthCheckerInput {
	s.UpTime = &v
	return s
}

// SetVpnConnectionId sets the VpnConnectionId field's value.
func (s *ModifyVpnConnectionHealthCheckerInput) SetVpnConnectionId(v string) *ModifyVpnConnectionHealthCheckerInput {
	s.VpnConnectionId = &v
	return s
}

type ModifyVpnConnectionHealthCheckerOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	RequestId *string `type:"string"`
}

// String returns the string representation
func (s ModifyVpnConnectionHealthCheckerOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyVpnConnectionHealthCheckerOutput) GoString() string {
	return s.String()
}

// SetRequestId sets the RequestId field's value.
func (s *ModifyVpnConnectionHealthCheckerOutput) SetRequestId(v string) *ModifyVpnConnectionHealthCheckerOutput {
	s.RequestId = &v
	return s
}
