// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vpc

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateInstanceGroupCommon = "CreateInstanceGroup"

// CreateInstanceGroupCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateInstanceGroupCommon operation. The "output" return
// value will be populated with the CreateInstanceGroupCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateInstanceGroupCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateInstanceGroupCommon Send returns without error.
//
// See CreateInstanceGroupCommon for more information on using the CreateInstanceGroupCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateInstanceGroupCommonRequest method.
//    req, resp := client.CreateInstanceGroupCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) CreateInstanceGroupCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateInstanceGroupCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// CreateInstanceGroupCommon API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation CreateInstanceGroupCommon for usage and error information.
func (c *VPC) CreateInstanceGroupCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateInstanceGroupCommonRequest(input)
	return out, req.Send()
}

// CreateInstanceGroupCommonWithContext is the same as CreateInstanceGroupCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInstanceGroupCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) CreateInstanceGroupCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateInstanceGroupCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInstanceGroup = "CreateInstanceGroup"

// CreateInstanceGroupRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateInstanceGroup operation. The "output" return
// value will be populated with the CreateInstanceGroupCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateInstanceGroupCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateInstanceGroupCommon Send returns without error.
//
// See CreateInstanceGroup for more information on using the CreateInstanceGroup
// API call, and error handling.
//
//    // Example sending a request using the CreateInstanceGroupRequest method.
//    req, resp := client.CreateInstanceGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) CreateInstanceGroupRequest(input *CreateInstanceGroupInput) (req *request.Request, output *CreateInstanceGroupOutput) {
	op := &request.Operation{
		Name:       opCreateInstanceGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstanceGroupInput{}
	}

	output = &CreateInstanceGroupOutput{}
	req = c.newRequest(op, input, output)

	return
}

// CreateInstanceGroup API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation CreateInstanceGroup for usage and error information.
func (c *VPC) CreateInstanceGroup(input *CreateInstanceGroupInput) (*CreateInstanceGroupOutput, error) {
	req, out := c.CreateInstanceGroupRequest(input)
	return out, req.Send()
}

// CreateInstanceGroupWithContext is the same as CreateInstanceGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInstanceGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) CreateInstanceGroupWithContext(ctx volcengine.Context, input *CreateInstanceGroupInput, opts ...request.Option) (*CreateInstanceGroupOutput, error) {
	req, out := c.CreateInstanceGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateInstanceGroupInput struct {
	_ struct{} `type:"structure"`

	Description *string `min:"1" max:"255" type:"string"`

	Name *string `min:"1" max:"128" type:"string"`

	// VpcId is a required field
	VpcId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateInstanceGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstanceGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInstanceGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInstanceGroupInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Description != nil && len(*s.Description) > 255 {
		invalidParams.Add(request.NewErrParamMaxLen("Description", 255, *s.Description))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Name != nil && len(*s.Name) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("Name", 128, *s.Name))
	}
	if s.VpcId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateInstanceGroupInput) SetDescription(v string) *CreateInstanceGroupInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateInstanceGroupInput) SetName(v string) *CreateInstanceGroupInput {
	s.Name = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *CreateInstanceGroupInput) SetVpcId(v string) *CreateInstanceGroupInput {
	s.VpcId = &v
	return s
}

type CreateInstanceGroupOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	InstanceGroupId *string `type:"string"`

	RequestId *string `type:"string"`
}

// String returns the string representation
func (s CreateInstanceGroupOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstanceGroupOutput) GoString() string {
	return s.String()
}

// SetInstanceGroupId sets the InstanceGroupId field's value.
func (s *CreateInstanceGroupOutput) SetInstanceGroupId(v string) *CreateInstanceGroupOutput {
	s.InstanceGroupId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateInstanceGroupOutput) SetRequestId(v string) *CreateInstanceGroupOutput {
	s.RequestId = &v
	return s
}
