// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vpc

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opAllocateIpv6AddressBandwidthCommon = "AllocateIpv6AddressBandwidth"

// AllocateIpv6AddressBandwidthCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the AllocateIpv6AddressBandwidthCommon operation. The "output" return
// value will be populated with the AllocateIpv6AddressBandwidthCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned AllocateIpv6AddressBandwidthCommon Request to send the API call to the service.
// the "output" return value is not valid until after AllocateIpv6AddressBandwidthCommon Send returns without error.
//
// See AllocateIpv6AddressBandwidthCommon for more information on using the AllocateIpv6AddressBandwidthCommon
// API call, and error handling.
//
//    // Example sending a request using the AllocateIpv6AddressBandwidthCommonRequest method.
//    req, resp := client.AllocateIpv6AddressBandwidthCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) AllocateIpv6AddressBandwidthCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opAllocateIpv6AddressBandwidthCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// AllocateIpv6AddressBandwidthCommon API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation AllocateIpv6AddressBandwidthCommon for usage and error information.
func (c *VPC) AllocateIpv6AddressBandwidthCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.AllocateIpv6AddressBandwidthCommonRequest(input)
	return out, req.Send()
}

// AllocateIpv6AddressBandwidthCommonWithContext is the same as AllocateIpv6AddressBandwidthCommon with the addition of
// the ability to pass a context and additional request options.
//
// See AllocateIpv6AddressBandwidthCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) AllocateIpv6AddressBandwidthCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.AllocateIpv6AddressBandwidthCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAllocateIpv6AddressBandwidth = "AllocateIpv6AddressBandwidth"

// AllocateIpv6AddressBandwidthRequest generates a "volcengine/request.Request" representing the
// client's request for the AllocateIpv6AddressBandwidth operation. The "output" return
// value will be populated with the AllocateIpv6AddressBandwidthCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned AllocateIpv6AddressBandwidthCommon Request to send the API call to the service.
// the "output" return value is not valid until after AllocateIpv6AddressBandwidthCommon Send returns without error.
//
// See AllocateIpv6AddressBandwidth for more information on using the AllocateIpv6AddressBandwidth
// API call, and error handling.
//
//    // Example sending a request using the AllocateIpv6AddressBandwidthRequest method.
//    req, resp := client.AllocateIpv6AddressBandwidthRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VPC) AllocateIpv6AddressBandwidthRequest(input *AllocateIpv6AddressBandwidthInput) (req *request.Request, output *AllocateIpv6AddressBandwidthOutput) {
	op := &request.Operation{
		Name:       opAllocateIpv6AddressBandwidth,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocateIpv6AddressBandwidthInput{}
	}

	output = &AllocateIpv6AddressBandwidthOutput{}
	req = c.newRequest(op, input, output)

	return
}

// AllocateIpv6AddressBandwidth API operation for VPC.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VPC's
// API operation AllocateIpv6AddressBandwidth for usage and error information.
func (c *VPC) AllocateIpv6AddressBandwidth(input *AllocateIpv6AddressBandwidthInput) (*AllocateIpv6AddressBandwidthOutput, error) {
	req, out := c.AllocateIpv6AddressBandwidthRequest(input)
	return out, req.Send()
}

// AllocateIpv6AddressBandwidthWithContext is the same as AllocateIpv6AddressBandwidth with the addition of
// the ability to pass a context and additional request options.
//
// See AllocateIpv6AddressBandwidth for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VPC) AllocateIpv6AddressBandwidthWithContext(ctx volcengine.Context, input *AllocateIpv6AddressBandwidthInput, opts ...request.Option) (*AllocateIpv6AddressBandwidthOutput, error) {
	req, out := c.AllocateIpv6AddressBandwidthRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AllocateIpv6AddressBandwidthInput struct {
	_ struct{} `type:"structure"`

	Bandwidth *int64 `min:"1" type:"integer"`

	BandwidthPackageId *string `type:"string"`

	// BillingType is a required field
	BillingType *int64 `type:"integer" required:"true"`

	ClientToken *string `type:"string"`

	// Ipv6Address is a required field
	Ipv6Address *string `type:"string" required:"true"`

	ProjectName *string `type:"string"`

	Tags []*TagForAllocateIpv6AddressBandwidthInput `type:"list"`
}

// String returns the string representation
func (s AllocateIpv6AddressBandwidthInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocateIpv6AddressBandwidthInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AllocateIpv6AddressBandwidthInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AllocateIpv6AddressBandwidthInput"}
	if s.Bandwidth != nil && *s.Bandwidth < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Bandwidth", 1))
	}
	if s.BillingType == nil {
		invalidParams.Add(request.NewErrParamRequired("BillingType"))
	}
	if s.Ipv6Address == nil {
		invalidParams.Add(request.NewErrParamRequired("Ipv6Address"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBandwidth sets the Bandwidth field's value.
func (s *AllocateIpv6AddressBandwidthInput) SetBandwidth(v int64) *AllocateIpv6AddressBandwidthInput {
	s.Bandwidth = &v
	return s
}

// SetBandwidthPackageId sets the BandwidthPackageId field's value.
func (s *AllocateIpv6AddressBandwidthInput) SetBandwidthPackageId(v string) *AllocateIpv6AddressBandwidthInput {
	s.BandwidthPackageId = &v
	return s
}

// SetBillingType sets the BillingType field's value.
func (s *AllocateIpv6AddressBandwidthInput) SetBillingType(v int64) *AllocateIpv6AddressBandwidthInput {
	s.BillingType = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *AllocateIpv6AddressBandwidthInput) SetClientToken(v string) *AllocateIpv6AddressBandwidthInput {
	s.ClientToken = &v
	return s
}

// SetIpv6Address sets the Ipv6Address field's value.
func (s *AllocateIpv6AddressBandwidthInput) SetIpv6Address(v string) *AllocateIpv6AddressBandwidthInput {
	s.Ipv6Address = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *AllocateIpv6AddressBandwidthInput) SetProjectName(v string) *AllocateIpv6AddressBandwidthInput {
	s.ProjectName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AllocateIpv6AddressBandwidthInput) SetTags(v []*TagForAllocateIpv6AddressBandwidthInput) *AllocateIpv6AddressBandwidthInput {
	s.Tags = v
	return s
}

type AllocateIpv6AddressBandwidthOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	AllocationId *string `type:"string"`

	RequestId *string `type:"string"`
}

// String returns the string representation
func (s AllocateIpv6AddressBandwidthOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocateIpv6AddressBandwidthOutput) GoString() string {
	return s.String()
}

// SetAllocationId sets the AllocationId field's value.
func (s *AllocateIpv6AddressBandwidthOutput) SetAllocationId(v string) *AllocateIpv6AddressBandwidthOutput {
	s.AllocationId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *AllocateIpv6AddressBandwidthOutput) SetRequestId(v string) *AllocateIpv6AddressBandwidthOutput {
	s.RequestId = &v
	return s
}

type TagForAllocateIpv6AddressBandwidthInput struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s TagForAllocateIpv6AddressBandwidthInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForAllocateIpv6AddressBandwidthInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForAllocateIpv6AddressBandwidthInput) SetKey(v string) *TagForAllocateIpv6AddressBandwidthInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForAllocateIpv6AddressBandwidthInput) SetValue(v string) *TagForAllocateIpv6AddressBandwidthInput {
	s.Value = &v
	return s
}
